/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.dashboard.DashboardManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.ViewSequenceUtils;

public class ExternalAccessServlet
extends BaseServlet {
    private static final long serialVersionUID = -4118907921337237802L;
    private static Log logger = LogFactory.getLog(ExternalAccessServlet.class);
    public static final String OUTCOME_DOCDETAILS = "showDocDetails";
    public static final String OUTCOME_SPACEDETAILS = "showSpaceDetails";
    public static final String OUTCOME_BROWSE = "browse";
    public static final String OUTCOME_MYALFRESCO = "myalfresco";
    public static final String OUTCOME_LOGOUT = "logout";
    public static final String OUTCOME_DIALOG = "dialog";
    public static final String OUTCOME_WIZARD = "wizard";
    private static final String ARG_TEMPLATE = "template";
    private static final String ARG_PAGE = "page";
    private static final String EXTERNAL_URL = "/n/{0}";
    private static final String EXTERNAL_URL_ARGS = "/n/{0}/{1}";

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        NavigationHandler navigationHandler;
        NodeRef nodeRef;
        AuthenticationStatus status;
        String uri = req.getRequestURI();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing URL: " + uri + (req.getQueryString() != null ? "?" + req.getQueryString() : "")));
        }
        if ((status = this.servletAuthenticate(req, res)) == AuthenticationStatus.Failure) {
            return;
        }
        ExternalAccessServlet.setNoCacheHeaders(res);
        uri = uri.substring(req.getContextPath().length());
        StringTokenizer t = new StringTokenizer(uri, "/");
        int tokenCount = t.countTokens();
        if (tokenCount < 2) {
            throw new IllegalArgumentException("Externally addressable URL did not contain all required args: " + uri);
        }
        t.nextToken();
        String outcome = t.nextToken();
        String[] args = new String[tokenCount - 2];
        for (int i = 0; i < tokenCount - 2; ++i) {
            args[i] = t.nextToken();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("External outcome found: " + outcome));
        }
        FacesContext fc = FacesHelper.getFacesContext((ServletRequest)req, (ServletResponse)res, this.getServletContext());
        BrowseBean browseBean = (BrowseBean)FacesHelper.getManagedBean(fc, "BrowseBean");
        ServiceRegistry serviceRegistry = ExternalAccessServlet.getServiceRegistry(this.getServletContext());
        PermissionService permissionService = serviceRegistry.getPermissionService();
        Stack viewStack = (Stack)fc.getExternalContext().getSessionMap().get("_alfViewStack");
        if (viewStack != null) {
            viewStack.clear();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cleared view stack");
            }
        }
        if (OUTCOME_DOCDETAILS.equals(outcome)) {
            nodeRef = null;
            if (args[0].equals("webdav")) {
                nodeRef = ExternalAccessServlet.resolveWebDAVPath(fc, args);
            } else if (args.length == 3) {
                StoreRef storeRef = new StoreRef(args[0], args[1]);
                nodeRef = new NodeRef(storeRef, args[2]);
            }
            if (nodeRef != null) {
                if (!this.checkAccess(req, res, nodeRef, "ReadContent", true)) {
                    return;
                }
                browseBean.setupContentAction(nodeRef.getId(), true);
            }
            NavigationHandler navigationHandler2 = fc.getApplication().getNavigationHandler();
            navigationHandler2.handleNavigation(fc, null, "dialog:showDocDetails");
        } else if (OUTCOME_SPACEDETAILS.equals(outcome)) {
            nodeRef = null;
            if (args[0].equals("webdav")) {
                nodeRef = ExternalAccessServlet.resolveWebDAVPath(fc, args);
            } else if (args.length == 3) {
                StoreRef storeRef = new StoreRef(args[0], args[1]);
                nodeRef = new NodeRef(storeRef, args[2]);
            }
            if (nodeRef != null) {
                if (!this.checkAccess(req, res, nodeRef, "ReadContent", true)) {
                    return;
                }
                browseBean.setupSpaceAction(nodeRef.getId(), true);
            }
            NavigationHandler navigationHandler3 = fc.getApplication().getNavigationHandler();
            navigationHandler3.handleNavigation(fc, null, "dialog:showSpaceDetails");
        } else if (OUTCOME_BROWSE.equals(outcome)) {
            nodeRef = null;
            if (args.length != 0 && args[0].equals("webdav")) {
                nodeRef = ExternalAccessServlet.resolveWebDAVPath(fc, args);
            } else if (args.length >= 3) {
                int offset = 0;
                offset = args.length - 3;
                StoreRef storeRef = new StoreRef(args[0 + offset], args[1 + offset]);
                nodeRef = new NodeRef(storeRef, args[2 + offset]);
            }
            if (nodeRef != null) {
                if (!this.checkAccess(req, res, nodeRef, "ReadContent", true)) {
                    return;
                }
                browseBean.updateUILocation(nodeRef);
                browseBean.externalAccessRefresh();
                if (args[0].equals(ARG_TEMPLATE)) {
                    browseBean.setDashboardView(true);
                }
            } else {
                NavigationHandler navigationHandler4 = fc.getApplication().getNavigationHandler();
                navigationHandler4.handleNavigation(fc, null, outcome);
            }
        } else if (OUTCOME_MYALFRESCO.equals(outcome)) {
            if (req.getParameter(ARG_PAGE) != null) {
                DashboardManager manager = (DashboardManager)FacesHelper.getManagedBean(fc, "DashboardManager");
                manager.getPageConfig().setCurrentPage(req.getParameter(ARG_PAGE));
            }
            navigationHandler = fc.getApplication().getNavigationHandler();
            navigationHandler.handleNavigation(fc, null, outcome);
        } else if (OUTCOME_DIALOG.equals(outcome) || OUTCOME_WIZARD.equals(outcome)) {
            if (args.length != 0) {
                if (args.length > 1) {
                    String currentNodeId = null;
                    if (args[1].equals("webdav")) {
                        String[] args2 = new String[args.length - 1];
                        for (int i = 1; i < args.length; ++i) {
                            args2[i - 1] = args[i];
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Added segment " + args2[i - 1]));
                        }
                        NodeRef nodeRef2 = ExternalAccessServlet.resolveWebDAVPath(fc, args2);
                        currentNodeId = nodeRef2.getId();
                    } else {
                        currentNodeId = args[1];
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("currentNodeId: " + currentNodeId));
                    }
                    NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
                    navigator.setCurrentNodeId(currentNodeId);
                    browseBean.setupSpaceAction(currentNodeId, true);
                    browseBean.setupContentAction(currentNodeId, true);
                }
                navigationHandler = fc.getApplication().getNavigationHandler();
                navigationHandler.handleNavigation(fc, null, outcome + ':' + args[0]);
            }
        } else if (OUTCOME_LOGOUT.equals(outcome)) {
            Application.logOut(fc);
            res.sendRedirect(req.getContextPath() + "/faces" + Application.getLoginPage(this.getServletContext()));
            return;
        }
        String viewId = fc.getViewRoot().getViewId();
        ViewSequenceUtils.nextViewSequence((FacesContext)fc);
        this.getServletContext().getRequestDispatcher("/faces" + viewId).forward((ServletRequest)req, (ServletResponse)res);
    }

    public static final String generateExternalURL(String outcome, String args) {
        if (args == null) {
            return MessageFormat.format(EXTERNAL_URL, outcome);
        }
        return MessageFormat.format(EXTERNAL_URL_ARGS, outcome, args);
    }
}

