/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.extensions.surf.util.I18NUtil;

public class GlobalLocalizationFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        this.setLanguageFromRequestHeader(httpRequest);
        chain.doFilter(request, response);
    }

    public void setLanguageFromRequestHeader(HttpServletRequest req) {
        Locale locale = null;
        String acceptLang = req.getHeader("Accept-Language");
        if (acceptLang != null && acceptLang.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(acceptLang, ",; ");
            String language = tokenizer.nextToken().replace('-', '_');
            locale = I18NUtil.parseLocale((String)language);
            I18NUtil.setLocale((Locale)locale);
        } else {
            I18NUtil.setLocale((Locale)Locale.getDefault());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

