/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadContentServlet
extends BaseServlet {
    private static final long serialVersionUID = 1055960980867420355L;
    private static Log logger = LogFactory.getLog(UploadContentServlet.class);
    protected static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String ARG_PROPERTY = "property";
    protected static final String ARG_MIMETYPE = "mimetype";
    protected static final String ARG_ENCODING = "encoding";

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String encoding;
        AuthenticationStatus status;
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Authenticating request to URL: " + req.getRequestURI() + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        if ((status = this.servletAuthenticate(req, res, false)) == AuthenticationStatus.Failure || status == AuthenticationStatus.Guest) {
            res.sendError(401);
            return;
        }
        String uri = req.getRequestURI();
        uri = uri.substring(req.getContextPath().length());
        StringTokenizer t = new StringTokenizer(uri, "/");
        int tokenCount = t.countTokens();
        t.nextToken();
        NodeRef nodeRef = null;
        String filename = null;
        QName propertyQName = null;
        if (tokenCount == 2) {
            filename = t.nextToken();
        } else if (tokenCount == 4 || tokenCount == 5) {
            StoreRef storeRef = new StoreRef(t.nextToken(), t.nextToken());
            String id = t.nextToken();
            nodeRef = new NodeRef(storeRef, id);
            if (tokenCount == 5) {
                filename = t.nextToken();
            }
            propertyQName = ContentModel.PROP_CONTENT;
            String property = req.getParameter(ARG_PROPERTY);
            if (property != null && property.length() != 0) {
                propertyQName = QName.createQName((String)property);
            }
        } else {
            logger.debug((Object)("Upload URL did not contain all required args: " + uri));
            res.sendError(417);
            return;
        }
        ServiceRegistry serviceRegistry = UploadContentServlet.getServiceRegistry(this.getServletContext());
        ContentService contentService = serviceRegistry.getContentService();
        PermissionService permissionService = serviceRegistry.getPermissionService();
        MimetypeService mimetypeService = serviceRegistry.getMimetypeService();
        ServletInputStream is = req.getInputStream();
        BufferedInputStream inputStream = new BufferedInputStream((InputStream)is);
        String mimetype = req.getParameter(ARG_MIMETYPE);
        if (mimetype == null || mimetype.length() == 0) {
            mimetype = MIMETYPE_OCTET_STREAM;
            if (filename != null) {
                MimetypeService mimetypeMap = serviceRegistry.getMimetypeService();
                int extIndex = filename.lastIndexOf(46);
                if (extIndex != -1) {
                    String ext = filename.substring(extIndex + 1);
                    mimetype = mimetypeService.getMimetype(ext);
                }
            }
        }
        if ((encoding = req.getParameter(ARG_ENCODING)) == null || encoding.length() == 0) {
            ContentCharsetFinder charsetFinder = mimetypeService.getContentCharsetFinder();
            Charset charset = charsetFinder.getCharset((InputStream)inputStream, mimetype);
            encoding = charset.name();
        }
        if (logger.isDebugEnabled()) {
            if (nodeRef != null) {
                logger.debug((Object)("Found NodeRef: " + nodeRef.toString()));
            }
            logger.debug((Object)("For property: " + propertyQName));
            logger.debug((Object)("File name: " + filename));
            logger.debug((Object)("Mimetype: " + mimetype));
            logger.debug((Object)("Encoding: " + encoding));
        }
        if (permissionService.hasPermission(nodeRef, "WriteContent") == AccessStatus.DENIED) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User does not have permissions to wrtie content for NodeRef: " + nodeRef.toString()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Returning 403 Forbidden error...");
            }
            res.sendError(403);
            return;
        }
        ContentWriter writer = contentService.getWriter(nodeRef, propertyQName, true);
        if (writer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content writer cannot be obtained for NodeRef: " + nodeRef.toString()));
            }
            res.sendError(417);
            return;
        }
        writer.setMimetype(mimetype);
        writer.setEncoding(encoding);
        writer.putContent((InputStream)inputStream);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Content details: " + writer.getContentData().toString()));
        }
        res.getWriter().write(writer.getContentData().toString());
        res.flushBuffer();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"UploadContentServlet done");
        }
    }
}

