/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.ajax;

import java.io.IOException;
import java.util.Enumeration;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.ajax.BaseAjaxCommand;
import org.alfresco.web.app.servlet.ajax.GetCommand;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxServlet
extends BaseServlet {
    public static final String AJAX_LOG_KEY = "alfresco.ajax";
    private static final long serialVersionUID = -7654769105419391840L;
    private static Log logger = LogFactory.getLog((String)"alfresco.ajax");
    private static Log headersLogger = LogFactory.getLog((String)"alfresco.ajax.headers");
    private static Log perfLogger = LogFactory.getLog((String)"alfresco.ajax.performance");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("utf-8");
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/xml;charset=UTF-8");
        long startTime = 0L;
        String uri = request.getRequestURI();
        if (logger.isDebugEnabled()) {
            String queryString = request.getQueryString();
            logger.debug((Object)("Processing URL: " + uri + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        if (headersLogger.isDebugEnabled()) {
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                headersLogger.debug((Object)(name + ": " + request.getHeader(name)));
            }
        }
        try {
            AuthenticationStatus status = this.servletAuthenticate(request, response, false);
            if (status == AuthenticationStatus.Failure) {
                response.sendError(401, "Access Denied: User not authenticated");
                return;
            }
            AjaxServlet.setNoCacheHeaders(response);
            uri = uri.substring(request.getContextPath().length() + "/".length());
            String[] tokens = uri.split("/");
            if (tokens.length < 3) {
                throw new AlfrescoRuntimeException("Servlet URL did not contain all required args: " + uri);
            }
            String commandName = tokens[1];
            String expression = tokens[2];
            FacesContext facesContext = FacesHelper.getFacesContext((ServletRequest)request, (ServletResponse)response, this.getServletContext());
            if (perfLogger.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            BaseAjaxCommand command = null;
            if (Command.invoke.toString().equals(commandName)) {
                command = new InvokeCommand();
            } else if (Command.get.toString().equals(commandName)) {
                command = new GetCommand();
            } else {
                throw new AlfrescoRuntimeException("Unrecognised command received: " + commandName);
            }
            command.execute(facesContext, expression, request, response);
        }
        catch (RuntimeException error) {
            this.handleError(response, error);
        }
        finally {
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug((Object)("Time to execute command: " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
    }

    protected void handleError(HttpServletResponse response, RuntimeException cause) throws ServletException, IOException {
        String msg;
        if (!response.isCommitted()) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)cause);
                Throwable theCause = cause.getCause();
                if (theCause != null) {
                    logger.error((Object)"caused by: ", theCause);
                }
            }
            if ((msg = cause.getMessage()) == null) {
                msg = cause.toString();
            }
        } else {
            throw cause;
        }
        response.sendError(500, msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Command {
        invoke,
        get,
        set;

    }
}

