/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.command.BaseUIActionCommand;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wizard.WizardManager;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWebContentCommand
extends BaseUIActionCommand {
    public static final String PROP_WEBPROJECTID = "webproject";
    public static final String PROP_SANDBOX = "sandbox";
    public static final String PROP_FORMNAME = "form";
    private static final String[] PROPERTIES = new String[]{"ServletContext", "Request", "Response", "webproject", "sandbox", "form"};

    @Override
    public Object execute(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        ServletContext sc = (ServletContext)properties.get("ServletContext");
        ServletRequest req = (ServletRequest)properties.get("Request");
        ServletResponse res = (ServletResponse)properties.get("Response");
        FacesContext fc = FacesHelper.getFacesContext(req, res, sc);
        AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
        NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
        String webProjectId = (String)properties.get(PROP_WEBPROJECTID);
        ParameterCheck.mandatoryString((String)PROP_WEBPROJECTID, (String)webProjectId);
        String sandbox = (String)properties.get(PROP_SANDBOX);
        ParameterCheck.mandatoryString((String)PROP_SANDBOX, (String)sandbox);
        navigator.setCurrentNodeId(webProjectId);
        avmBrowseBean.setSandbox(sandbox);
        String formName = (String)properties.get(PROP_FORMNAME);
        if (formName != null && formName.length() != 0) {
            WizardManager manager = (WizardManager)FacesHelper.getManagedBean(fc, "WizardManager");
            HashMap<String, String> params = new HashMap<String, String>(1, 1.0f);
            params.put("form-name", formName);
            manager.setupParameters(params);
        }
        NavigationHandler navigationHandler = fc.getApplication().getNavigationHandler();
        navigationHandler.handleNavigation(fc, null, "wizard:createWebContent");
        String viewId = fc.getViewRoot().getViewId();
        try {
            sc.getRequestDispatcher("/faces" + viewId).forward(req, res);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to forward to viewId: " + viewId, (Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return PROPERTIES;
    }
}

