/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.command.Command;
import org.alfresco.web.app.servlet.command.CommandFactory;
import org.alfresco.web.app.servlet.command.CreateWebContentCommand;
import org.alfresco.web.app.servlet.command.EditContentPropertiesCommand;
import org.alfresco.web.app.servlet.command.EditWebContentCommand;
import org.alfresco.web.app.servlet.command.ExtCommandProcessor;
import org.alfresco.web.app.servlet.command.ManageTaskDialogCommand;
import org.alfresco.web.app.servlet.command.UserProfileDialogCommand;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIActionCommandProcessor
implements ExtCommandProcessor {
    public static final String PARAM_CONTAINER = "container";
    private ServletContext sc = null;
    private String command = null;
    private Map<String, String> args = null;

    @Override
    public boolean validateArguments(ServletContext sc, String command, Map<String, String> args, String[] urlElements) {
        this.sc = sc;
        if (args.size() != 0) {
            this.args = new HashMap<String, String>(args);
        }
        return true;
    }

    @Override
    public void process(ServiceRegistry serviceRegistry, HttpServletRequest request, String command) {
    }

    @Override
    public void process(ServiceRegistry serviceRegistry, HttpServletRequest request, HttpServletResponse response, String command) {
        Command cmd;
        HashMap<String, Object> properties = new HashMap<String, Object>(this.args);
        properties.put("ServletContext", (String)this.sc);
        properties.put("Request", (String)request);
        properties.put("Response", (String)response);
        String container = request.getParameter(PARAM_CONTAINER);
        if (container != null && container.equalsIgnoreCase("plain")) {
            request.getSession().setAttribute("externalDialogContainer", (Object)Boolean.TRUE);
        }
        if ((cmd = CommandFactory.getInstance().createCommand(command)) == null) {
            throw new AlfrescoRuntimeException("Unregistered UI Action command specified: " + command);
        }
        cmd.execute(serviceRegistry, properties);
        this.command = command;
    }

    @Override
    public void outputStatus(PrintWriter out) {
        out.print("UI Action command: '");
        out.print(Utils.encode((String)this.command));
        out.print("' executed with args: ");
        out.println(this.args != null ? Utils.encode((String)this.args.toString()) : "");
    }

    static {
        CommandFactory.getInstance().registerCommand("createwebcontent", CreateWebContentCommand.class);
        CommandFactory.getInstance().registerCommand("editwebcontent", EditWebContentCommand.class);
        CommandFactory.getInstance().registerCommand("managetask", ManageTaskDialogCommand.class);
        CommandFactory.getInstance().registerCommand("editcontentprops", EditContentPropertiesCommand.class);
        CommandFactory.getInstance().registerCommand("userprofile", UserProfileDialogCommand.class);
    }
}

