/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.BaseActionWizard;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFeaturesHandler
extends BaseActionHandler {
    private static final long serialVersionUID = -2062128886273060606L;
    protected static final String PROP_ASPECT = "aspect";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("add-features");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoParams) {
        QName aspect = Repository.resolveToQName((String)((Object)actionProps.get(PROP_ASPECT)));
        repoParams.put("aspect-name", (Serializable)aspect);
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoParams) {
        QName aspect = (QName)repoParams.get("aspect-name");
        actionProps.put(PROP_ASPECT, (Serializable)((Object)aspect.toString()));
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        String label = null;
        String aspect = (String)((Object)actionProps.get(PROP_ASPECT));
        for (SelectItem item : ((BaseActionWizard)wizard).getAddableAspects()) {
            if (!item.getValue().equals(aspect)) continue;
            label = item.getLabel();
            break;
        }
        return MessageFormat.format(Application.getMessage(context, "action_add_features"), label);
    }
}

