/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWorkflowHandler
extends BaseActionHandler {
    private static final long serialVersionUID = 2477573776900075171L;
    public static final String PROP_APPROVE_STEP_NAME = "approveStepName";
    public static final String PROP_APPROVE_ACTION = "approveAction";
    public static final String PROP_APPROVE_FOLDER = "approveFolder";
    public static final String PROP_REJECT_STEP_PRESENT = "rejectStepPresent";
    public static final String PROP_REJECT_STEP_NAME = "rejectStepName";
    public static final String PROP_REJECT_ACTION = "rejectAction";
    public static final String PROP_REJECT_FOLDER = "rejectFolder";

    @Override
    public void setupUIDefaults(Map<String, Serializable> actionProps) {
        actionProps.put(PROP_APPROVE_ACTION, (Serializable)((Object)"move"));
        actionProps.put(PROP_REJECT_STEP_PRESENT, (Serializable)((Object)"yes"));
        actionProps.put(PROP_REJECT_ACTION, (Serializable)((Object)"move"));
    }

    @Override
    public String getJSPPath() {
        return this.getJSPPath("simple-workflow");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        repoProps.put("approve-step", (Serializable)((Object)((String)((Object)actionProps.get(PROP_APPROVE_STEP_NAME)))));
        boolean approveMove = true;
        String approveAction = (String)((Object)actionProps.get(PROP_APPROVE_ACTION));
        if (approveAction != null && approveAction.equals("copy")) {
            approveMove = false;
        }
        repoProps.put("approve-move", Boolean.valueOf(approveMove));
        NodeRef approveDestNodeRef = null;
        Serializable approveDestNode = actionProps.get(PROP_APPROVE_FOLDER);
        if (approveDestNode instanceof NodeRef) {
            approveDestNodeRef = (NodeRef)approveDestNode;
        } else if (approveDestNode instanceof String) {
            approveDestNodeRef = new NodeRef((String)((Object)approveDestNode));
        }
        repoProps.put("approve-folder", (Serializable)approveDestNodeRef);
        boolean requireReject = true;
        String rejectStepPresent = (String)((Object)actionProps.get(PROP_REJECT_STEP_PRESENT));
        if (rejectStepPresent != null && rejectStepPresent.equals("no")) {
            requireReject = false;
        }
        if (requireReject) {
            repoProps.put("reject-step", (Serializable)((Object)((String)((Object)actionProps.get(PROP_REJECT_STEP_NAME)))));
            boolean rejectMove = true;
            String rejectAction = (String)((Object)actionProps.get(PROP_REJECT_ACTION));
            if (rejectAction != null && rejectAction.equals("copy")) {
                rejectMove = false;
            }
            repoProps.put("reject-move", Boolean.valueOf(rejectMove));
            NodeRef rejectDestNodeRef = null;
            Serializable rejectDestNode = actionProps.get(PROP_REJECT_FOLDER);
            if (rejectDestNode instanceof NodeRef) {
                rejectDestNodeRef = (NodeRef)rejectDestNode;
            } else if (rejectDestNode instanceof String) {
                rejectDestNodeRef = new NodeRef((String)((Object)rejectDestNode));
            }
            repoProps.put("reject-folder", (Serializable)rejectDestNodeRef);
        }
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        String approveStep = (String)((Object)repoProps.get("approve-step"));
        Boolean approveMove = (Boolean)repoProps.get("approve-move");
        NodeRef approveFolderNode = (NodeRef)repoProps.get("approve-folder");
        String rejectStep = (String)((Object)repoProps.get("reject-step"));
        Boolean rejectMove = (Boolean)repoProps.get("reject-move");
        NodeRef rejectFolderNode = (NodeRef)repoProps.get("reject-folder");
        actionProps.put(PROP_APPROVE_STEP_NAME, (Serializable)((Object)approveStep));
        actionProps.put(PROP_APPROVE_ACTION, (Serializable)((Object)(approveMove != false ? "move" : "copy")));
        actionProps.put(PROP_APPROVE_FOLDER, (Serializable)approveFolderNode);
        if (rejectStep == null && rejectMove == null && rejectFolderNode == null) {
            actionProps.put(PROP_REJECT_STEP_PRESENT, (Serializable)((Object)"no"));
            actionProps.put(PROP_REJECT_ACTION, (Serializable)((Object)"move"));
        } else {
            actionProps.put(PROP_REJECT_STEP_PRESENT, (Serializable)((Object)"yes"));
            actionProps.put(PROP_REJECT_STEP_NAME, (Serializable)((Object)rejectStep));
            actionProps.put(PROP_REJECT_ACTION, (Serializable)((Object)(rejectMove != false ? "move" : "copy")));
            actionProps.put(PROP_REJECT_FOLDER, (Serializable)rejectFolderNode);
        }
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
        String approveStepName = (String)((Object)actionProps.get(PROP_APPROVE_STEP_NAME));
        String approveAction = (String)((Object)actionProps.get(PROP_APPROVE_ACTION));
        NodeRef approveFolder = (NodeRef)actionProps.get(PROP_APPROVE_FOLDER);
        String approveFolderName = Repository.getNameForNode(nodeService, approveFolder);
        String approveMsg = MessageFormat.format(Application.getMessage(context, "action_simple_workflow"), Application.getMessage(context, approveAction), approveFolderName, approveStepName);
        String rejectMsg = null;
        String rejectStep = (String)((Object)actionProps.get(PROP_REJECT_STEP_PRESENT));
        if (rejectStep != null && "yes".equals(rejectStep)) {
            String rejectStepName = (String)((Object)actionProps.get(PROP_REJECT_STEP_NAME));
            String rejectAction = (String)((Object)actionProps.get(PROP_REJECT_ACTION));
            NodeRef rejectFolder = (NodeRef)actionProps.get(PROP_REJECT_FOLDER);
            String rejectFolderName = Repository.getNameForNode(nodeService, rejectFolder);
            rejectMsg = MessageFormat.format(Application.getMessage(context, "action_simple_workflow"), Application.getMessage(context, rejectAction), rejectFolderName, rejectStepName);
        }
        StringBuilder builder = new StringBuilder(approveMsg);
        if (rejectMsg != null) {
            builder.append(" ");
            builder.append(rejectMsg);
        }
        return builder.toString();
    }
}

