/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.BaseActionWizard;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformImageHandler
extends BaseActionHandler {
    private static final long serialVersionUID = 7729555214101161605L;
    protected static final String PROP_IMAGE_TRANSFORMER = "imageTransformer";
    protected static final String PROP_TRANSFORM_OPTIONS = "transformOptions";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("transform-image");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        repoProps.put("mime-type", actionProps.get(PROP_IMAGE_TRANSFORMER));
        repoProps.put("convert-command", actionProps.get(PROP_TRANSFORM_OPTIONS));
        NodeRef destNodeRef = (NodeRef)actionProps.get("destinationLocation");
        repoProps.put("destination-folder", (Serializable)destNodeRef);
        repoProps.put("assoc-type", (Serializable)ContentModel.ASSOC_CONTAINS);
        repoProps.put("assoc-name", (Serializable)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"copy"));
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        String transformer = (String)((Object)repoProps.get("mime-type"));
        actionProps.put(PROP_IMAGE_TRANSFORMER, (Serializable)((Object)transformer));
        String options = (String)((Object)repoProps.get("convert-command"));
        actionProps.put(PROP_TRANSFORM_OPTIONS, (Serializable)((Object)(options != null ? options : "")));
        NodeRef destNodeRef = (NodeRef)repoProps.get("destination-folder");
        actionProps.put("destinationLocation", (Serializable)destNodeRef);
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        String label = null;
        NodeRef space = (NodeRef)actionProps.get("destinationLocation");
        String name = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), space);
        String transformer = (String)((Object)actionProps.get(PROP_IMAGE_TRANSFORMER));
        String option = (String)((Object)actionProps.get(PROP_TRANSFORM_OPTIONS));
        for (SelectItem item : ((BaseActionWizard)wizard).getImageTransformers()) {
            if (!item.getValue().equals(transformer)) continue;
            label = item.getLabel();
            break;
        }
        return MessageFormat.format(Application.getMessage(context, "action_transform_image"), name, label, option);
    }
}

