/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UITree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryBrowserPluginBean
implements Serializable {
    private static final long serialVersionUID = -1493808456969763500L;
    public static final String BEAN_NAME = "CategoryBrowserPluginBean";
    private static final Log logger = LogFactory.getLog(CategoryBrowserPluginBean.class);
    private transient CategoryService categoryService;
    private transient NodeService nodeService;
    private List<UITree.TreeNode> categoryRootNodes;
    private Map<String, UITree.TreeNode> categoryNodes;
    protected NodeRef previouslySelectedNode;

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    private CategoryService getCategoryService() {
        if (this.categoryService == null) {
            this.categoryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCategoryService();
        }
        return this.categoryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public List<UITree.TreeNode> getCategoryRootNodes() {
        if (this.categoryRootNodes == null) {
            this.categoryRootNodes = new ArrayList<UITree.TreeNode>();
            this.categoryNodes = new HashMap<String, UITree.TreeNode>();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
                tx.begin();
                Collection childRefs = this.getCategoryService().getRootCategories(Repository.getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE);
                for (ChildAssociationRef ref : childRefs) {
                    NodeRef child = ref.getChildRef();
                    UITree.TreeNode node = this.createTreeNode(child);
                    this.categoryRootNodes.add(node);
                    this.categoryNodes.put(node.getNodeRef(), node);
                }
                tx.commit();
            }
            catch (Throwable err) {
                Utils.addErrorMessage("NavigatorPluginBean exception in getCompanyHomeRootNodes()", err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.categoryRootNodes;
    }

    protected Map<String, UITree.TreeNode> getNodesMap() {
        return this.categoryNodes;
    }

    public void retrieveChildren() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            Map params = context.getExternalContext().getRequestParameterMap();
            String nodeRefStr = (String)params.get("nodeRef");
            Map<String, UITree.TreeNode> currentNodes = this.getNodesMap();
            if (nodeRefStr != null && currentNodes != null) {
                NodeRef parentNodeRef = new NodeRef(nodeRefStr);
                UITree.TreeNode parentNode = currentNodes.get(parentNodeRef.toString());
                parentNode.setExpanded(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieving children for noderef: " + parentNodeRef));
                }
                parentNode.removeChildren();
                List childRefs = this.getNodeService().getChildAssocs(parentNodeRef, (QNamePattern)ContentModel.ASSOC_SUBCATEGORIES, RegexQNamePattern.MATCH_ALL);
                ArrayList<UITree.TreeNode> sortedNodes = new ArrayList<UITree.TreeNode>();
                for (ChildAssociationRef ref : childRefs) {
                    NodeRef nodeRef = ref.getChildRef();
                    logger.debug((Object)("retrieving child : " + nodeRef));
                    UITree.TreeNode childNode = this.createTreeNode(nodeRef);
                    parentNode.addChild(childNode);
                    currentNodes.put(childNode.getNodeRef(), childNode);
                    sortedNodes.add(childNode);
                }
                if (sortedNodes.size() > 1) {
                    QuickSort sorter = new QuickSort(sortedNodes, "name", true, "case-insensitive");
                    sorter.sort();
                }
                StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><nodes>");
                for (UITree.TreeNode childNode : sortedNodes) {
                    xml.append(childNode.toXML());
                }
                xml.append("</nodes>");
                out.write(xml.toString());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("returning XML: " + xml.toString()));
                }
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public void nodeCollapsed() throws IOException {
        UITree.TreeNode treeNode;
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        String nodeRefStr = (String)params.get("nodeRef");
        Map<String, UITree.TreeNode> currentNodes = this.getNodesMap();
        if (nodeRefStr != null && currentNodes != null && (treeNode = currentNodes.get(nodeRefStr)) != null) {
            treeNode.setExpanded(false);
            out.write("<ok/>");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set node " + treeNode + " to collapsed state"));
            }
        }
    }

    public void selectNode(NodeRef selectedNode, String area) {
        UITree.TreeNode node;
        if (this.previouslySelectedNode != null && (node = this.categoryNodes.get(this.previouslySelectedNode.toString())) != null) {
            node.setSelected(false);
        }
        if (selectedNode != null && (node = this.categoryNodes.get(selectedNode.toString())) != null) {
            node.setSelected(true);
        }
        this.previouslySelectedNode = selectedNode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selected node: " + selectedNode));
        }
    }

    public void resetSelectedNode() {
        UITree.TreeNode node;
        if (this.previouslySelectedNode != null && (node = this.categoryNodes.get(this.previouslySelectedNode.toString())) != null) {
            node.setSelected(false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reset selected node: " + this.previouslySelectedNode));
        }
    }

    public void reset() {
        this.categoryNodes = null;
        this.categoryRootNodes = null;
        this.resetSelectedNode();
    }

    protected UITree.TreeNode createTreeNode(NodeRef nodeRef) {
        UITree.TreeNode node = new UITree.TreeNode(nodeRef.toString(), Repository.getNameForNode(this.getNodeService(), nodeRef), (String)((Object)this.getNodeService().getProperty(nodeRef, ApplicationModel.PROP_ICON)));
        return node;
    }
}

