/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PresenceProxyBean
implements Serializable {
    private static final long serialVersionUID = -3041576848188629589L;
    private static Log logger = LogFactory.getLog(PresenceProxyBean.class);

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void proxyRequest() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        ResponseWriter out = fc.getResponseWriter();
        Map requestMap = fc.getExternalContext().getRequestParameterMap();
        String url = (String)requestMap.get("url");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PresenceProxyBean.proxyRequest() url=" + url));
        }
        if (url != null) {
            String response = this.getUrlResponse(url);
            out.write(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrlResponse(String requestUrl) {
        String response = "";
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(requestUrl);
        method.setRequestHeader("Accept", "*/*");
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            response = statusCode == 200 ? method.getResponseBodyAsString() : method.getStatusText();
        }
        catch (HttpException e) {
            response = e.getMessage();
        }
        catch (IOException e) {
            response = e.getMessage();
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }
}

