/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.categories;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.categories.CategoriesDialog;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.repo.component.IRepoBreadcrumbHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCategoryDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -8929785826091612856L;
    private static final String DEFAULT_OUTCOME = "finish";
    private static final String MSG_DELETE_CATEGORY = "delete_category";
    private static final String MSG_DELETE = "delete";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static final String MSG_CATEGORIES = "categories";
    protected transient CategoryService categoryService;
    private String name = null;
    private String description = null;
    private List<IBreadcrumbHandler> location = null;
    private Collection<ChildAssociationRef> members = null;
    private NodeRef categoryRef = null;
    private Node actionCategory = null;
    protected UIRichList categoriesRichList;
    private Node category = null;
    private static Log logger = LogFactory.getLog(DeleteCategoryDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        this.isFinished = false;
        String categoryRef = parameters.get("categoryRef");
        ParameterCheck.mandatoryString((String)"categoryRef", (String)categoryRef);
        this.category = new Node(new NodeRef(categoryRef));
        this.setActionCategory(this.category);
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        context.getExternalContext().getRequestMap().put("category", this.category.getName());
        return outcome;
    }

    public Collection<ChildAssociationRef> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<ChildAssociationRef> members) {
        this.members = members;
    }

    public int getMembersSize() {
        return this.getMembers().size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private CategoryService getCategoryService() {
        if (this.categoryService == null) {
            this.categoryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCategoryService();
        }
        return this.categoryService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public NodeRef getCategoryRef() {
        return this.categoryRef;
    }

    public void setCategoryRef(NodeRef categoryRef) {
        this.categoryRef = categoryRef;
    }

    public Node getCategory() {
        return this.category;
    }

    public void setCategory(Node category) {
        this.category = category;
    }

    public void setActionCategory(Node node) {
        this.actionCategory = node;
        if (node != null) {
            this.setName(node.getName());
            this.setDescription((String)node.getProperties().get(ContentModel.PROP_DESCRIPTION));
            this.setMembers(this.getCategoryService().getChildren(node.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY));
        } else {
            this.setName(null);
            this.setDescription(null);
            List emptyCollection = Collections.emptyList();
            this.setMembers(emptyCollection);
        }
    }

    public Node getActionCategory() {
        return this.actionCategory;
    }

    public void setLocation(List<IBreadcrumbHandler> location) {
        this.location = location;
    }

    public List<IBreadcrumbHandler> getLocation() {
        if (this.location == null) {
            CategoriesDialog categoriesDialog;
            ArrayList<IBreadcrumbHandler> loc = new ArrayList<IBreadcrumbHandler>(8);
            CategoriesDialog categoriesDialog2 = categoriesDialog = new CategoriesDialog();
            categoriesDialog2.getClass();
            loc.add(categoriesDialog2.new CategoriesDialog.CategoryBreadcrumbHandler(null, Application.getMessage(FacesContext.getCurrentInstance(), MSG_CATEGORIES)));
            this.setLocation(loc);
        }
        return this.location;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.finishDelete();
        return outcome;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_DELETE_CATEGORY) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getActionCategory().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_DELETE);
    }

    public UIRichList getCategoriesRichList() {
        return this.categoriesRichList;
    }

    public void setCategoriesRichList(UIRichList categoriesRichList) {
        this.categoriesRichList = categoriesRichList;
    }

    public void contextUpdated() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invalidating Category Management Components...");
        }
        this.setCategory(null);
        if (this.categoriesRichList != null) {
            this.categoriesRichList.setValue(null);
        }
    }

    public String getCurrentCategoryId() {
        if (this.getCategoryRef() != null) {
            return this.getCategoryRef().getId();
        }
        return null;
    }

    public void setCurrentCategory(NodeRef ref) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting current category: " + ref));
        }
        this.setCategoryRef(ref);
        this.setCategory(null);
        this.contextUpdated();
    }

    public String finishDelete() {
        String outcome = DEFAULT_OUTCOME;
        if (this.getActionCategory() != null) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
                RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    public NodeRef execute() throws Throwable {
                        NodeRef categoryNodeRef = DeleteCategoryDialog.this.getActionCategory().getNodeRef();
                        DeleteCategoryDialog.this.getCategoryService().deleteCategory(categoryNodeRef);
                        if (DeleteCategoryDialog.this.getMembers() != null && DeleteCategoryDialog.this.getMembers().size() > 0) {
                            for (ChildAssociationRef childRef : DeleteCategoryDialog.this.getMembers()) {
                                ArrayList<NodeRef> list = new ArrayList<NodeRef>(DeleteCategoryDialog.this.getMembers().size());
                                NodeRef member = childRef.getChildRef();
                                Collection categories = (Collection)((Object)DeleteCategoryDialog.this.getNodeService().getProperty(member, ContentModel.PROP_CATEGORIES));
                                for (NodeRef category : categories) {
                                    if (category.equals((Object)categoryNodeRef)) continue;
                                    list.add(category);
                                }
                                DeleteCategoryDialog.this.getNodeService().setProperty(member, ContentModel.PROP_CATEGORIES, (Serializable)list);
                            }
                        }
                        return categoryNodeRef;
                    }
                };
                NodeRef categoryNodeRef = (NodeRef)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                List<IBreadcrumbHandler> location = this.getLocation();
                IBreadcrumbHandler handler = location.get(location.size() - 1);
                if (categoryNodeRef.equals((Object)((IRepoBreadcrumbHandler)handler).getNodeRef())) {
                    location.remove(location.size() - 1);
                    if (location.size() != 0) {
                        handler = location.get(location.size() - 1);
                        this.setCurrentCategory(((IRepoBreadcrumbHandler)handler).getNodeRef());
                    }
                }
                this.setActionCategory(null);
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                outcome = null;
                ReportedException.throwIfNecessary(err);
            }
        }
        return outcome;
    }
}

