/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.clipboard;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.clipboard.AVMClipboardItem;
import org.alfresco.web.bean.clipboard.AbstractClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardStatus;
import org.alfresco.web.bean.clipboard.WorkspaceClipboardItem;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.repo.component.shelf.UIClipboardShelfItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipboardBean
implements Serializable {
    private static final long serialVersionUID = -6299320341615099651L;
    private static Log logger = LogFactory.getLog(ClipboardBean.class);
    private static final String MSG_ERROR_PASTE = "error_paste";
    private List<ClipboardItem> items = new ArrayList<ClipboardItem>(4);
    private transient NodeService nodeService;

    public List<ClipboardItem> getItems() {
        return this.items;
    }

    public void setItems(List<ClipboardItem> items) {
        this.items = items;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void copyNode(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String ref = params.get("ref");
        if (ref != null && ref.length() != 0) {
            this.addClipboardNode(new NodeRef(ref), ClipboardStatus.COPY);
        }
    }

    public void cutNode(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String ref = params.get("ref");
        if (ref != null && ref.length() != 0) {
            this.addClipboardNode(new NodeRef(ref), ClipboardStatus.CUT);
        }
    }

    public void pasteAll(ActionEvent event) {
        this.performPasteItems(-1, 3);
    }

    public void pasteItem(ActionEvent event) {
        UIClipboardShelfItem.ClipboardEvent clipEvent = (UIClipboardShelfItem.ClipboardEvent)event;
        int index = clipEvent.Index;
        if (index >= this.items.size()) {
            throw new IllegalStateException("Clipboard attempting paste a non existent item index: " + index);
        }
        this.performPasteItems(index, clipEvent.Action);
    }

    private void performPasteItems(int index, int action) {
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            if (index == -1) {
                ArrayList<ClipboardItem> toRemove = new ArrayList<ClipboardItem>();
                for (ClipboardItem item : this.items) {
                    if (!this.getNodeService().exists(item.getNodeRef())) {
                        toRemove.add(item);
                        continue;
                    }
                    if (!this.performClipboardOperation(item, action) || item.getMode() != ClipboardStatus.CUT) continue;
                    toRemove.add(item);
                }
                if (Application.getClientConfig(context).isPasteAllAndClearEnabled()) {
                    this.items.clear();
                } else if (toRemove.size() > 0) {
                    for (ClipboardItem item : toRemove) {
                        this.items.remove(item);
                    }
                }
            } else {
                ClipboardItem item = this.items.get(index);
                if (this.performClipboardOperation(item, action) && item.getMode() == ClipboardStatus.CUT) {
                    this.items.remove(index);
                }
            }
            UIContextService.getInstance(context).notifyBeans();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(Application.getMessage(context, MSG_ERROR_PASTE) + err.getMessage(), err);
        }
    }

    private boolean performClipboardOperation(ClipboardItem item, int action) throws Throwable {
        boolean success = false;
        FacesContext fc = FacesContext.getCurrentInstance();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Clipboard destination View Id: " + fc.getViewRoot().getViewId()));
        }
        if (item.getMode() == ClipboardStatus.CUT) {
            if (item.canMoveToViewId(fc.getViewRoot().getViewId())) {
                success = item.paste(fc, fc.getViewRoot().getViewId(), action);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Clipboard Item: " + item.getNodeRef() + " not suitable for Move paste to current View Id."));
            }
        } else if (item.getMode() == ClipboardStatus.COPY) {
            if (item.canCopyToViewId(fc.getViewRoot().getViewId())) {
                success = item.paste(fc, fc.getViewRoot().getViewId(), action);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Clipboard Item: " + item.getNodeRef() + " not suitable for Copy paste to current View Id."));
            }
        }
        return success;
    }

    private void addClipboardNode(NodeRef ref, ClipboardStatus mode) {
        AbstractClipboardItem item = null;
        if ("workspace".equals(ref.getStoreRef().getProtocol())) {
            item = new WorkspaceClipboardItem(ref, mode);
        } else if ("avm".equals(ref.getStoreRef().getProtocol())) {
            item = new AVMClipboardItem(ref, mode);
        } else {
            logger.warn((Object)("Unable to add item to clipboard - unknown store protocol: " + ref.getStoreRef().getProtocol()));
        }
        if (item != null) {
            FacesContext context;
            boolean foundDuplicate = false;
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.items.get(i).equals(item)) continue;
                this.items.set(i, item);
                foundDuplicate = true;
                break;
            }
            if (!foundDuplicate) {
                this.items.add(item);
            }
            if (Application.getClientConfig(context = FacesContext.getCurrentInstance()).isClipboardStatusVisible()) {
                String pattern = Application.getMessage(context, "node_added_clipboard");
                String msg = MessageFormat.format(pattern, this.items.size());
                FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
                context.addMessage(null, facesMsg);
            }
        }
    }
}

