/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.coci.CheckinCheckoutDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CancelEditingDialog
extends CheckinCheckoutDialog {
    public static final String MSG_CANCEL_EDITING = "cancel_editing";
    public static final String MSG_CANCEL_EDITING_FOR = "cancel_editing_for";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static Log logger = LogFactory.getLog(CheckinCheckoutDialog.class);

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.undoCheckoutFile(context, outcome);
        return "dialog:close[2]";
    }

    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_CANCEL_EDITING_FOR) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.property.getDocument().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CANCEL_EDITING);
    }

    public String undoCheckoutFile(FacesContext context, String outcome) {
        Node node = this.property.getDocument();
        if (node != null) {
            try {
                if (!node.hasAspect(ContentModel.ASPECT_WORKING_COPY)) {
                    if (node.hasAspect(ContentModel.ASPECT_LOCKABLE)) {
                        throw new RuntimeException("NOT IMPLEMENTED");
                    }
                    throw new IllegalStateException("Node supplied for undo checkout has neither Working Copy or Locked aspect!");
                }
                this.property.getVersionOperationsService().cancelCheckout(node.getNodeRef());
                this.resetState();
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_cancel_checkout") + err.getMessage(), err);
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: undoCheckout called without a current WorkingDocument!");
        }
        return outcome;
    }
}

