/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.groups;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteGroupDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -8743700617152460027L;
    protected String group = null;
    protected String groupName = null;
    protected int numItemsInGroup = 0;
    private transient AuthorityService authService;
    private static final String MSG_DELETE = "delete";
    private static final String MSG_DELETE_GROUP = "delete_group";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.group = parameters.get("group");
        this.groupName = parameters.get("groupName");
        if (this.group != null) {
            this.numItemsInGroup = this.getAuthService().getContainedAuthorities(AuthorityType.GROUP, this.group, false).size();
            this.numItemsInGroup += this.getAuthService().getContainedAuthorities(AuthorityType.USER, this.group, false).size();
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.getAuthService().deleteAuthority(this.group);
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        context.getExternalContext().getRequestMap().put("group", this.group);
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_DELETE);
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_DELETE_GROUP) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.groupName + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getNumItemsInGroup() {
        return this.numItemsInGroup;
    }

    public void setAuthService(AuthorityService authService) {
        this.authService = authService;
    }

    protected AuthorityService getAuthService() {
        if (this.authService == null) {
            this.authService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authService;
    }
}

