/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Repository;

public final class Preferences
implements Serializable {
    private static final long serialVersionUID = 722840612660970723L;
    private NodeRef preferencesRef;
    private transient NodeService nodeService;
    private Map<String, Serializable> cache = new HashMap<String, Serializable>(16, 1.0f);

    Preferences(NodeRef prefRef) {
        if (prefRef == null) {
            throw new IllegalArgumentException("Preferences NodeRef cannot be null.");
        }
        this.preferencesRef = prefRef;
    }

    public Serializable getValue(String name) {
        Serializable value = this.cache.get(name);
        if (value == null) {
            QName qname = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
            value = this.getNodeService().getProperty(this.preferencesRef, qname);
            this.cache.put(name, value);
        }
        return value;
    }

    public void setValue(String name, Serializable value) {
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context);
            tx.begin();
            this.getNodeService().setProperty(this.preferencesRef, qname, value);
            tx.commit();
            this.cache.put(name, value);
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }
}

