/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.IHandler;
import org.alfresco.web.bean.rules.CreateRuleWizard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCompositeRuleWizard
extends CreateRuleWizard {
    private static final Log logger = LogFactory.getLog(CreateCompositeRuleWizard.class);
    private List<SelectItem> compositeConditions;
    protected DataModel currentCompositeConditionsDataModel;
    protected List<Map<String, Serializable>> currentCompositeConditionPropertiesList;
    private boolean addingCompositeCondition;
    private boolean editCurrentCompositeCondition;
    private int rowIndex = -1;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setAddingCompositeCondition(false);
        this.currentCompositeConditionsDataModel = null;
        this.currentCompositeConditionPropertiesList = null;
    }

    public void setupCompositeConditionsMode() {
        this.setAddingCompositeCondition(true);
        this.currentCompositeConditionsDataModel = new ListDataModel();
        this.currentCompositeConditionPropertiesList = new ArrayList<Map<String, Serializable>>();
    }

    private void clearCompositeConditionMode() {
        this.selectedCondition = null;
        this.currentCompositeConditionsDataModel = null;
        this.currentCompositeConditionPropertiesList = null;
        this.setAddingCompositeCondition(false);
    }

    public DataModel getAllCompositeConditionsDataModel() {
        if (this.currentCompositeConditionsDataModel == null) {
            this.currentCompositeConditionsDataModel = new ListDataModel();
        }
        this.currentCompositeConditionsDataModel.setWrappedData(this.currentCompositeConditionPropertiesList);
        return this.currentCompositeConditionsDataModel;
    }

    @Override
    public void promptForConditionValues() {
        if ("composite-condition".equals(this.selectedCondition)) {
            this.setupCompositeConditionsMode();
        }
        super.promptForConditionValues();
    }

    public void finishAddingCompositeCondition() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Finishing Adding Composite Condition.");
        }
        this.selectedCondition = "composite-condition";
        FacesContext context = FacesContext.getCurrentInstance();
        this.returnViewId = this.getWizardContainerViewId(context);
        this.printConditionState();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\tAdding Condition '" + this.selectedCondition + "'"));
        }
        IHandler handler = (IHandler)this.conditionHandlers.get(this.selectedCondition);
        this.currentConditionProperties.put("composite-condition", (Serializable)((Object)this.currentCompositeConditionPropertiesList));
        this.currentConditionProperties.put("conditionName", this.selectedCondition);
        String summary = handler.generateSummary(context, this, this.currentConditionProperties);
        if (summary != null) {
            this.currentConditionProperties.put("conditionSummary", summary);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generated Summary - [" + summary + "] + selectedCondition " + this.selectedCondition));
        }
        if (this.editCurrentCompositeCondition) {
            if (this.rowIndex != -1) {
                this.allConditionsPropertiesList.remove(this.rowIndex);
                this.allConditionsPropertiesList.add(this.rowIndex, this.currentConditionProperties);
            }
        } else {
            this.allConditionsPropertiesList.add(this.currentConditionProperties);
        }
        this.editCurrentCompositeCondition = false;
        this.rowIndex = -1;
        this.clearCompositeConditionMode();
        this.goToPage(context, this.returnViewId);
    }

    private String getWizardContainerViewId(FacesContext context) {
        String viewId = null;
        ConfigService configSvc = Application.getConfigService(context);
        Config globalConfig = configSvc.getGlobalConfig();
        if (globalConfig != null) {
            viewId = globalConfig.getConfigElement("wizard-container").getValue();
        } else {
            logger.error((Object)"plain-dialog-container configuraion setting is not found");
        }
        return viewId;
    }

    @Override
    public void cancelAddCondition() {
        this.editCurrentCompositeCondition = false;
        this.rowIndex = -1;
        if (this.isAddingCompositeCondition()) {
            IHandler handler;
            String compositePage;
            if (!this.editingCondition) {
                this.currentConditionProperties.clear();
            }
            this.selectedCondition = null;
            FacesContext context = FacesContext.getCurrentInstance();
            String currentViewId = context.getViewRoot().getViewId();
            if (currentViewId.equals(compositePage = (handler = (IHandler)this.conditionHandlers.get("composite-condition")).getJSPPath())) {
                this.returnViewId = this.getWizardContainerViewId(context);
            }
        } else {
            super.cancelAddCondition();
            return;
        }
        this.goToPage(FacesContext.getCurrentInstance(), this.returnViewId);
    }

    @Override
    public void addCondition() {
        if (!this.isAddingCompositeCondition()) {
            super.addCondition();
            this.printConditionState();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Adding Condition to Composite Condition. ");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        IHandler handler = (IHandler)this.conditionHandlers.get(this.selectedCondition);
        if (handler != null) {
            String summary = handler.generateSummary(context, this, this.currentConditionProperties);
            this.currentConditionProperties.put("conditionSummary", summary);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("No Summary could be generated for rule condition " + this.selectedCondition));
            }
            this.currentConditionProperties.put("conditionSummary", "ERROR - No Summary for " + this.selectedCondition);
        }
        if (!this.editingCondition) {
            this.currentCompositeConditionPropertiesList.add(this.currentConditionProperties);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\tAdded condition to Composite condition.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"\tEdited composite condition. ");
        }
        this.currentConditionProperties = new HashMap(3);
        this.currentConditionProperties.put("conditionName", "composite-condition");
        this.currentConditionProperties.put("notcondition", Boolean.FALSE);
        this.selectedCondition = null;
        this.printConditionState();
        this.goToPage(context, this.returnViewId);
    }

    @Override
    public void editCondition() {
        this.editingCondition = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Editing Conditions.  isAddingCompositeConditions - " + this.isAddingCompositeCondition()));
        }
        if (!this.isAddingCompositeCondition()) {
            Map condition = (Map)this.allConditionsDataModel.getRowData();
            this.rowIndex = this.allConditionsDataModel.getRowIndex();
            this.editCurrentCompositeCondition = true;
            if (condition.get("conditionName").equals("composite-condition")) {
                logger.debug((Object)"Composite Condition selected, enabling CompositeCondition Mode");
                this.currentCompositeConditionPropertiesList = (List)condition.get("composite-condition");
                this.addingCompositeCondition = true;
            }
            super.editCondition(condition);
            return;
        }
        Map subCondition = (Map)this.currentCompositeConditionsDataModel.getRowData();
        super.editCondition(subCondition);
    }

    public List<SelectItem> getCompositeConditions() {
        if (this.compositeConditions == null) {
            this.compositeConditions = new ArrayList<SelectItem>();
            List<SelectItem> tempConditions = this.getConditions();
            for (SelectItem item : tempConditions) {
                if (item.getValue().equals("composite-condition") || item.getValue().equals("no-condition")) continue;
                this.compositeConditions.add(item);
            }
        }
        return this.compositeConditions;
    }

    protected boolean isAddingCompositeCondition() {
        return this.addingCompositeCondition;
    }

    protected void setAddingCompositeCondition(boolean addingCompositeCondition) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting addingCompositeCondition to " + addingCompositeCondition));
        }
        this.addingCompositeCondition = addingCompositeCondition;
    }

    @Override
    public void removeCondition() {
        if (!this.isAddingCompositeCondition()) {
            super.removeCondition();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Removing Composite Conditions");
        }
        Map conditionToRemove = (Map)this.currentCompositeConditionsDataModel.getRowData();
        this.currentCompositeConditionPropertiesList.remove(conditionToRemove);
        this.selectedCondition = null;
        FacesContext context = FacesContext.getCurrentInstance();
        this.goToPage(context, context.getViewRoot().getViewId());
    }

    protected void printConditionState() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\t\t*** GLOBAL ***");
            logger.debug((Object)"\t\tallConditionsProperties");
            if (this.allConditionsPropertiesList == null) {
                logger.debug((Object)"\t\t\tempty");
            } else {
                for (Map obj : this.allConditionsPropertiesList) {
                    logger.debug((Object)("\t\t\t" + obj.toString()));
                }
            }
            logger.debug((Object)"\t\t*** COMPOSITE ***");
            logger.debug((Object)("\t\taddingCompositeCondition " + this.addingCompositeCondition));
            logger.debug((Object)"\t\tcurrentCompositeConditionsProperties");
            if (this.currentCompositeConditionPropertiesList == null) {
                logger.debug((Object)"\t\t\t EMPTY");
            } else {
                int i = 1;
                for (Map<String, Serializable> cond : this.currentCompositeConditionPropertiesList) {
                    logger.debug((Object)("\t\t\tCondition" + i++));
                    for (String key : cond.keySet()) {
                        logger.debug((Object)("\t\t\t\tkey - {" + key + "} value - {" + cond.get(key) + "}"));
                    }
                }
            }
            logger.debug((Object)"\t\t*** BOTH ***");
            logger.debug((Object)"\t\tcurrentConditionsProperties");
            if (this.currentConditionProperties == null) {
                logger.debug((Object)"\t\t\t EMPTY");
            } else {
                for (String key : this.currentConditionProperties.keySet()) {
                    logger.debug((Object)("\t\t\tkey - {" + key + "} value - {" + this.currentConditionProperties.get(key) + "}"));
                }
            }
        }
    }
}

