/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteRuleDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 2009345695752548885L;
    private static final String MSG_ERROR_DELETE_RULE = "error_delete_rule";
    private static final String MSG_DELETE_RULE = "delete_rule";
    private static final String MSG_YES = "yes";
    private static final String MSG_NO = "no";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private transient Rule currentRule;
    private transient RuleService ruleService;
    private static Log logger = LogFactory.getLog(DeleteRuleDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        String nodeRef = parameters.get("nodeRef");
        ParameterCheck.mandatoryString((String)"nodeRef", (String)nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rule clicked, it's nodeRef is: " + nodeRef));
        }
        this.currentRule = this.getRuleService().getRule(new NodeRef(nodeRef));
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    protected RuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getRuleService();
        }
        return this.ruleService;
    }

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public Node getSpace() {
        return this.browseBean.getActionSpace();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (this.currentRule != null) {
            try {
                String ruleTitle = this.currentRule.getTitle();
                this.getRuleService().removeRule(this.getSpace().getNodeRef(), this.currentRule);
                this.currentRule = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleted rule '" + ruleTitle + "'"));
                }
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_DELETE_RULE) + err.getMessage(), err);
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: deleteOK called without a current Rule!");
        }
        return outcome;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_DELETE_RULE) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.currentRule.getTitle() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_NO);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_YES);
    }
}

