/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.dialog.FilterViewSupport;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesDialog
extends BaseDialogBean
implements IContextListener,
FilterViewSupport {
    private static final long serialVersionUID = -1255494344597331464L;
    private static final String MSG_REAPPLY_RULES_SUCCESS = "reapply_rules_success";
    private static final String MSG_IGNORE_INHERTIED_RULES = "ignore_inherited_rules";
    private static final String MSG_INCLUDE_INHERITED_RULES = "include_inherited_rules";
    private static final String LOCAL = "local";
    private static final String INHERITED = "inherited";
    private static final String MSG_CLOSE = "close";
    private static Log logger = LogFactory.getLog(RulesDialog.class);
    private String filterModeMode = "inherited";
    private transient RuleService ruleService;
    private List<WrappedRule> rules;
    private transient Rule currentRule;
    private UIRichList richList;
    private transient ActionService actionService;

    public RulesDialog() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    public Node getSpace() {
        return this.browseBean.getActionSpace();
    }

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public List<WrappedRule> getRules() {
        boolean includeInherited = true;
        if (this.filterModeMode.equals(LOCAL)) {
            includeInherited = false;
        }
        List repoRules = this.getRuleService().getRules(this.getSpace().getNodeRef(), includeInherited);
        this.rules = new ArrayList<WrappedRule>(repoRules.size());
        for (Rule rule : repoRules) {
            Date createdDate = (Date)this.getNodeService().getProperty(rule.getNodeRef(), ContentModel.PROP_CREATED);
            Date modifiedDate = (Date)this.getNodeService().getProperty(rule.getNodeRef(), ContentModel.PROP_MODIFIED);
            boolean isLocal = this.getSpace().getNodeRef().equals((Object)this.getRuleService().getOwningNodeRef(rule));
            WrappedRule wrapped = new WrappedRule(rule, isLocal, createdDate, modifiedDate);
            this.rules.add(wrapped);
        }
        return this.rules;
    }

    public void setupRuleAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rule clicked, it's id is: " + id));
            }
            this.currentRule = this.getRuleService().getRule(new NodeRef(id));
            this.contextUpdated();
        }
    }

    public void reapplyRules(ActionEvent event) {
        boolean toChildren = false;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String toChildrenStr = params.get("toChildren");
        if (toChildrenStr != null) {
            toChildren = new Boolean(toChildrenStr);
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(fc);
            tx.begin();
            boolean executeInherited = true;
            if (this.filterModeMode.equals(LOCAL)) {
                executeInherited = false;
            }
            this.reapplyRules(this.getSpace().getNodeRef(), executeInherited, toChildren);
            String msg = Application.getMessage(fc, MSG_REAPPLY_RULES_SUCCESS);
            FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
            String formId = Utils.getParentForm(fc, event.getComponent()).getClientId(fc);
            fc.addMessage(formId + ":rulesList", facesMsg);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(fc, "error_generic"), e.getMessage()), e);
        }
    }

    private void reapplyRules(NodeRef space, boolean executeInherited, boolean toChildren) {
        Action action = this.getActionService().createAction("execute-all-rules");
        action.setParameterValue("execute-inherited-rules", (Serializable)Boolean.valueOf(executeInherited));
        this.getActionService().executeAction(action, space);
        if (toChildren) {
            List assocs = this.getNodeService().getChildAssocs(space, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef assoc : assocs) {
                NodeRef nodeRef = assoc.getChildRef();
                QName className = this.getNodeService().getType(nodeRef);
                if (!this.getDictionaryService().isSubClass(className, ContentModel.TYPE_FOLDER)) continue;
                this.reapplyRules(nodeRef, executeInherited, toChildren);
            }
        }
    }

    public String getIgnoreInheritedRulesLabelId() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String result = Application.getMessage(fc, MSG_IGNORE_INHERTIED_RULES);
        if (this.getNodeService().hasAspect(this.getSpace().getNodeRef(), RuleModel.ASPECT_IGNORE_INHERITED_RULES)) {
            result = Application.getMessage(fc, MSG_INCLUDE_INHERITED_RULES);
        }
        return result;
    }

    public boolean getIgnoreInheritedRules() {
        return this.getNodeService().hasAspect(this.getSpace().getNodeRef(), RuleModel.ASPECT_IGNORE_INHERITED_RULES);
    }

    public void ignoreInheritedRules(ActionEvent event) {
        NodeRef nodeRef = this.getSpace().getNodeRef();
        if (this.getNodeService().hasAspect(nodeRef, RuleModel.ASPECT_IGNORE_INHERITED_RULES)) {
            this.getNodeService().removeAspect(nodeRef, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        } else {
            this.getNodeService().addAspect(nodeRef, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        }
        if (this.richList != null) {
            this.richList.setValue(null);
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public void restored() {
        super.restored();
        this.contextUpdated();
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    public void setRichList(UIRichList richList) {
        this.richList = richList;
    }

    public UIRichList getRichList() {
        return this.richList;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    protected RuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getRuleService();
        }
        return this.ruleService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    private ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }

    @Override
    public void contextUpdated() {
        if (this.richList != null) {
            this.richList.setValue(null);
        }
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    @Override
    public void filterModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        this.filterModeMode = viewList.getValue().toString();
        if (this.richList != null) {
            this.richList.setValue(null);
        }
    }

    @Override
    public List<UIListItem> getFilterItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem item1 = new UIListItem();
        item1.setValue(INHERITED);
        item1.setLabel(Application.getMessage(context, INHERITED));
        items.add(item1);
        UIListItem item2 = new UIListItem();
        item2.setValue(LOCAL);
        item2.setLabel(Application.getMessage(context, LOCAL));
        items.add(item2);
        return items;
    }

    @Override
    public String getFilterMode() {
        return this.filterModeMode;
    }

    @Override
    public void setFilterMode(String filterMode) {
        this.filterModeMode = filterMode;
        this.contextUpdated();
    }

    public static class WrappedRule
    implements Serializable {
        private static final long serialVersionUID = -8887443730660109283L;
        private transient Rule rule;
        private boolean isLocal;
        private Date createdDate;
        private Date modifiedDate;

        public WrappedRule(Rule rule, boolean isLocal, Date createdDate, Date modifiedDate) {
            this.rule = rule;
            this.isLocal = isLocal;
            this.createdDate = createdDate;
            this.modifiedDate = modifiedDate;
        }

        public Rule getRule() {
            return this.rule;
        }

        public boolean getLocal() {
            return this.isLocal;
        }

        public String getId() {
            return this.rule.getNodeRef().toString();
        }

        public String getTitle() {
            return this.rule.getTitle();
        }

        public String getDescription() {
            return this.rule.getDescription();
        }

        public Date getCreatedDate() {
            return this.createdDate;
        }

        public Date getModifiedDate() {
            return this.modifiedDate;
        }
    }
}

