/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers.property;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.web.bean.rules.handlers.property.TextPropertyValueConditionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePropertyValueConditionHandler
extends TextPropertyValueConditionHandler {
    public static final String NAME = "compare-date-property";

    @Override
    protected String getConditionName() {
        return NAME;
    }

    @Override
    protected void prepareForSaveWithCorrectType(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        Date date = (Date)conditionProps.get("containstext");
        repoProps.put("value", date);
    }

    @Override
    protected void prepareForEditWithCorrectType(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        Date dateValue = (Date)repoProps.get("value");
        conditionProps.put("containstext", dateValue);
    }

    @Override
    protected String getSummaryStringTemplate(Boolean not) {
        String msgId = not != false ? "condition_compare_date_property_value_not" : "condition_compare_date_property_value";
        return msgId;
    }

    @Override
    protected String displayOperation(String operation) {
        ComparePropertyValueOperation op = ComparePropertyValueOperation.valueOf((String)operation);
        switch (op) {
            case EQUALS: {
                return "property_date_condition_equals";
            }
            case GREATER_THAN: {
                return "property_date_condition_greaterthan";
            }
            case GREATER_THAN_EQUAL: {
                return "property_date_condition_greaterthanequals";
            }
            case LESS_THAN: {
                return "property_date_condition_lessthan";
            }
            case LESS_THAN_EQUAL: {
                return "property_date_condition_lessthanequals";
            }
        }
        return "property_condition_invalid";
    }
}

