/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.search;

import java.text.MessageFormat;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.search.AdvancedSearchDialog;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class SaveSearchDialog
extends AdvancedSearchDialog {
    private static final long serialVersionUID = 237262751601280456L;
    private static final String MSG_ERROR_SAVE_SEARCH = "error_save_search";

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.saveNewSearchOK(context, outcome);
    }

    public String getFinishButtonLabel() {
        return super.getFinishButtonLabel();
    }

    public String saveNewSearchOK(FacesContext newContext, String newOutcome) {
        String outcome = newOutcome;
        NodeRef searchesRef = this.properties.isSearchSaveGlobal() ? this.getGlobalSearchesRef() : this.getUserSearchesRef();
        final SearchContext search = this.navigator.getSearchContext();
        if (searchesRef != null && search != null) {
            try {
                final FacesContext context = newContext;
                final NodeRef searchesRefFinal = searchesRef;
                RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        HashMap<QName, String> props = new HashMap<QName, String>(2, 1.0f);
                        props.put(ContentModel.PROP_NAME, SaveSearchDialog.this.properties.getSearchName());
                        props.put(ContentModel.PROP_DESCRIPTION, SaveSearchDialog.this.properties.getSearchDescription());
                        ChildAssociationRef childRef = SaveSearchDialog.this.getNodeService().createNode(searchesRefFinal, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org", (String)QName.createValidLocalName((String)SaveSearchDialog.this.properties.getSearchName())), ContentModel.TYPE_CONTENT, props);
                        ContentService contentService = Repository.getServiceRegistry(context).getContentService();
                        ContentWriter writer = contentService.getWriter(childRef.getChildRef(), ContentModel.PROP_CONTENT, true);
                        writer.setMimetype("text/xml");
                        writer.setEncoding("UTF-8");
                        writer.putContent(search.toXML());
                        return null;
                    }
                };
                callback.execute();
                this.properties.getCachedSavedSearches().clear();
                this.properties.setSavedSearch(null);
            }
            catch (Throwable e) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(newContext, MSG_ERROR_SAVE_SEARCH), e.getMessage()), e);
                outcome = null;
                this.isFinished = false;
                ReportedException.throwIfNecessary(e);
            }
        }
        return outcome;
    }
}

