/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.shelf.UIRecentSpacesShelfItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentSpacesBean
implements IContextListener {
    private static final long serialVersionUID = -6405913558933664909L;
    private static Log logger = LogFactory.getLog(RecentSpacesBean.class);
    protected NavigationBean navigator;
    protected BrowseBean browseBean;
    private Integer maxRecentSpaces = null;
    private List<Node> recentSpaces = new LinkedList<Node>();

    public RecentSpacesBean() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public List<Node> getRecentSpaces() {
        return this.recentSpaces;
    }

    public void setRecentSpaces(List<Node> spaces) {
        this.recentSpaces = spaces;
    }

    public void navigate(ActionEvent event) {
        UIRecentSpacesShelfItem.RecentSpacesEvent spaceEvent = (UIRecentSpacesShelfItem.RecentSpacesEvent)event;
        Node selectedNode = this.recentSpaces.get(spaceEvent.Index);
        NodeRef nodeRef = selectedNode.getNodeRef();
        try {
            this.browseBean.updateUILocation(nodeRef);
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), nodeRef.getId()));
            this.recentSpaces.remove(spaceEvent.Index);
        }
    }

    @Override
    public void contextUpdated() {
        Node node = this.navigator.getCurrentNode();
        for (int i = 0; i < this.recentSpaces.size(); ++i) {
            if (!node.getId().equals(this.recentSpaces.get(i).getId())) continue;
            this.recentSpaces.remove(i);
            break;
        }
        int maxItems = this.getMaxRecentSpaces();
        if (this.recentSpaces.size() == maxItems) {
            this.recentSpaces.remove(maxItems - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inserting node: " + node.getName() + " at top of recent spaces list."));
        }
        this.recentSpaces.add(0, node);
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    private int getMaxRecentSpaces() {
        if (this.maxRecentSpaces == null) {
            ClientConfigElement config = Application.getClientConfig(FacesContext.getCurrentInstance());
            this.maxRecentSpaces = config.getRecentSpacesItems();
        }
        return this.maxRecentSpaces;
    }
}

