/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.dialog.FilterViewSupport;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIRichList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserMembersBean
extends BaseDialogBean
implements IContextListener,
FilterViewSupport {
    private static final String MSG_SUCCESS_INHERIT_NOT = "success_not_inherit_permissions";
    private static final String MSG_SUCCESS_INHERIT = "success_inherit_permissions";
    private static final String ERROR_DELETE = "error_remove_user";
    private static final String OUTCOME_FINISH = "finish";
    private static final String LOCAL = "local";
    private static final String INHERITED = "inherited";
    private static final String MSG_CLOSE = "close";
    private String filterMode = "local";
    private transient NodeService nodeService;
    private transient SearchService searchService;
    private transient PermissionService permissionService;
    private transient AuthorityService authorityService;
    private transient PersonService personService;
    protected BrowseBean browseBean;
    private transient OwnableService ownableService;
    private UIRichList usersRichList;
    private String personAuthority = null;
    private String personName = null;
    private transient DataModel personRolesDataModel = null;
    private List<PermissionWrapper> personRoles = null;

    public UserMembersBean() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    public abstract Node getNode();

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    @Override
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected AuthorityService getAuthorityService() {
        if (this.authorityService == null) {
            this.authorityService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authorityService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    protected OwnableService getOwnableService() {
        if (this.ownableService == null) {
            this.ownableService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getOwnableService();
        }
        return this.ownableService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    @Override
    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public UIRichList getUsersRichList() {
        return this.usersRichList;
    }

    public void setUsersRichList(UIRichList usersRichList) {
        this.usersRichList = usersRichList;
    }

    public DataModel getPersonRolesDataModel() {
        if (this.personRolesDataModel == null) {
            this.personRolesDataModel = new ListDataModel();
        }
        if (this.personRolesDataModel.getWrappedData() == null) {
            this.personRolesDataModel.setWrappedData(this.personRoles);
        }
        return this.personRolesDataModel;
    }

    public String getPersonAuthority() {
        return this.personAuthority;
    }

    public void setPersonAuthority(String person) {
        this.personAuthority = person;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public boolean getHasChangePermissions() {
        return this.getNode().hasPermission("ChangePermissions");
    }

    public boolean isInheritPermissions() {
        return this.getPermissionService().getInheritParentPermissions(this.getNode().getNodeRef());
    }

    public void setInheritPermissions(boolean inheritPermissions) {
    }

    public String getOwner() {
        return this.getOwnableService().getOwner(this.getNode().getNodeRef());
    }

    public List<Map> getUsers() {
        FacesContext context = FacesContext.getCurrentInstance();
        boolean includeInherited = this.filterMode.equals(INHERITED);
        List<Map> personNodes = null;
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            HashMap<String, ArrayList<String>> permissionMap = new HashMap<String, ArrayList<String>>(8, 1.0f);
            Set permissions = this.getPermissionService().getAllSetPermissions(this.getNode().getNodeRef());
            for (AccessPermission permission : permissions) {
                if (permission.getAccessStatus() != AccessStatus.ALLOWED || permission.getAuthorityType() != AuthorityType.USER && permission.getAuthorityType() != AuthorityType.GROUP && permission.getAuthorityType() != AuthorityType.GUEST && permission.getAuthorityType() != AuthorityType.EVERYONE || !includeInherited && !permission.isSetDirectly()) continue;
                String authority = permission.getAuthority();
                ArrayList<String> userPermissions = (ArrayList<String>)permissionMap.get(authority);
                if (userPermissions == null) {
                    userPermissions = new ArrayList<String>(4);
                    permissionMap.put(authority, userPermissions);
                }
                userPermissions.add(permission.getPermission());
            }
            personNodes = new ArrayList<Map>(permissionMap.size());
            for (String authority : permissionMap.keySet()) {
                if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.GUEST || this.getPersonService().personExists(authority)) {
                    NodeRef nodeRef = this.getPersonService().getPerson(authority);
                    if (nodeRef == null) continue;
                    MapNode node = new MapNode(nodeRef);
                    Map<String, Object> props = node.getProperties();
                    String lastName = (String)props.get("lastName");
                    props.put("fullName", (String)props.get("firstName") + ' ' + (lastName != null ? lastName : ""));
                    props.put("userNameLabel", props.get("userName"));
                    props.put("roles", UserMembersBean.roleListToString(context, (List)permissionMap.get(authority)));
                    props.put("icon", "/images/icons/person.gif");
                    props.put("isGroup", Boolean.FALSE);
                    props.put(INHERITED, includeInherited);
                    personNodes.add(node);
                    continue;
                }
                HashMap<String, Object> node = new HashMap<String, Object>(8, 1.0f);
                String groupDisplayName = this.getAuthorityService().getAuthorityDisplayName(authority);
                if (groupDisplayName == null || groupDisplayName.length() == 0) {
                    groupDisplayName = authority.startsWith("GROUP_") ? authority.substring("GROUP_".length()) : authority;
                }
                node.put("fullName", groupDisplayName);
                node.put("userNameLabel", groupDisplayName);
                node.put("userName", authority);
                node.put("id", authority);
                node.put("roles", UserMembersBean.roleListToString(context, (List)permissionMap.get(authority)));
                node.put("icon", "/images/icons/group.gif");
                node.put("isGroup", Boolean.TRUE);
                node.put(INHERITED, includeInherited);
                personNodes.add(node);
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_noderef"), refErr.getNodeRef()));
            personNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {}
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
            personNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        return personNodes;
    }

    public static String roleListToString(FacesContext context, List<String> list) {
        StringBuilder buf = new StringBuilder();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(Application.getMessage(context, list.get(i)));
            }
        }
        return buf.toString();
    }

    @Override
    public void contextUpdated() {
        if (this.usersRichList != null) {
            this.usersRichList.setValue(null);
        }
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    @Override
    public void filterModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        this.setFilterMode(viewList.getValue().toString());
        if (this.usersRichList != null) {
            this.usersRichList.setValue(null);
        }
    }

    @Override
    public List<UIListItem> getFilterItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem item1 = new UIListItem();
        item1.setValue(INHERITED);
        item1.setLabel(Application.getMessage(context, INHERITED));
        items.add(item1);
        UIListItem item2 = new UIListItem();
        item2.setValue(LOCAL);
        item2.setLabel(Application.getMessage(context, LOCAL));
        items.add(item2);
        return items;
    }

    @Override
    public String getFilterMode() {
        return this.filterMode;
    }

    @Override
    public void setFilterMode(String filterMode) {
        this.filterMode = filterMode;
        this.contextUpdated();
    }

    @Override
    public String cancel() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        return super.cancel();
    }

    public void setupUserAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String authority = params.get("userName");
        if (authority != null && authority.length() != 0) {
            try {
                if (this.getPersonService().personExists(authority)) {
                    NodeRef ref = this.getPersonService().getPerson(authority);
                    Node node = new Node(ref);
                    this.setPersonName((String)node.getProperties().get(ContentModel.PROP_FIRSTNAME) + ' ' + (String)node.getProperties().get(ContentModel.PROP_LASTNAME));
                } else {
                    String label = params.get("userNameLabel");
                    if (label == null || label.length() == 0) {
                        label = authority;
                    }
                    this.setPersonName(label);
                }
                ArrayList<PermissionWrapper> userPermissions = new ArrayList<PermissionWrapper>(4);
                Set permissions = this.getPermissionService().getAllSetPermissions(this.getNode().getNodeRef());
                if (permissions != null) {
                    for (AccessPermission permission : permissions) {
                        if (permission.getAccessStatus() != AccessStatus.ALLOWED || !authority.equals(permission.getAuthority())) continue;
                        PermissionWrapper wrapper = new PermissionWrapper(permission.getPermission(), Application.getMessage(context, permission.getPermission()));
                        userPermissions.add(wrapper);
                    }
                }
                this.personRolesDataModel = null;
                this.personRoles = userPermissions;
                this.setPersonAuthority(authority);
            }
            catch (Exception err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()));
            }
        } else {
            this.setPersonAuthority(null);
        }
        this.contextUpdated();
    }

    public void inheritPermissionsValueChanged(ValueChangeEvent event) {
        try {
            boolean inheritPermissions = (Boolean)event.getNewValue();
            this.getPermissionService().setInheritParentPermissions(this.getNode().getNodeRef(), inheritPermissions);
            FacesContext context = FacesContext.getCurrentInstance();
            String msg = inheritPermissions ? Application.getMessage(context, MSG_SUCCESS_INHERIT) : Application.getMessage(context, MSG_SUCCESS_INHERIT_NOT);
            if (this.getPermissionService().hasPermission(this.getNode().getNodeRef(), "ChangePermissions") == AccessStatus.ALLOWED) {
                FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
                context.addMessage(event.getComponent().getClientId(context), facesMsg);
            } else {
                NavigationBean nb = (NavigationBean)FacesHelper.getManagedBean(context, "NavigationBean");
                if (nb != null) {
                    try {
                        nb.processToolbarLocation(nb.getToolbarLocation(), true);
                    }
                    catch (InvalidNodeRefException refErr) {
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_homespace"), Application.getCurrentUser(context).getHomeSpaceId()), refErr);
                    }
                    catch (Exception err) {
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                    }
                }
            }
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
        }
    }

    public void addRole(ActionEvent event) {
        UISelectOne rolePicker = (UISelectOne)event.getComponent().findComponent("roles");
        String role = (String)rolePicker.getValue();
        if (role != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            PermissionWrapper wrapper = new PermissionWrapper(role, Application.getMessage(context, role));
            this.personRoles.add(wrapper);
        }
        this.contextUpdated();
    }

    public void removeRole(ActionEvent event) {
        PermissionWrapper wrapper = (PermissionWrapper)this.getPersonRolesDataModel().getRowData();
        if (wrapper != null) {
            this.personRoles.remove(wrapper);
        }
        this.contextUpdated();
    }

    public String finishOK() {
        String outcome = OUTCOME_FINISH;
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.personRoles != null && this.getPersonAuthority() != null) {
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context);
                tx.begin();
                final NodeRef nodeRef = this.getNode().getNodeRef();
                if (this.getPermissionService().hasPermission(nodeRef, "ChangePermissions") == AccessStatus.ALLOWED) {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        public Object doWork() throws Exception {
                            UserMembersBean.this.getPermissionService().clearPermission(nodeRef, UserMembersBean.this.getPersonAuthority());
                            for (PermissionWrapper wrapper : UserMembersBean.this.personRoles) {
                                UserMembersBean.this.getPermissionService().setPermission(nodeRef, UserMembersBean.this.getPersonAuthority(), wrapper.getPermission(), true);
                            }
                            return null;
                        }
                    }, (String)AuthenticationUtil.getSystemUserName());
                }
                tx.commit();
            }
            catch (Exception err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                outcome = null;
            }
        }
        return outcome;
    }

    public String removeOK() {
        NavigationBean nb;
        String outcome = this.getDefaultFinishOutcome();
        UserTransaction tx = null;
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            tx = Repository.getUserTransaction(context);
            tx.begin();
            if (this.getPersonAuthority() != null) {
                this.getPermissionService().clearPermission(this.getNode().getNodeRef(), this.getPersonAuthority());
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), ERROR_DELETE), e.getMessage()), e);
        }
        if (this.getPermissionService().hasPermission(this.getNode().getNodeRef(), "ChangePermissions") == AccessStatus.DENIED && (nb = (NavigationBean)FacesHelper.getManagedBean(context, "NavigationBean")) != null) {
            try {
                nb.processToolbarLocation(nb.getToolbarLocation(), true);
                outcome = "browse";
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_homespace"), Application.getCurrentUser(context).getHomeSpaceId()), refErr);
            }
            catch (Exception err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            }
        }
        return outcome;
    }

    public static class PermissionWrapper
    implements Serializable {
        private static final long serialVersionUID = 953727068432918977L;
        private String label;
        private String permission;

        public PermissionWrapper(String permission, String label) {
            this.permission = permission;
            this.label = label;
        }

        public String getRole() {
            return this.label;
        }

        public String getPermission() {
            return this.permission;
        }
    }
}

