/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.PreferencesService;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.config.LanguagesConfigElement;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.surf.util.I18NUtil;

public class UserPreferencesBean
implements Serializable {
    private static final long serialVersionUID = -1262481849503163054L;
    public static final String PREF_INTERFACELANGUAGE = "interface-language";
    private static final String PREF_STARTLOCATION = "start-location";
    private static final String PREF_CONTENTFILTERLANGUAGE = "content-filter-language";
    private static final String PREF_DOWNLOADAUTOMATICALLY = "download-automatically";
    public static final String MSG_CONTENTALLLANGUAGES = "content_all_languages";
    private String contentFilterLanguage = null;
    private transient MultilingualContentService multilingualContentService;
    private transient ContentFilterLanguagesService contentFilterLanguagesService;
    private transient NodeService nodeService;

    public SelectItem[] getLanguages() {
        return UserPreferencesBean.getLanguageItems();
    }

    public String getLanguage() {
        return Application.getLanguage(FacesContext.getCurrentInstance()).toString();
    }

    public void setLanguage(String language) {
        Application.setLanguage(FacesContext.getCurrentInstance(), language);
        if (Application.getCurrentUser(FacesContext.getCurrentInstance()) != null) {
            PreferencesService.getPreferences().setValue(PREF_INTERFACELANGUAGE, (Serializable)((Object)language));
        }
    }

    public String getContentFilterLanguage() {
        if (this.contentFilterLanguage == null) {
            Locale locale = (Locale)PreferencesService.getPreferences().getValue(PREF_CONTENTFILTERLANGUAGE);
            this.contentFilterLanguage = locale == null ? null : locale.toString();
        }
        I18NUtil.setContentLocale((Locale)I18NUtil.parseLocale((String)this.contentFilterLanguage));
        return this.contentFilterLanguage;
    }

    public void setContentFilterLanguage(String contentFilterLanguage) {
        this.contentFilterLanguage = contentFilterLanguage;
        Locale language = null;
        if (contentFilterLanguage.equals(MSG_CONTENTALLLANGUAGES)) {
            this.contentFilterLanguage = null;
        } else {
            language = I18NUtil.parseLocale((String)contentFilterLanguage);
        }
        PreferencesService.getPreferences().setValue(PREF_CONTENTFILTERLANGUAGE, language);
        I18NUtil.setContentLocale((Locale)language);
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
    }

    public SelectItem[] getContentFilterLanguages() {
        return this.getContentFilterLanguages(true);
    }

    public SelectItem[] getContentFilterLanguages(boolean includeAllLanguages) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ResourceBundle msg = Application.getBundle(fc);
        List languages = this.getContentFilterLanguagesService().getFilterLanguages();
        SelectItem[] items = new SelectItem[includeAllLanguages ? languages.size() + 1 : languages.size()];
        int idx = 0;
        if (includeAllLanguages) {
            String allLanguagesStr = msg.getString(MSG_CONTENTALLLANGUAGES);
            items[idx] = new SelectItem((Object)MSG_CONTENTALLLANGUAGES, allLanguagesStr);
            ++idx;
        }
        for (String lang : languages) {
            String label = this.getContentFilterLanguagesService().getLabelByCode(lang);
            items[idx] = new SelectItem((Object)lang, label);
            ++idx;
        }
        return items;
    }

    public SelectItem[] getAvailablesContentFilterLanguages(NodeRef translation, boolean returnTranslationLanguage) {
        List missingLocales = this.getMultilingualContentService().getMissingTranslations(translation, returnTranslationLanguage);
        SelectItem[] items = new SelectItem[missingLocales.size()];
        int idx = 0;
        for (Locale locale : missingLocales) {
            String label = this.getContentFilterLanguagesService().getLabelByCode(locale.getLanguage());
            items[idx] = new SelectItem((Object)locale.toString(), label);
            ++idx;
        }
        return items;
    }

    private static SelectItem[] getLanguageItems() {
        FacesContext fc = FacesContext.getCurrentInstance();
        Config config = Application.getConfigService(fc).getConfig((Object)"Languages");
        LanguagesConfigElement langConfig = (LanguagesConfigElement)config.getConfigElement("languages");
        List<String> languages = langConfig.getLanguages();
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(10);
        for (String locale : languages) {
            String label = langConfig.getLabelForLanguage(locale);
            items.add(new SelectItem((Object)locale, label));
        }
        return items.toArray(new SelectItem[items.size()]);
    }

    public String getStartLocation() {
        String location = (String)((Object)PreferencesService.getPreferences().getValue(PREF_STARTLOCATION));
        if (location == null) {
            location = Application.getClientConfig(FacesContext.getCurrentInstance()).getInitialLocation();
        }
        return location;
    }

    public void setStartLocation(String location) {
        PreferencesService.getPreferences().setValue(PREF_STARTLOCATION, (Serializable)((Object)location));
    }

    public SelectItem[] getStartLocations() {
        FacesContext fc = FacesContext.getCurrentInstance();
        NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
        ResourceBundle msg = Application.getBundle(fc);
        ArrayList<SelectItem> locations = new ArrayList<SelectItem>(4);
        locations.add(new SelectItem((Object)"myalfresco", msg.getString("my_alfresco")));
        locations.add(new SelectItem((Object)"userhome", msg.getString("my_home")));
        if (navigator.getCompanyHomeVisible()) {
            locations.add(new SelectItem((Object)"companyhome", msg.getString("company_home")));
        }
        if (navigator.getGuestHomeVisible()) {
            locations.add(new SelectItem((Object)"guesthome", msg.getString("guest_home")));
        }
        return locations.toArray(new SelectItem[locations.size()]);
    }

    public boolean getAllowGuestConfig() {
        return Application.getClientConfig(FacesContext.getCurrentInstance()).getAllowGuestConfig();
    }

    public MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    ContentFilterLanguagesService getContentFilterLanguagesService() {
        if (this.contentFilterLanguagesService == null) {
            this.contentFilterLanguagesService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentFilterLanguagesService();
        }
        return this.contentFilterLanguagesService;
    }

    public boolean isDownloadAutomatically() {
        Boolean downloadAutomatically = (Boolean)PreferencesService.getPreferences().getValue(PREF_DOWNLOADAUTOMATICALLY);
        if (downloadAutomatically == null) {
            return true;
        }
        return downloadAutomatically;
    }

    public void setDownloadAutomatically(boolean downloadAutomatically) {
        PreferencesService.getPreferences().setValue(PREF_DOWNLOADAUTOMATICALLY, Boolean.valueOf(downloadAutomatically));
    }
}

