/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMEditBean
extends BaseDialogBean {
    private static final long serialVersionUID = -6662866123545412556L;
    private static final Log LOGGER = LogFactory.getLog(AVMEditBean.class);
    private static final String MSG_ERROR_UPDATE = "error_update";
    private static final String MSG_UPLOAD_SUCCESS = "file_upload_success";
    private static final String MSG_APPLY_RSS_FEED = "apply_rss_feed";
    private static final String MSG_UPDATE = "update";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private File file = null;
    private String fileName = null;
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;
    private transient FormsService formsService;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public AVMNode getAvmNode() {
        return this.avmBrowseBean.getAvmActionNode();
    }

    public String getFileType32() {
        return FileTypeImageUtils.getFileTypeImage((String)this.getAvmNode().getName(), (boolean)false);
    }

    public String getFileType16() {
        return FileTypeImageUtils.getFileTypeImage((String)this.getAvmNode().getName(), (boolean)true);
    }

    public String getFileName() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            this.file = fileBean.getFile();
            this.fileName = fileBean.getFileName();
        }
        return this.fileName;
    }

    public String getFileUploadSuccessMsg() {
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), MSG_UPLOAD_SUCCESS);
        return MessageFormat.format(msg, Utils.encode((String)this.getFileName()));
    }

    public String updateFileOK() {
        String outcome = null;
        UserTransaction tx = null;
        AVMNode node = this.getAvmNode();
        if (node != null && this.getFileName() != null) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context);
                tx.begin();
                ContentWriter writer = this.getAvmService().getContentWriter(node.getPath(), true);
                String mimeType = Repository.getMimeTypeForFileName(context, this.fileName);
                writer.setMimetype(mimeType);
                writer.putContent(this.file);
                tx.commit();
                if (this.getAvmService().hasAspect(-1, node.getPath(), WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                    this.regenerateRenditions();
                }
                AVMUtil.updateVServerWebapp(node.getPath(), false);
                this.resetState();
                outcome = "dialog:close";
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_UPDATE) + err.getMessage(), err);
            }
        }
        return outcome;
    }

    public String cancel() {
        this.resetState();
        return "dialog:close";
    }

    private void resetState() {
        this.removeUploadedFile();
    }

    public void removeUploadedFile() {
        if (this.file != null) {
            this.file.delete();
        }
        this.file = null;
        this.fileName = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        ctx.getExternalContext().getSessionMap().remove("alfresco.UploadBean");
    }

    private void regenerateRenditions() throws FormNotFoundException {
        String avmPath = this.getAvmNode().getPath();
        FormInstanceData fid = this.getFormsService().getFormInstanceData(-1, avmPath);
        List<FormInstanceData.RegenerateResult> result = fid.regenerateRenditions();
        for (FormInstanceData.RegenerateResult rr : result) {
            if (rr.getException() == null) continue;
            Utils.addErrorMessage("error regenerating rendition using " + rr.getRenderingEngineTemplate().getName() + ": " + rr.getException().getMessage(), rr.getException());
        }
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.updateFileOK();
    }

    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_UPDATE) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getAvmNode().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public boolean getFinishButtonDisabled() {
        return this.getFileName() == null;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_UPDATE);
    }
}

