/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteFolderDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 4188977806570877462L;
    private static final Log logger = LogFactory.getLog(DeleteFolderDialog.class);
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        AVMNode node = this.avmBrowseBean.getAvmActionNode();
        if (node != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to delete AVM node: " + node.getPath()));
            }
            this.getAvmService().removeNode(node.getPath().substring(0, node.getPath().lastIndexOf(47)), node.getPath().substring(node.getPath().lastIndexOf(47) + 1));
        } else {
            logger.warn((Object)"WARNING: delete called without a current AVM Node!");
        }
        return outcome;
    }

    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        return "dialog:close";
    }

    protected String getErrorMessageId() {
        return "error_delete_folder";
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getConfirmMessage() {
        String fileConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), "delete_avm_folder_confirm");
        return MessageFormat.format(fileConfirmMsg, this.avmBrowseBean.getAvmActionNode().getName());
    }
}

