/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMDetailsBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.data.UIRichList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDetailsBean
extends AVMDetailsBean {
    private static final long serialVersionUID = -3263315503769148385L;
    private transient ActionService actionService;
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";

    public FileDetailsBean() {
        this.panels.put("version-history-panel", false);
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    private ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }

    @Override
    public AVMNode getAvmNode() {
        return this.avmBrowseBean.getAvmActionNode();
    }

    public Node getDocument() {
        return new Node(this.getAvmNode().getNodeRef());
    }

    public String getBrowserUrl() {
        return DownloadContentServlet.generateBrowserURL(this.getAvmNode().getNodeRef(), this.getAvmNode().getName());
    }

    public String getDownloadUrl() {
        return DownloadContentServlet.generateDownloadURL(this.getAvmNode().getNodeRef(), this.getAvmNode().getName());
    }

    public String getPreviewUrl() {
        return AVMUtil.getPreviewURI(this.getAvmNode().getPath());
    }

    public String getFileType32() {
        return FileTypeImageUtils.getFileTypeImage((String)this.getAvmNode().getName(), (boolean)false);
    }

    @Override
    protected List<AVMNode> getNodes() {
        return this.avmBrowseBean.getFiles();
    }

    public List<Map<String, Object>> getVersionHistory() {
        AVMNode avmNode = this.getAvmNode();
        List history = this.getAvmService().getHistory(avmNode.getDescriptor(), -1);
        ArrayList<Map<String, Object>> wrappers = new ArrayList<Map<String, Object>>(history.size());
        for (AVMNodeDescriptor record : history) {
            HashMap<String, Object> wrapper = new HashMap<String, Object>(8, 1.0f);
            wrapper.put("version", record.getVersionID());
            wrapper.put("strVersion", Integer.toString(record.getVersionID()));
            wrapper.put("modifiedDate", new Date(record.getModDate()));
            Pair path = this.getAvmService().getAPath(record);
            if (path != null) {
                wrapper.put("url", DownloadContentServlet.generateBrowserURL(AVMNodeConverter.ToNodeRef((int)((Integer)path.getFirst()), (String)((String)path.getSecond())), avmNode.getName()));
            }
            wrapper.put("fileType16", FileTypeImageUtils.getFileTypeImage((String)avmNode.getName(), (boolean)true));
            wrappers.add(wrapper);
        }
        return wrappers;
    }

    public void revertNode(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        int version = Integer.parseInt(params.get("version"));
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, false);
            tx.begin();
            HashMap<String, AVMNodeDescriptor> args = new HashMap<String, AVMNodeDescriptor>(1, 1.0f);
            List history = this.getAvmService().getHistory(this.getAvmNode().getDescriptor(), -1);
            for (AVMNodeDescriptor record : history) {
                if (record.getVersionID() != version) continue;
                Action action = this.getActionService().createAction("avm-revert-to-version", args);
                args.put("to-revert", record);
                this.getActionService().executeAction(action, this.getAvmNode().getNodeRef());
                UIRichList versionList = (UIRichList)link.findComponent("version-history-list");
                versionList.setValue(null);
                this.avmBrowseBean.setAvmActionNode(new AVMNode(this.getAvmService().lookup(-1, this.getAvmNode().getPath())));
                break;
            }
            tx.commit();
        }
        catch (Throwable err) {
            err.printStackTrace(System.err);
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "close");
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, "details_of") + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getCurrentItemId() {
        return this.getAvmNode().getId();
    }

    @Override
    public String getOutcome() {
        if (this.getAvmNode() != null && AVMUtil.isWorkflowStore(AVMUtil.getStoreName(this.getAvmNode().getPath()))) {
            return "dialog:close:dialog:workflowShowFileDetails";
        }
        return "dialog:close:dialog:showFileDetails";
    }
}

