/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;
import org.alfresco.web.bean.wcm.CreateWebsiteWizard;
import org.alfresco.web.ui.common.component.UIListItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDetailsDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -7191411837509451750L;
    private static final Log logger = LogFactory.getLog(FormDetailsDialog.class);
    private transient AVMService avmService;
    protected CreateWebsiteWizard websiteWizard;
    private transient WorkflowService workflowService;
    private String title;
    private String description;
    private String outputPathPattern;
    private String[] workflowSelectedValue;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.title = null;
        this.description = null;
        this.outputPathPattern = null;
        this.workflowSelectedValue = null;
    }

    @Override
    public String getContainerDescription() {
        return MessageFormat.format(Application.getBundle(FacesContext.getCurrentInstance()).getString("form_template_details_desc"), this.getActionForm().getName(), this.websiteWizard.getName());
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setCreateWebsiteWizard(CreateWebsiteWizard wizard) {
        this.websiteWizard = wizard;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public CreateWebsiteWizard.FormWrapper getActionForm() {
        return this.websiteWizard.getActionForm();
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getActionForm().getDescription();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.getActionForm().getTitle();
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOutputPathPattern() {
        if (this.outputPathPattern == null) {
            this.outputPathPattern = this.getActionForm().getOutputPathPattern();
        }
        return this.outputPathPattern;
    }

    public void setOutputPathPattern(String pattern) {
        this.outputPathPattern = pattern;
    }

    public String[] getWorkflowSelectedValue() {
        CreateWebsiteWizard.WorkflowWrapper workflow;
        if (this.workflowSelectedValue == null && (workflow = this.getActionForm().getWorkflow()) != null) {
            this.workflowSelectedValue = new String[]{workflow.getName()};
        }
        return this.workflowSelectedValue;
    }

    public void setWorkflowSelectedValue(String[] workflowSelectedValue) {
        this.workflowSelectedValue = workflowSelectedValue;
    }

    public List<UIListItem> getWorkflowList() {
        List<WorkflowDefinition> workflowDefs = AVMWorkflowUtil.getConfiguredWorkflows();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(workflowDefs.size());
        for (WorkflowDefinition workflowDef : workflowDefs) {
            UIListItem item = new UIListItem();
            item.setValue(workflowDef.getName());
            item.setLabel(workflowDef.getTitle());
            item.setDescription(workflowDef.getDescription());
            item.setImage("/images/icons/workflow_large.gif");
            items.add(item);
        }
        return items;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        CreateWebsiteWizard.FormWrapper form = this.getActionForm();
        if (this.title != null) {
            form.setTitle(this.title);
        }
        if (this.description != null) {
            form.setDescription(this.description);
        }
        if (this.outputPathPattern != null) {
            form.setOutputPathPattern(this.outputPathPattern);
        }
        if (this.workflowSelectedValue != null && this.workflowSelectedValue.length != 0) {
            String wfSelected = this.workflowSelectedValue[0];
            if (form.getWorkflow() == null || !form.getWorkflow().getName().equals(wfSelected)) {
                WorkflowDefinition def = this.getWorkflowService().getDefinitionByName(wfSelected);
                form.setWorkflow(new CreateWebsiteWizard.WorkflowWrapper(def.getName(), def.getTitle(), def.getDescription()));
            }
        }
        return outcome;
    }
}

