/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.workflow.ManageTaskDialog;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageChangeRequestTaskDialog
extends ManageTaskDialog {
    private static final long serialVersionUID = -236829535702107101L;
    protected boolean doResubmitNow = false;
    protected AVMBrowseBean avmBrowseBean;
    private transient AVMLockingService avmLockingService;
    private static final Log logger = LogFactory.getLog(ManageChangeRequestTaskDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.doResubmitNow = false;
    }

    @Override
    public List<DialogsConfigElement.DialogButtonConfig> getAdditionalButtons() {
        List<DialogsConfigElement.DialogButtonConfig> buttons = super.getAdditionalButtons();
        buttons.add(new DialogsConfigElement.DialogButtonConfig("transition_resubmit", null, "task_done_resubmit_all", "#{DialogManager.bean.transitionAndResubmit}", "false", null));
        return buttons;
    }

    @Override
    public String transition() {
        String outcome = this.getDefaultFinishOutcome();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transitioning change request task: " + this.getWorkflowTask().id));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context);
            tx.begin();
            String username = Application.getCurrentUser(context).getUserName();
            ArrayList<String> newLockOwners = new ArrayList<String>(1);
            newLockOwners.add(username);
            Map<QName, Serializable> params = WorkflowUtil.prepareTaskParams(this.taskNode);
            this.getWorkflowService().updateTask(this.getWorkflowTask().id, params, null, null);
            ArrayList<String> submitPaths = new ArrayList<String>();
            ArrayList<AVMNodeDescriptor> submitNodes = new ArrayList<AVMNodeDescriptor>();
            Pair pkgPath = AVMNodeConverter.ToAVMVersionPath((NodeRef)this.workflowPackage);
            AVMNodeDescriptor pkgDesc = this.getAvmService().lookup(((Integer)pkgPath.getFirst()).intValue(), (String)pkgPath.getSecond());
            String targetPath = pkgDesc.getIndirection();
            List diffs = this.getAvmSyncService().compare(((Integer)pkgPath.getFirst()).intValue(), (String)pkgPath.getSecond(), -1, targetPath, null);
            this.getAvmSyncService().update(diffs, null, false, false, true, true, null, null);
            for (AVMDifference diff : diffs) {
                String diffSourcePath = diff.getSourcePath();
                String diffSourceAvmStore = WCMUtil.getWebProjectStoreIdFromPath((String)diffSourcePath);
                String sourceWebProject = WCMUtil.getWebProjectStoreId((String)diffSourceAvmStore);
                String diffTargetPath = diff.getDestinationPath();
                String diffTargetAvmStore = WCMUtil.getWebProjectStoreIdFromPath((String)diffTargetPath);
                String targetWebProject = WCMUtil.getWebProjectStoreId((String)diffSourceAvmStore);
                if (!sourceWebProject.equals(targetWebProject)) {
                    throw new AlfrescoRuntimeException("The source web project does not match the target web project: \n   Source: " + diffSourcePath + "\n" + "   Target: " + diffTargetPath);
                }
                Map<String, String> lockAttributes = Collections.singletonMap("avm-store-name", diffTargetAvmStore);
                boolean modified = this.getAvmLockingService().modifyLock(sourceWebProject, AVMUtil.getStoreRelativePath(diffSourcePath), username, sourceWebProject, AVMUtil.getStoreRelativePath(diffTargetPath), lockAttributes);
                if (!modified || !logger.isDebugEnabled()) continue;
                logger.debug((Object)("Moved lock: " + AVMUtil.getStoreId(diffSourcePath) + "-" + AVMUtil.getStoreRelativePath(diffSourcePath) + " to user: " + username));
            }
            if (this.doResubmitNow) {
                for (AVMDifference diff : diffs) {
                    String destPath = diff.getDestinationPath();
                    AVMNodeDescriptor node = this.getAvmService().lookup(diff.getDestinationVersion(), destPath, true);
                    if (node == null) continue;
                    submitNodes.add(node);
                    submitPaths.add(destPath);
                }
                this.setupSubmitDialog(context, submitPaths, submitNodes);
            }
            this.getWorkflowService().endTask(this.getWorkflowTask().id, null);
            tx.commit();
            if (this.doResubmitNow) {
                outcome = "dialog:close:dialog:submitSandboxItems";
            }
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(this.formatErrorMessage(e), e);
            outcome = this.getErrorOutcome(e);
        }
        return outcome;
    }

    public String transitionAndResubmit() {
        this.doResubmitNow = true;
        return this.transition();
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    protected AVMLockingService getAvmLockingService() {
        if (this.avmLockingService == null) {
            this.avmLockingService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingService();
        }
        return this.avmLockingService;
    }

    protected void setupSubmitDialog(FacesContext context, List<String> submitPaths, List<AVMNodeDescriptor> submitNodes) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("starting submit dialog with expired paths: " + submitPaths));
        }
        NodeRef userStoreNodeRef = (NodeRef)this.getNodeService().getProperty(this.workflowPackage, WCMModel.PROP_AVM_DIR_INDIRECTION);
        String userStoreAvmPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)userStoreNodeRef).getSecond();
        String userStoreName = AVMUtil.getStoreName(userStoreAvmPath);
        NodeRef webProjectRef = this.getWebProjectService().getWebProjectNodeFromStore(WCMUtil.getWebProjectStoreId((String)userStoreName));
        this.browseBean.clickSpace(webProjectRef);
        this.avmBrowseBean.setupSandboxAction(userStoreName, Application.getCurrentUser(context).getUserName());
        this.avmBrowseBean.setNodesForSubmit(submitNodes);
        HashMap<String, String> dialogParams = new HashMap<String, String>(1);
        dialogParams.put("loadSelectedNodesFromBrowseBean", Boolean.TRUE.toString());
        Application.getDialogManager().setupParameters(dialogParams);
    }
}

