/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIListItems;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegenerateRenditionsWizard
extends BaseWizardBean {
    private static final long serialVersionUID = -8573877482412328963L;
    public final String REGENERATE_SCOPE_ALL = "all";
    public final String REGENERATE_SCOPE_FORM = "form";
    public final String REGENERATE_SCOPE_RENDERING_ENGINE_TEMPLATE = "rendering_engine_template";
    private static final Log logger = LogFactory.getLog(RegenerateRenditionsWizard.class);
    protected transient WebProjectService wpService;
    private transient AVMLockingService avmLockingService;
    private transient AVMService avmService;
    private transient AVMSyncService avmSyncService;
    private transient SearchService searchService;
    private transient FormsService formsService;
    private transient PermissionService permissionService;
    private WebProject selectedWebProject;
    private String[] selectedForms;
    private String[] selectedRenderingEngineTemplates;
    private UIRichList renditionChoicesRichList;
    private List<Rendition> regeneratedRenditions;
    private String regenerateScope;

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (this.regeneratedRenditions != null) {
            ArrayList<AVMDifference> diffList = new ArrayList<AVMDifference>(this.regeneratedRenditions.size());
            for (Rendition r : this.regeneratedRenditions) {
                diffList.add(new AVMDifference(-1, r.getPath(), -1, AVMUtil.getCorrespondingPathInMainStore(r.getPath()), 0));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updating " + diffList.size() + " renditions in staging"));
            }
            this.getAvmSyncService().update(diffList, null, true, true, true, true, null, null);
            String description = null;
            ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
            description = this.regenerateScope.equals("form") ? MessageFormat.format(bundle.getString("regenerate_renditions_snapshot_description_scope_form"), StringUtils.join((Object[])this.selectedForms, (String)", ")) : (this.regenerateScope.equals("rendering_engine_template") ? MessageFormat.format(bundle.getString("regenerate_renditions_snapshot_description_scope_rendering_engine_template"), StringUtils.join((Object[])this.selectedRenderingEngineTemplates, (String)", ")) : MessageFormat.format(bundle.getString("regenerate_renditions_snapshot_description_scope_web_project"), this.selectedWebProject.getName()));
            this.getAvmService().createSnapshot(this.selectedWebProject.getStoreId(), MessageFormat.format(bundle.getString("regenerate_renditions_snapshot_short_description"), diffList.size()), description);
        }
        return outcome;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.selectedWebProject = null;
        this.selectedForms = null;
        this.selectedRenderingEngineTemplates = null;
        this.renditionChoicesRichList = null;
        this.regeneratedRenditions = null;
        this.regenerateScope = "all";
        if (this.browseBean.getDocument() != null) {
            if (this.browseBean.getDocument().hasAspect(WCMAppModel.ASPECT_FORM)) {
                this.selectedForms = new String[]{this.browseBean.getDocument().getName()};
            }
        } else if (this.browseBean.getActionSpace() != null) {
            this.selectedForms = new String[]{this.browseBean.getActionSpace().getName()};
        }
    }

    @Override
    public String next() {
        int step = Application.getWizardManager().getCurrentStep();
        if (step == 2) {
            try {
                this.regeneratedRenditions = this.regenerateRenditions();
            }
            catch (Exception e) {
                Application.getWizardManager().getState().setCurrentStep(step - 1);
                Utils.addErrorMessage(e.getMessage(), e);
            }
        }
        return super.next();
    }

    @Override
    public String cancel() {
        if (this.selectedWebProject != null) {
            String stagingStoreName = this.selectedWebProject.getStoreId();
            String previewStoreName = AVMUtil.getCorrespondingPreviewStoreName(stagingStoreName);
            this.getAvmSyncService().resetLayer(AVMUtil.buildStoreRootPath(previewStoreName));
        }
        return super.cancel();
    }

    @Override
    public boolean getNextButtonDisabled() {
        boolean disabled = false;
        if ("select_renditions".equals(Application.getWizardManager().getCurrentStepName())) {
            disabled = this.selectedWebProject == null;
        }
        return disabled;
    }

    @Override
    public String getStepDescription() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        String stepName = Application.getWizardManager().getCurrentStepName();
        if ("summary".equals(stepName)) {
            String s = this.selectedWebProject.getTitle();
            return MessageFormat.format(bundle.getString("regenerate_renditions_summary_desc"), this.regeneratedRenditions.size(), s != null && s.length() != 0 ? s : this.selectedWebProject.getName());
        }
        return super.getContainerDescription();
    }

    public String getRegenerateScope() {
        return this.regenerateScope;
    }

    public void setRegenerateScope(String regenerateScope) {
        this.regenerateScope = regenerateScope;
    }

    public List<SelectItem> getWebProjectChoices() {
        List wpInfos = this.getWebProjectService().listWebProjects();
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(wpInfos.size());
        QuickSort sorter = new QuickSort(wpInfos, "name", true, "case-insensitive");
        sorter.sort();
        for (WebProjectInfo wpInfo : wpInfos) {
            if (this.getPermissionService().hasPermission(wpInfo.getNodeRef(), "ContentManager") != AccessStatus.ALLOWED) continue;
            String s = wpInfo.getTitle();
            if (this.selectedWebProject == null) {
                this.selectedWebProject = new WebProject(wpInfo.getNodeRef());
            }
            result.add(new SelectItem((Object)wpInfo.getNodeRef().toString(), s != null && s.length() != 0 ? s : wpInfo.getName()));
        }
        return result;
    }

    public String getSelectedWebProject() {
        return this.selectedWebProject == null ? null : this.selectedWebProject.getNodeRef().toString();
    }

    public void setSelectedWebProject(String webProject) {
        this.selectedWebProject = webProject == null || webProject.length() == 0 ? null : new WebProject(new NodeRef(webProject));
        UIViewRoot c = FacesContext.getCurrentInstance().getViewRoot();
        ((UIListItems)c.findComponent("wizard:wizard-body:select_list_form_choices:list_items_form_choices")).setValue(null);
        ((UIListItems)c.findComponent("wizard:wizard-body:select_list_rendering_engine_template_choices:list_items_rendering_engine_template_choices")).setValue(null);
        this.renditionChoicesRichList = null;
    }

    public List<UIListItem> getFormChoices() {
        LinkedList<UIListItem> result = new LinkedList<UIListItem>();
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        if (this.selectedWebProject != null) {
            for (Form f : this.selectedWebProject.getForms()) {
                UIListItem item = new UIListItem();
                item.setValue(f.getName());
                item.setLabel(f.getTitle());
                List<FormInstanceData> fids = this.getRelatedFormInstanceData(this.selectedWebProject, f);
                item.setDescription(MessageFormat.format(bundle.getString("regenerate_renditions_select_renditions_select_item_desc"), fids.size() * f.getRenderingEngineTemplates().size(), this.selectedWebProject.getName()));
                item.setImage("/images/icons/webform_large.gif");
                result.add(item);
            }
        }
        return result;
    }

    public String[] getSelectedForms() {
        return this.selectedForms;
    }

    public void setSelectedForms(String[] forms) {
        this.selectedForms = forms == null || forms.length == 0 ? null : forms;
    }

    public String getSelectedForm() {
        return this.selectedForms != null && this.selectedForms.length != 0 ? this.selectedForms[0] : null;
    }

    public void setSelectedForm(String form) {
        String[] stringArray;
        if (form == null || form.length() == 0) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = form;
        }
        this.selectedForms = stringArray;
        this.renditionChoicesRichList = null;
    }

    public List<UIListItem> getRenderingEngineTemplateChoices() {
        LinkedList<UIListItem> result = new LinkedList<UIListItem>();
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        for (Form f : this.selectedWebProject.getForms()) {
            for (RenderingEngineTemplate ret : f.getRenderingEngineTemplates()) {
                UIListItem item = new UIListItem();
                item.setValue(f.getName() + ":" + ret.getName());
                item.setLabel(ret.getTitle() + "(" + ret.getMimetypeForRendition() + ")");
                List<Rendition> rs = this.getRelatedRenditions(this.selectedWebProject, ret);
                item.setDescription(MessageFormat.format(bundle.getString("regenerate_renditions_select_renditions_select_item_desc"), rs.size(), this.selectedWebProject.getName()));
                item.setImage(FileTypeImageUtils.getFileTypeImage((String)ret.getName(), (boolean)false));
                result.add(item);
            }
        }
        return result;
    }

    public String[] getSelectedRenderingEngineTemplates() {
        return this.selectedRenderingEngineTemplates;
    }

    public void setSelectedRenderingEngineTemplates(String[] renderingEngineTemplates) {
        this.selectedRenderingEngineTemplates = renderingEngineTemplates;
        this.renditionChoicesRichList = null;
    }

    public List<Rendition> getRegeneratedRenditions() {
        return this.regeneratedRenditions;
    }

    public void setRegeneratedRenditionsRichList(UIRichList richList) {
        this.renditionChoicesRichList = richList;
    }

    public UIRichList getRegeneratedRenditionsRichList() {
        return this.renditionChoicesRichList;
    }

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWebProjectService();
        }
        return this.wpService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    private AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    private AVMLockingService getAvmLockingService() {
        if (this.avmLockingService == null) {
            this.avmLockingService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingService();
        }
        return this.avmLockingService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    private AVMSyncService getAvmSyncService() {
        if (this.avmSyncService == null) {
            this.avmSyncService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMSyncService();
        }
        return this.avmSyncService;
    }

    @Override
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    private FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = (PermissionService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "PermissionService");
        }
        return this.permissionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FormInstanceData> getRelatedFormInstanceData(WebProject webProject, Form f) {
        SearchParameters sp = new SearchParameters();
        StoreRef storeRef = AVMNodeConverter.ToStoreRef((String)webProject.getStagingStore());
        sp.addStore(storeRef);
        sp.setLanguage("lucene");
        StringBuilder query = new StringBuilder(256);
        query.append("+ASPECT:\"" + WCMAppModel.ASPECT_FORM_INSTANCE_DATA + "\"");
        query.append(" -ASPECT:\"" + WCMAppModel.ASPECT_RENDITION + "\"");
        query.append(" +@" + Repository.escapeQName(WCMAppModel.PROP_PARENT_FORM_NAME) + ":\"" + f.getName() + "\"");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("running query " + query));
        }
        sp.setQuery(query.toString());
        ResultSet rs = this.getSearchService().query(sp);
        try {
            ArrayList<FormInstanceData> result = new ArrayList<FormInstanceData>(rs.length());
            for (ResultSetRow row : rs) {
                String avmPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)row.getNodeRef()).getSecond();
                String previewAvmPath = AVMUtil.getCorrespondingPathInPreviewStore(avmPath);
                try {
                    FormInstanceData fid = this.getFormsService().getFormInstanceData(-1, previewAvmPath);
                    result.add(fid);
                }
                catch (FormNotFoundException fnfe) {}
            }
            ArrayList<FormInstanceData> arrayList = result;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Rendition> getRelatedRenditions(WebProject webProject, RenderingEngineTemplate ret) {
        SearchParameters sp = new SearchParameters();
        StoreRef storeRef = AVMNodeConverter.ToStoreRef((String)webProject.getStagingStore());
        sp.addStore(storeRef);
        sp.setLanguage("lucene");
        StringBuilder query = new StringBuilder();
        query.append("+ASPECT:\"" + WCMAppModel.ASPECT_RENDITION + "\"");
        query.append(" +@" + Repository.escapeQName(WCMAppModel.PROP_PARENT_RENDERING_ENGINE_TEMPLATE) + ":\"" + ((RenderingEngineTemplateImpl)ret).getNodeRef() + "\"");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("running query " + query));
        }
        sp.setQuery(query.toString());
        ResultSet rs = this.getSearchService().query(sp);
        try {
            ArrayList<Rendition> result = new ArrayList<Rendition>(rs.length());
            for (ResultSetRow row : rs) {
                String avmPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)row.getNodeRef()).getSecond();
                String previewAvmPath = AVMUtil.getCorrespondingPathInPreviewStore(avmPath);
                result.add(this.getFormsService().getRendition(-1, previewAvmPath));
            }
            ArrayList<Rendition> arrayList = result;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Rendition> regenerateRenditions() {
        int i;
        String stagingStoreName = this.selectedWebProject.getStoreId();
        String previewStoreName = AVMUtil.getCorrespondingPreviewStoreName(stagingStoreName);
        this.getAvmSyncService().resetLayer(AVMUtil.buildStoreRootPath(previewStoreName));
        SearchParameters sp = new SearchParameters();
        StoreRef storeRef = AVMNodeConverter.ToStoreRef((String)this.selectedWebProject.getStagingStore());
        sp.addStore(storeRef);
        sp.setLanguage("lucene");
        StringBuilder query = new StringBuilder(128);
        if (this.regenerateScope.equals("all") || this.regenerateScope.equals("form")) {
            query.append("+ASPECT:\"" + WCMAppModel.ASPECT_FORM_INSTANCE_DATA + "\"");
            query.append(" -ASPECT:\"" + WCMAppModel.ASPECT_RENDITION + "\"");
        } else {
            query.append("+ASPECT:\"" + WCMAppModel.ASPECT_RENDITION + "\"");
        }
        if (this.regenerateScope.equals("form") && this.selectedForms != null) {
            query.append(" +(");
            for (i = 0; i < this.selectedForms.length; ++i) {
                query.append("@" + Repository.escapeQName(WCMAppModel.PROP_PARENT_FORM_NAME) + ":\"" + this.selectedForms[i] + "\"");
                if (i == this.selectedForms.length - 1) continue;
                query.append(" OR ");
            }
            query.append(") ");
        }
        if (this.regenerateScope.equals("rendering_engine_template") && this.selectedRenderingEngineTemplates != null) {
            query.append(" +(");
            for (i = 0; i < this.selectedRenderingEngineTemplates.length; ++i) {
                String[] parts = this.selectedRenderingEngineTemplates[i].split(":");
                String formName = parts[0];
                String templateName = parts[1];
                try {
                    Form f = this.selectedWebProject.getForm(formName);
                    RenderingEngineTemplate ret = f.getRenderingEngineTemplate(templateName);
                    query.append("@" + Repository.escapeQName(WCMAppModel.PROP_PARENT_RENDERING_ENGINE_TEMPLATE) + ":\"" + ((RenderingEngineTemplateImpl)ret).getNodeRef() + "\"");
                    if (i == this.selectedRenderingEngineTemplates.length - 1) continue;
                    query.append(" OR ");
                    continue;
                }
                catch (FormNotFoundException fnfe) {
                    logger.warn((Object)("regenerating renditions of template " + templateName + ": " + fnfe.getMessage()), (Throwable)fnfe);
                }
            }
            query.append(") ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("running query " + query));
        }
        sp.setQuery(query.toString());
        ResultSet rs = this.getSearchService().query(sp);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("received " + rs.length() + " results"));
            }
            ArrayList<Rendition> result = new ArrayList<Rendition>(rs.length());
            for (ResultSetRow row : rs) {
                String avmPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)row.getNodeRef()).getSecond();
                String previewAvmPath = AVMUtil.getCorrespondingPathInPreviewStore(avmPath);
                if (this.regenerateScope.equals("all") || this.regenerateScope.equals("form")) {
                    FormInstanceData fid = null;
                    try {
                        fid = this.formsService.getFormInstanceData(-1, previewAvmPath);
                        List<FormInstanceData.RegenerateResult> regenResults = fid.regenerateRenditions();
                        for (FormInstanceData.RegenerateResult rr : regenResults) {
                            if (rr.getException() != null) {
                                Utils.addErrorMessage("error regenerating rendition using " + rr.getRenderingEngineTemplate().getName() + ": " + rr.getException().getMessage(), rr.getException());
                            } else {
                                result.add(rr.getRendition());
                            }
                            if (rr.getRendition() == null) continue;
                            this.getAvmLockingService().removeLock(AVMUtil.getStoreId(rr.getRendition().getPath()), AVMUtil.getStoreRelativePath(rr.getRendition().getPath()));
                        }
                        continue;
                    }
                    catch (FormNotFoundException fnfe) {
                        logger.warn((Object)("regenerating renditions of " + previewAvmPath + ": " + fnfe.getMessage()), (Throwable)fnfe);
                        continue;
                    }
                }
                Rendition r = this.formsService.getRendition(-1, previewAvmPath);
                try {
                    r.regenerate();
                    result.add(r);
                    this.getAvmLockingService().removeLock(AVMUtil.getStoreId(r.getPath()), AVMUtil.getStoreRelativePath(r.getPath()));
                }
                catch (RenderingEngine.TemplateNotFoundException tnfe) {
                    logger.warn((Object)("regenerating renditions of " + previewAvmPath + ": " + tnfe.getMessage()), (Throwable)((Object)tnfe));
                }
                catch (IllegalArgumentException iae) {
                    logger.warn((Object)("regenerating renditions of " + previewAvmPath + ": " + iae.getMessage()), (Throwable)iae);
                }
                catch (Exception e) {
                    Utils.addErrorMessage("error regenerating rendition using " + r.getRenderingEngineTemplate().getName() + ": " + e.getMessage(), e);
                }
            }
            ArrayList<Rendition> arrayList = result;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }
}

