/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.util.NameMatcher;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.sandbox.SandboxVersion;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.wcm.AVMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMCompareUtils {
    public static List<Map<String, String>> getComparedNodes(AVMSyncService avmSyncService, int srcVersion, String srcPath, int dstVersion, String dstPath, NameMatcher excluder) {
        FacesContext context = FacesContext.getCurrentInstance();
        List compare = avmSyncService.compare(srcVersion, srcPath, dstVersion, dstPath, excluder);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (AVMDifference diff : compare) {
            String status;
            String path = diff.getSourcePath();
            HashMap<String, String> node = new HashMap<String, String>();
            String sandboxPath = AVMUtil.getSandboxPath(path);
            node.put("path", path.replaceFirst(sandboxPath, ""));
            node.put("name", path.substring(path.lastIndexOf("/") + 1));
            switch (diff.getDifferenceCode()) {
                case 1: {
                    status = Application.getMessage(context, "avm_compare_older");
                    break;
                }
                case 0: {
                    status = Application.getMessage(context, "avm_compare_newer");
                    break;
                }
                case 4: {
                    status = Application.getMessage(context, "avm_compare_same");
                    break;
                }
                case 3: {
                    status = Application.getMessage(context, "avm_compare_directory");
                    break;
                }
                case 2: {
                    status = Application.getMessage(context, "avm_compare_conflict");
                    break;
                }
                default: {
                    status = "";
                }
            }
            node.put("status", status);
            result.add(node);
        }
        return result;
    }

    public static boolean isFirstVersion(List<SandboxVersion> versions, SandboxVersion item) {
        boolean result = false;
        if (versions.size() > 0 && item.getVersion() == Collections.min(versions, new SandboxVersionComparator()).getVersion()) {
            result = true;
        }
        return result;
    }

    public static boolean isLatestVersion(List<SandboxVersion> versions, SandboxVersion item) {
        boolean result = false;
        if (versions.size() > 0 && item.getVersion() == Collections.max(versions, new SandboxVersionComparator()).getVersion()) {
            result = true;
        }
        return result;
    }

    public static int getPrevVersionID(SandboxService sandboxService, String name, int version) {
        List<Integer> allVersions = WCMCompareUtils.getAllVersionID(sandboxService, name);
        Collections.sort(allVersions);
        int index = allVersions.indexOf(version);
        if (index == 0) {
            return 0;
        }
        if (index == -1) {
            return -1;
        }
        return allVersions.get(index - 1);
    }

    public static List<String> receiveStoresList(AVMService avmService) {
        ArrayList<String> result = new ArrayList<String>();
        List storeDescs = avmService.getStores();
        for (AVMStoreDescriptor storeDesc : storeDescs) {
            if (storeDesc.getCreator().equalsIgnoreCase("System") || AVMUtil.isPreviewStore(storeDesc.getName())) continue;
            result.add(storeDesc.getName());
        }
        return result;
    }

    public static List<Integer> getAllVersionID(SandboxService sandboxService, String store) {
        List allVersions = sandboxService.listSnapshots(store, false);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (SandboxVersion sandboxVersion : allVersions) {
            result.add(sandboxVersion.getVersion());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SandboxVersionComparator
    implements Comparator<SandboxVersion> {
        private SandboxVersionComparator() {
        }

        @Override
        public int compare(SandboxVersion o1, SandboxVersion o2) {
            return Integer.valueOf(o1.getVersion()).compareTo(o2.getVersion());
        }
    }
}

