/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormImpl;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProject
implements Serializable {
    private static final long serialVersionUID = 2480625511643744703L;
    private static final Log LOGGER = LogFactory.getLog(WebProject.class);
    private final NodeRef nodeRef;
    private String storeId = null;

    public WebProject(NodeRef nodeRef) {
        if (nodeRef == null) {
            throw new NullPointerException();
        }
        NodeService nodeService = WebProject.getServiceRegistry().getNodeService();
        if (!WCMAppModel.TYPE_AVMWEBFOLDER.equals((Object)nodeService.getType(nodeRef))) {
            throw new IllegalArgumentException(nodeRef + " is not a " + WCMAppModel.TYPE_AVMWEBFOLDER);
        }
        this.nodeRef = nodeRef;
    }

    public WebProject(String avmPath) {
        if (avmPath == null) {
            throw new NullPointerException();
        }
        String stagingStore = AVMUtil.buildStagingStoreName(AVMUtil.getStoreId(AVMUtil.getStoreName(avmPath)));
        AVMService avmService = this.getServiceRegistry().getAVMService();
        this.nodeRef = (NodeRef)avmService.getStoreProperty(stagingStore, SandboxConstants.PROP_WEB_PROJECT_NODE_REF).getValue(DataTypeDefinition.NODE_REF);
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String getName() {
        NodeService nodeService = WebProject.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_NAME));
    }

    public String getTitle() {
        NodeService nodeService = WebProject.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE));
    }

    public String getDescription() {
        NodeService nodeService = WebProject.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION));
    }

    public String getStoreId() {
        if (this.storeId == null) {
            NodeService nodeService = WebProject.getServiceRegistry().getNodeService();
            this.storeId = (String)((Object)nodeService.getProperty(this.nodeRef, WCMAppModel.PROP_AVMSTORE));
        }
        return this.storeId;
    }

    public String getStagingStore() {
        return AVMUtil.buildStagingStoreName(this.getStoreId());
    }

    public List<Form> getForms() {
        ArrayList<Form> forms = new ArrayList<Form>(this.getFormsImpl().values());
        QuickSort sorter = new QuickSort(forms, "name", true, "case-insensitive");
        sorter.sort();
        return Collections.unmodifiableList(forms);
    }

    public Form getForm(String name) throws FormNotFoundException {
        if (name == null) {
            throw new NullPointerException();
        }
        Form result = this.getFormsImpl().get(name);
        if (result == null || !name.equals(result.getName())) {
            if (result != null) {
                LOGGER.debug((Object)("removing " + name + " from cache as it doesn't match mapped form " + result.getName()));
                this.getFormsImpl().remove(name);
            }
            throw new FormNotFoundException(name, this);
        }
        return result;
    }

    public boolean hasWorkflow() {
        return true;
    }

    private Map<String, Form> getFormsImpl() {
        ServiceRegistry serviceRegistry = this.getServiceRegistry();
        NodeService nodeService = serviceRegistry.getNodeService();
        FormsService formsService = WebProject.getFormsService();
        List formRefs = nodeService.getChildAssocs(this.nodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBFORM, RegexQNamePattern.MATCH_ALL);
        HashMap<String, Form> result = new HashMap<String, Form>(formRefs.size(), 1.0f);
        for (ChildAssociationRef ref : formRefs) {
            String formName = (String)((Object)nodeService.getProperty(ref.getChildRef(), WCMAppModel.PROP_FORMNAME));
            try {
                Form baseForm = formsService.getWebForm(formName);
                result.put(formName, new FormWrapper(baseForm, ref.getChildRef(), formsService));
            }
            catch (FormNotFoundException fnfe) {
                LOGGER.debug((Object)("got exception " + fnfe.getMessage() + " while loading web forms for project " + this.getName()));
            }
        }
        return result;
    }

    private static FormsService getFormsService() {
        return (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
    }

    private static ServiceRegistry getServiceRegistry() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Repository.getServiceRegistry(fc);
    }

    public boolean equals(Object other) {
        return other != null && other instanceof WebProject && this.getNodeRef().equals((Object)((WebProject)other).getNodeRef());
    }

    public int hashCode() {
        return this.nodeRef.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FormWrapper
    extends FormImpl {
        private static final long serialVersionUID = 1L;
        private final NodeRef formNodeRef;
        private Form baseForm;
        private NodeRef defaultWorkflowNodeRef;

        private FormWrapper(Form form, NodeRef formNodeRef, FormsService formsService) {
            super(((FormImpl)form).getNodeRef(), formsService);
            this.formNodeRef = formNodeRef;
        }

        @Override
        public String getTitle() {
            NodeService nodeService = this.getServiceRegistry().getNodeService();
            return (String)((Object)nodeService.getProperty(this.formNodeRef, ContentModel.PROP_TITLE));
        }

        @Override
        public String getDescription() {
            NodeService nodeService = this.getServiceRegistry().getNodeService();
            return (String)((Object)nodeService.getProperty(this.formNodeRef, ContentModel.PROP_DESCRIPTION));
        }

        @Override
        public String getOutputPathPattern() {
            NodeService nodeService = this.getServiceRegistry().getNodeService();
            String result = (String)((Object)nodeService.getProperty(this.formNodeRef, WCMAppModel.PROP_OUTPUT_PATH_PATTERN));
            return result != null ? result : this.baseForm.getOutputPathPattern();
        }

        @Override
        protected NodeRef getDefaultWorkflowNodeRef() {
            if (this.defaultWorkflowNodeRef == null) {
                NodeService nodeService = this.getServiceRegistry().getNodeService();
                List workflowRefs = nodeService.getChildAssocs(this.formNodeRef, (QNamePattern)WCMAppModel.ASSOC_WORKFLOWDEFAULTS, RegexQNamePattern.MATCH_ALL);
                if (workflowRefs.size() == 0) {
                    return null;
                }
                this.defaultWorkflowNodeRef = ((ChildAssociationRef)workflowRefs.get(0)).getChildRef();
            }
            return this.defaultWorkflowNodeRef;
        }

        @Override
        protected Map<String, RenderingEngineTemplate> loadRenderingEngineTemplates() {
            Map<String, RenderingEngineTemplate> allRets = super.loadRenderingEngineTemplates();
            NodeService nodeService = this.getServiceRegistry().getNodeService();
            List retNodeRefs = nodeService.getChildAssocs(this.formNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBFORMTEMPLATE, RegexQNamePattern.MATCH_ALL);
            HashMap<String, RenderingEngineTemplate> result = new HashMap<String, RenderingEngineTemplate>(retNodeRefs.size(), 1.0f);
            for (ChildAssociationRef car : retNodeRefs) {
                String renderingEngineTemplateName = (String)((Object)nodeService.getProperty(car.getChildRef(), WCMAppModel.PROP_BASE_RENDERING_ENGINE_TEMPLATE_NAME));
                final String outputPathPattern = (String)((Object)nodeService.getProperty(car.getChildRef(), WCMAppModel.PROP_OUTPUT_PATH_PATTERN));
                RenderingEngineTemplateImpl ret = (RenderingEngineTemplateImpl)allRets.get(renderingEngineTemplateName);
                if (ret == null) continue;
                result.put(ret.getName(), new RenderingEngineTemplateImpl(ret.getNodeRef(), ret.getRenditionPropertiesNodeRef(), this.getFormsService()){
                    private static final long serialVersionUID = -5498865830153013192L;

                    public String getOutputPathPattern() {
                        return outputPathPattern;
                    }
                });
            }
            return result;
        }
    }
}

