/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wizard;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.TemplateMailHelperBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.SortableSelectItem;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIGenericPicker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.BooleanQuery;
import org.springframework.mail.javamail.JavaMailSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInviteUsersWizard
extends BaseWizardBean {
    private static final long serialVersionUID = -5145813383038390250L;
    private static final Log logger = LogFactory.getLog(BaseInviteUsersWizard.class);
    protected static final String MSG_USERROLES = "invite_users_summary";
    private static final String MSG_USERS = "users";
    private static final String MSG_GROUPS = "groups";
    private static final String MSG_INVITED_TO = "invited_to";
    private static final String MSG_INVITED_ROLE = "invite_role";
    private static final String MSG_MAX_USERS = "max_users_returned";
    private static final String MSG_SEARCH_MINIMUM = "picker_search_min";
    protected static final String STEP_NOTIFY = "notify";
    private static final String NOTIFY_YES = "yes";
    private static final String NOTIFY_NO = "no";
    private transient NamespaceService namespaceService;
    private transient JavaMailSender mailSender;
    private transient AuthorityService authorityService;
    protected transient PermissionService permissionService;
    private transient PersonService personService;
    protected TemplateMailHelperBean mailHelper;
    private transient DataModel userRolesDataModel = null;
    protected List<UserGroupRole> userGroupRoles = null;
    protected boolean allowDuplicateAuthorities = true;
    protected boolean maxUsersReturned = false;
    private String notify = "no";

    protected abstract Set<String> getPermissionsForType();

    protected abstract Node getNode();

    public List<SelectItem> getEmailTemplates() {
        ArrayList<Object> wrappers = null;
        try {
            FacesContext fc = FacesContext.getCurrentInstance();
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            NamespaceService resolver = Repository.getServiceRegistry(fc).getNamespaceService();
            List results = this.getSearchService().selectNodes(rootNodeRef, this.getEmailTemplateXPath(), null, (NamespacePrefixResolver)resolver, false);
            wrappers = new ArrayList(results.size() + 1);
            if (results.size() != 0) {
                DictionaryService dd = Repository.getServiceRegistry(fc).getDictionaryService();
                for (NodeRef ref : results) {
                    Node childNode;
                    if (!this.getNodeService().exists(ref) || !dd.isSubClass((childNode = new Node(ref)).getType(), ContentModel.TYPE_CONTENT)) continue;
                    wrappers.add(new SelectItem((Object)childNode.getId(), childNode.getName()));
                }
                QuickSort sorter = new QuickSort(wrappers, "label", true, "case-insensitive");
                sorter.sort();
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        if (wrappers == null) {
            wrappers = new ArrayList<SelectItem>(1);
        }
        wrappers.add(0, new SelectItem((Object)"none", Application.getMessage(FacesContext.getCurrentInstance(), "select_a_template")));
        return wrappers;
    }

    protected abstract String getEmailTemplateXPath();

    @Override
    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @Override
    protected NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected AuthorityService getAuthorityService() {
        if (this.authorityService == null) {
            this.authorityService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authorityService;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.maxUsersReturned = false;
        this.notify = NOTIFY_NO;
        this.userRolesDataModel = null;
        this.userGroupRoles = new ArrayList<UserGroupRole>(8);
        this.mailHelper = new TemplateMailHelperBean();
        this.mailHelper.setMailSender(this.mailSender);
        this.mailHelper.setNodeService(this.getNodeService());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        User user = Application.getCurrentUser(context);
        String from = (String)((Object)this.getNodeService().getProperty(user.getPerson(), ContentModel.PROP_EMAIL));
        if (from == null || from.length() == 0) {
            from = Application.getClientConfig(context).getFromEmailAddress();
        }
        NodeRef nodeRef = this.getNode().getNodeRef();
        for (int i = 0; i < this.userGroupRoles.size(); ++i) {
            UserGroupRole userGroupRole = this.userGroupRoles.get(i);
            String authority = userGroupRole.getAuthority();
            Set<String> perms = this.getPermissionsForType();
            for (String permission : perms) {
                if (!userGroupRole.getRole().equals(permission)) continue;
                this.getPermissionService().setPermission(nodeRef, authority, permission, true);
                break;
            }
            if (!NOTIFY_YES.equals(this.notify)) continue;
            AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
            if (authType.equals((Object)AuthorityType.USER)) {
                if (!this.getPersonService().personExists(authority)) continue;
                this.mailHelper.notifyUser(this.getPersonService().getPerson(authority), nodeRef, from, userGroupRole.getRole());
                continue;
            }
            if (!authType.equals((Object)AuthorityType.GROUP)) continue;
            Set users = this.getAuthorityService().getContainedAuthorities(AuthorityType.USER, authority, false);
            for (String userAuth : users) {
                if (!this.getPersonService().personExists(userAuth)) continue;
                this.mailHelper.notifyUser(this.getPersonService().getPerson(userAuth), nodeRef, from, userGroupRole.getRole());
            }
        }
        this.maxUsersReturned = false;
        return outcome;
    }

    @Override
    public String cancel() {
        this.maxUsersReturned = false;
        return super.cancel();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        boolean disabled = true;
        String stepName = Application.getWizardManager().getCurrentStepName();
        if (STEP_NOTIFY.equals(stepName)) {
            disabled = false;
        }
        return disabled;
    }

    public DataModel getUserRolesDataModel() {
        if (this.userRolesDataModel == null) {
            this.userRolesDataModel = new ListDataModel();
        }
        if (this.userRolesDataModel.getWrappedData() == null) {
            this.userRolesDataModel.setWrappedData(this.userGroupRoles);
        }
        return this.userRolesDataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectItem[] pickerCallback(int filterIndex, String contains) {
        Object[] items;
        FacesContext context = FacesContext.getCurrentInstance();
        String search = contains.trim();
        int searchMin = Application.getClientConfig(context).getPickerSearchMinimum();
        if (search.length() < searchMin) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, MSG_SEARCH_MINIMUM), searchMin));
            return new SelectItem[0];
        }
        this.maxUsersReturned = false;
        UserTransaction tx = null;
        try {
            List<SelectItem> results;
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            int maxResults = Application.getClientConfig(context).getInviteUsersMaxResults();
            if (filterIndex == 0) {
                List nodes;
                String term = LuceneQueryParser.escape((String)search);
                StringBuilder query = new StringBuilder(128);
                if (contains == null || contains.length() == 0) {
                    query.append("+TYPE:\"");
                    query.append(ContentModel.TYPE_PERSON.toString());
                    query.append("\"");
                } else {
                    Utils.generatePersonSearch(query, term);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Maximum invite users results size: " + maxResults));
                    logger.debug((Object)("Using query to find users: " + query.toString()));
                }
                SearchParameters searchParams = new SearchParameters();
                searchParams.addStore(Repository.getStoreRef());
                searchParams.setLanguage("lucene");
                searchParams.setQuery(query.toString());
                if (maxResults > 0) {
                    searchParams.setLimit(maxResults);
                    searchParams.setLimitBy(LimitBy.FINAL_SIZE);
                }
                ResultSet resultSet = Repository.getServiceRegistry(context).getSearchService().query(searchParams);
                try {
                    nodes = resultSet.getNodeRefs();
                }
                finally {
                    resultSet.close();
                }
                results = new ArrayList<SelectItem>(nodes.size());
                for (int index = 0; index < nodes.size(); ++index) {
                    NodeRef personRef = (NodeRef)nodes.get(index);
                    String firstName = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_FIRSTNAME));
                    String lastName = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_LASTNAME));
                    String username = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_USERNAME));
                    if (username == null) continue;
                    SortableSelectItem item = new SortableSelectItem(username, firstName + " " + lastName + " [" + username + "]", lastName);
                    results.add(item);
                }
            } else {
                results = this.addGroupItems(search, maxResults);
            }
            items = new SelectItem[results.size()];
            results.toArray(items);
            Arrays.sort(items);
            if (results.size() == maxResults) {
                this.maxUsersReturned = true;
            }
            tx.commit();
        }
        catch (BooleanQuery.TooManyClauses clauses) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "too_many_users"));
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            items = new SelectItem[]{};
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            items = new SelectItem[]{};
        }
        return items;
    }

    private List<SelectItem> addGroupItems(String search, int maxResults) {
        Set<String> groups = this.getGroups(search);
        ArrayList<SelectItem> results = new ArrayList<SelectItem>(groups.size());
        int count = 0;
        for (String group : groups) {
            String groupDisplayName = this.getAuthorityService().getAuthorityDisplayName(group);
            if (groupDisplayName == null || groupDisplayName.length() == 0) {
                groupDisplayName = group.substring("GROUP_".length());
            }
            results.add(new SortableSelectItem(group, groupDisplayName, groupDisplayName));
            if (++count != maxResults) continue;
            break;
        }
        return results;
    }

    protected Set<String> getGroups(String search) {
        String term = "*" + search + "*";
        Set groups = this.getAuthorityService().findAuthorities(AuthorityType.GROUP, null, false, term, "APP.DEFAULT");
        groups.addAll(this.getAuthorityService().getAllAuthorities(AuthorityType.EVERYONE));
        return groups;
    }

    public void addSelection(ActionEvent event) {
        String role;
        UIGenericPicker picker = (UIGenericPicker)event.getComponent().findComponent("picker");
        UISelectOne rolePicker = (UISelectOne)event.getComponent().findComponent("roles");
        String[] results = picker.getSelectedResults();
        if (results != null && (role = (String)rolePicker.getValue()) != null) {
            for (int i = 0; i < results.length; ++i) {
                this.addAuthorityWithRole(results[i], role);
            }
        }
    }

    public void addAuthorityWithRole(String authority, String role) {
        boolean foundExisting = false;
        for (int n = 0; n < this.userGroupRoles.size(); ++n) {
            UserGroupRole wrapper = this.userGroupRoles.get(n);
            if (!authority.equals(wrapper.getAuthority()) || this.allowDuplicateAuthorities && !role.equals(wrapper.getRole())) continue;
            foundExisting = true;
            break;
        }
        if (!foundExisting) {
            StringBuilder label = new StringBuilder(64);
            AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
            if (authType == AuthorityType.GUEST || authType == AuthorityType.USER) {
                if (authType == AuthorityType.GUEST || this.getPersonService().personExists(authority)) {
                    label.append(this.buildLabelForUserAuthorityRole(authority, role));
                }
            } else {
                label.append(this.buildLabelForGroupAuthorityRole(authority, role));
            }
            this.userGroupRoles.add(new UserGroupRole(authority, role, label.toString()));
        }
    }

    public void removeSelection(ActionEvent event) {
        UserGroupRole wrapper = (UserGroupRole)this.getUserRolesDataModel().getRowData();
        if (wrapper != null) {
            this.userGroupRoles.remove(wrapper);
        }
    }

    public SelectItem[] getFilters() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return new SelectItem[]{new SelectItem((Object)"0", bundle.getString(MSG_USERS)), new SelectItem((Object)"1", bundle.getString(MSG_GROUPS))};
    }

    public SelectItem[] getRoles() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        Set<String> perms = this.getPermissionsForType();
        SelectItem[] roles = new SelectItem[perms.size()];
        int index = 0;
        for (String permission : perms) {
            String displayLabel = bundle.getString(permission);
            if (displayLabel.startsWith("$$")) {
                displayLabel = permission;
            }
            roles[index++] = new SelectItem((Object)permission, displayLabel);
        }
        return roles;
    }

    public String getNotify() {
        return this.notify;
    }

    public void setNotify(String notify) {
        this.notify = notify;
    }

    @Override
    public String next() {
        String stepName = Application.getWizardManager().getCurrentStepName();
        if (STEP_NOTIFY.equals(stepName)) {
            String roleText;
            FacesContext context = FacesContext.getCurrentInstance();
            StringBuilder buf = new StringBuilder(256);
            String personName = Application.getCurrentUser(context).getFullName(this.getNodeService());
            String msgInvitedTo = Application.getMessage(context, MSG_INVITED_TO);
            Node node = this.getNode();
            String path = this.getNodeService().getPath(node.getNodeRef()).toDisplayPath(this.getNodeService(), this.getPermissionService());
            buf.append(MessageFormat.format(msgInvitedTo, path + '/' + node.getName(), personName));
            this.mailHelper.setSubject(buf.toString());
            buf.append("\r\n\r\n");
            String msgRole = Application.getMessage(context, MSG_INVITED_ROLE);
            if (this.userGroupRoles.size() != 0) {
                String roleMsg = Application.getMessage(context, this.userGroupRoles.get(0).getRole());
                roleText = MessageFormat.format(msgRole, roleMsg);
            } else {
                roleText = MessageFormat.format(msgRole, "[role]");
            }
            buf.append(roleText);
            this.mailHelper.setAutomaticText(buf.toString());
            this.mailHelper.setBody(this.mailHelper.getAutomaticText());
        }
        return null;
    }

    public TemplateMailHelperBean getMailHelper() {
        return this.mailHelper;
    }

    public String buildLabelForUserAuthorityRole(String authority, String role) {
        NodeRef ref = this.getPersonService().getPerson(authority);
        String firstName = (String)((Object)this.getNodeService().getProperty(ref, ContentModel.PROP_FIRSTNAME));
        String lastName = (String)((Object)this.getNodeService().getProperty(ref, ContentModel.PROP_LASTNAME));
        StringBuilder buf = new StringBuilder(100);
        buf.append(firstName).append(" ").append(lastName != null ? lastName : "").append(" (").append(Application.getMessage(FacesContext.getCurrentInstance(), role)).append(")");
        return buf.toString();
    }

    public String buildLabelForGroupAuthorityRole(String authority, String role) {
        String groupDisplayName = this.authorityService.getAuthorityDisplayName(authority);
        if (groupDisplayName == null || groupDisplayName.length() == 0) {
            groupDisplayName = authority.substring("GROUP_".length());
        }
        StringBuilder buf = new StringBuilder(100);
        buf.append(groupDisplayName).append(" (").append(Application.getMessage(FacesContext.getCurrentInstance(), role)).append(")");
        return buf.toString();
    }

    public String getSummary() {
        FacesContext fc = FacesContext.getCurrentInstance();
        StringBuilder buf = new StringBuilder(128);
        for (UserGroupRole userRole : this.userGroupRoles) {
            buf.append(Utils.encode((String)userRole.getLabel()));
            buf.append("<br>");
        }
        return this.buildSummary(new String[]{Application.getMessage(fc, MSG_USERROLES)}, new String[]{buf.toString()});
    }

    public boolean getHaveMaximumUsersBeenReturned() {
        return this.maxUsersReturned;
    }

    public String getMaximumUsersMsg() {
        FacesContext context = FacesContext.getCurrentInstance();
        String pattern = Application.getMessage(context, MSG_MAX_USERS);
        String msg = MessageFormat.format(pattern, Application.getClientConfig(context).getInviteUsersMaxResults());
        return Utils.encode((String)msg);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.userRolesDataModel = new ListDataModel();
        this.userRolesDataModel.setWrappedData(this.userGroupRoles);
    }

    public static class UserGroupRole
    implements Serializable {
        private static final long serialVersionUID = -3200146057437311225L;
        private String authority;
        private String role;
        private String label;

        public UserGroupRole(String authority, String role, String label) {
            this.authority = authority;
            this.role = role;
            this.label = label;
        }

        public String getAuthority() {
            return this.authority;
        }

        public String getRole() {
            return this.role;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

