/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wizard;

import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.wizard.IWizardBean;
import org.alfresco.web.ui.common.Utils;

public abstract class BaseWizardBean
extends BaseDialogBean
implements IWizardBean {
    private static final String MSG_NOT_SET = "value_not_set";

    public String next() {
        if (this.isFinished()) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_wizard_completed_already"));
        }
        return null;
    }

    public String back() {
        if (this.isFinished()) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_wizard_completed_already"));
        }
        return null;
    }

    public boolean getNextButtonDisabled() {
        return false;
    }

    public String getNextButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "next_button");
    }

    public String getBackButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "back_button");
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "finish_button");
    }

    public String getStepTitle() {
        return null;
    }

    public String getStepDescription() {
        return null;
    }

    protected String buildSummary(String[] labels, String[] values) {
        if (labels == null || values == null || labels.length != values.length) {
            throw new IllegalArgumentException("Labels and Values passed to summary must be valid and of equal length.");
        }
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), MSG_NOT_SET);
        String notSetMsg = "&lt;" + msg + "&gt;";
        StringBuilder buf = new StringBuilder(512);
        buf.append("<table cellspacing='4' cellpadding='2' border='0' class='summary'>");
        for (int i = 0; i < labels.length; ++i) {
            String value = values[i];
            buf.append("<tr><td valign='top'><b>");
            buf.append(labels[i]);
            buf.append(":</b></td><td>");
            buf.append(value != null ? value : notSetMsg);
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    protected String getDefaultCancelOutcome() {
        return "wizard:close";
    }

    protected String getDefaultFinishOutcome() {
        return "wizard:close";
    }
}

