/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.config.ClientConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class ClientElementReader
implements ConfigElementReader {
    public static final String ELEMENT_RECENTSPACESITEMS = "recent-spaces-items";
    public static final String ELEMENT_ERRORPAGE = "error-page";
    public static final String ELEMENT_LOGINPAGE = "login-page";
    public static final String ELEMENT_HELPURL = "help-url";
    public static final String ELEMENT_EDITLINKTYPE = "edit-link-type";
    public static final String ELEMENT_SEARCHMINIMUM = "search-minimum";
    public static final String ELEMENT_SEARCHANDTERMS = "search-and-terms";
    public static final String ELEMENT_SEARCHMAXRESULTS = "search-max-results";
    public static final String ELEMENT_SELECTORSSEARCHMAXRESULTS = "selectors-search-max-results";
    public static final String ELEMENT_INVITESEARCHMAXRESULTS = "invite-users-max-results";
    public static final String ELEMENT_HOMESPACEPERMISSION = "home-space-permission";
    public static final String ELEMENT_FROMEMAILADDRESS = "from-email-address";
    public static final String ELEMENT_SHELFVISIBLE = "shelf-visible";
    public static final String ELEMENT_NODESUMMARY_ENABLED = "node-summary-enabled";
    public static final String ELEMENT_INITIALLOCATION = "initial-location";
    public static final String ELEMENT_DEFAULTHOMESPACEPATH = "default-home-space-path";
    public static final String ELEMENT_CLIPBOARDSTATUS = "clipboard-status-visible";
    public static final String ELEMENT_PASTEALLANDCLEAR = "paste-all-and-clear";
    public static final String ELEMENT_GUESTCONFIG = "allow-guest-config";
    public static final String ELEMENT_SIMPLESEARCHADDITIONALATTRS = "simple-search-additional-attributes";
    public static final String ELEMENT_SIMPLESEARCHADDITIONALATTRSQNAME = "qname";
    public static final String ELEMENT_MINUSERNAMELENGTH = "username-min-length";
    public static final String ELEMENT_MINPASSWORDLENGTH = "password-min-length";
    public static final String ELEMENT_MINGROUPNAMELENGTH = "group-name-min-length";
    public static final String ELEMENT_BREADCRUMB_MODE = "breadcrumb-mode";
    public static final String ELEMENT_CIFSURLSUFFIX = "cifs-url-suffix";
    public static final String ELEMENT_LANGUAGESELECT = "language-select";
    public static final String ELEMENT_ZEROBYTEFILEUPLOADS = "zero-byte-file-uploads";
    public static final String ELEMENT_USERGROUPADMIN = "user-group-admin";
    public static final String ELEMENT_ALLOWUSERCONFIG = "allow-user-config";
    public static final String ELEMENT_PICKERSEARCHMINIMUM = "picker-search-minimum";
    public static final String ELEMENT_CHECKCONTEXTPATH = "check-context-against-path";
    public static final String ELEMENT_ALLOWUSERSCRIPTEXECUTE = "allow-user-script-execute";

    public ConfigElement parse(Element element) {
        ClientConfigElement configElement = null;
        if (element != null) {
            Element allowUserScriptExecute;
            Element checkContextAgainstPath;
            Element pickerSearchMin;
            Element userConfig;
            Element userGroupAdmin;
            Element zeroByteFiles;
            Element langSelect;
            Element cifsSuffix;
            Element breadcrumbMode;
            Element minGroupName;
            Element minPassword;
            Element minUsername;
            List attrbElements;
            Element simpleSearchAdditionalAttributesElement;
            Element guestConfigElement;
            Element pasteAllAndClear;
            Element clipboardStatusVisible;
            Element defaultHomeSpacePath;
            Element initialLocation;
            Element ajaxEnabled;
            Element loginPage;
            Element errorPage;
            Element fromEmail;
            Element permission;
            Element inviteUsersMaxResults;
            Element selectorsSearchMaxResults;
            Element searchMaxResults;
            Element searchForceAnd;
            Element searchMin;
            Element editLinkType;
            Element helpUrl;
            Element shelfVisible;
            String name = element.getName();
            if (!name.equals("client")) {
                throw new ConfigException("ClientElementReader can only parse client elements, the element passed was '" + name + "'");
            }
            configElement = new ClientConfigElement();
            Element recentSpaces = element.element(ELEMENT_RECENTSPACESITEMS);
            if (recentSpaces != null) {
                configElement.setRecentSpacesItems(Integer.parseInt(recentSpaces.getTextTrim()));
            }
            if ((shelfVisible = element.element(ELEMENT_SHELFVISIBLE)) != null) {
                configElement.setShelfVisible(Boolean.parseBoolean(shelfVisible.getTextTrim()));
            }
            if ((helpUrl = element.element(ELEMENT_HELPURL)) != null) {
                configElement.setHelpUrl(helpUrl.getTextTrim());
            }
            if ((editLinkType = element.element(ELEMENT_EDITLINKTYPE)) != null) {
                configElement.setEditLinkType(editLinkType.getTextTrim());
            }
            if ((searchMin = element.element(ELEMENT_SEARCHMINIMUM)) != null) {
                configElement.setSearchMinimum(Integer.parseInt(searchMin.getTextTrim()));
            }
            if ((searchForceAnd = element.element(ELEMENT_SEARCHANDTERMS)) != null) {
                configElement.setForceAndTerms(Boolean.parseBoolean(searchForceAnd.getTextTrim()));
            }
            if ((searchMaxResults = element.element(ELEMENT_SEARCHMAXRESULTS)) != null) {
                configElement.setSearchMaxResults(Integer.parseInt(searchMaxResults.getTextTrim()));
            }
            if ((selectorsSearchMaxResults = element.element(ELEMENT_SELECTORSSEARCHMAXRESULTS)) != null) {
                configElement.setSelectorsSearchMaxResults(Integer.parseInt(selectorsSearchMaxResults.getTextTrim()));
            }
            if ((inviteUsersMaxResults = element.element(ELEMENT_INVITESEARCHMAXRESULTS)) != null) {
                configElement.setInviteUsersMaxResults(Integer.parseInt(inviteUsersMaxResults.getTextTrim()));
            }
            if ((permission = element.element(ELEMENT_HOMESPACEPERMISSION)) != null) {
                configElement.setHomeSpacePermission(permission.getTextTrim());
            }
            if ((fromEmail = element.element(ELEMENT_FROMEMAILADDRESS)) != null) {
                configElement.setFromEmailAddress(fromEmail.getTextTrim());
            }
            if ((errorPage = element.element(ELEMENT_ERRORPAGE)) != null) {
                configElement.setErrorPage(errorPage.getTextTrim());
            }
            if ((loginPage = element.element(ELEMENT_LOGINPAGE)) != null) {
                configElement.setLoginPage(loginPage.getTextTrim());
            }
            if ((ajaxEnabled = element.element(ELEMENT_NODESUMMARY_ENABLED)) != null) {
                configElement.setNodeSummaryEnabled(Boolean.parseBoolean(ajaxEnabled.getTextTrim()));
            }
            if ((initialLocation = element.element(ELEMENT_INITIALLOCATION)) != null) {
                configElement.setInitialLocation(initialLocation.getTextTrim());
            }
            if ((defaultHomeSpacePath = element.element(ELEMENT_DEFAULTHOMESPACEPATH)) != null) {
                configElement.setDefaultHomeSpacePath(defaultHomeSpacePath.getTextTrim());
            }
            if ((clipboardStatusVisible = element.element(ELEMENT_CLIPBOARDSTATUS)) != null) {
                configElement.setClipboardStatusVisible(Boolean.parseBoolean(clipboardStatusVisible.getTextTrim()));
            }
            if ((pasteAllAndClear = element.element(ELEMENT_PASTEALLANDCLEAR)) != null) {
                configElement.setPasteAllAndClearEnabled(Boolean.parseBoolean(pasteAllAndClear.getTextTrim()));
            }
            if ((guestConfigElement = element.element(ELEMENT_GUESTCONFIG)) != null) {
                boolean allow = Boolean.parseBoolean(guestConfigElement.getTextTrim());
                configElement.setAllowGuestConfig(allow);
            }
            if ((simpleSearchAdditionalAttributesElement = element.element(ELEMENT_SIMPLESEARCHADDITIONALATTRS)) != null && (attrbElements = simpleSearchAdditionalAttributesElement.elements(ELEMENT_SIMPLESEARCHADDITIONALATTRSQNAME)) != null && attrbElements.size() != 0) {
                ArrayList<QName> simpleSearchAddtlAttrb = new ArrayList<QName>(4);
                for (Element elem : attrbElements) {
                    simpleSearchAddtlAttrb.add(QName.createQName((String)elem.getTextTrim()));
                }
                configElement.setSimpleSearchAdditionalAttributes(simpleSearchAddtlAttrb);
            }
            if ((minUsername = element.element(ELEMENT_MINUSERNAMELENGTH)) != null) {
                configElement.setMinUsernameLength(Integer.parseInt(minUsername.getTextTrim()));
            }
            if ((minPassword = element.element(ELEMENT_MINPASSWORDLENGTH)) != null) {
                configElement.setMinPasswordLength(Integer.parseInt(minPassword.getTextTrim()));
            }
            if ((minGroupName = element.element(ELEMENT_MINGROUPNAMELENGTH)) != null) {
                configElement.setMinGroupNameLength(Integer.parseInt(minGroupName.getTextTrim()));
            }
            if ((breadcrumbMode = element.element(ELEMENT_BREADCRUMB_MODE)) != null) {
                configElement.setBreadcrumbMode(breadcrumbMode.getTextTrim());
            }
            if ((cifsSuffix = element.element(ELEMENT_CIFSURLSUFFIX)) != null) {
                String suffix = cifsSuffix.getTextTrim();
                if (!suffix.startsWith(".")) {
                    suffix = "." + suffix;
                }
                configElement.setCifsURLSuffix(suffix);
            }
            if ((langSelect = element.element(ELEMENT_LANGUAGESELECT)) != null) {
                configElement.setLanguageSelect(Boolean.parseBoolean(langSelect.getTextTrim()));
            }
            if ((zeroByteFiles = element.element(ELEMENT_ZEROBYTEFILEUPLOADS)) != null) {
                configElement.setZeroByteFileUploads(Boolean.parseBoolean(zeroByteFiles.getTextTrim()));
            }
            if ((userGroupAdmin = element.element(ELEMENT_USERGROUPADMIN)) != null) {
                configElement.setUserGroupAdmin(Boolean.parseBoolean(userGroupAdmin.getTextTrim()));
            }
            if ((userConfig = element.element(ELEMENT_ALLOWUSERCONFIG)) != null) {
                configElement.setAllowUserConfig(Boolean.parseBoolean(userConfig.getTextTrim()));
            }
            if ((pickerSearchMin = element.element(ELEMENT_PICKERSEARCHMINIMUM)) != null) {
                configElement.setPickerSearchMinimum(Integer.parseInt(pickerSearchMin.getTextTrim()));
            }
            if ((checkContextAgainstPath = element.element(ELEMENT_CHECKCONTEXTPATH)) != null) {
                configElement.setCheckContextAgainstPath(Boolean.parseBoolean(checkContextAgainstPath.getTextTrim()));
            }
            if ((allowUserScriptExecute = element.element(ELEMENT_ALLOWUSERSCRIPTEXECUTE)) != null) {
                configElement.setAllowUserScriptExecute(Boolean.parseBoolean(allowUserScriptExecute.getTextTrim()));
            }
        }
        return configElement;
    }
}

