/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.DashboardsConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class DashboardsElementReader
implements ConfigElementReader {
    public static final String ELEMENT_DASHBOARDS = "dashboards";
    public static final String ELEMENT_LAYOUTS = "layouts";
    public static final String ELEMENT_LAYOUT = "layout";
    public static final String ELEMENT_DASHLETS = "dashlets";
    public static final String ELEMENT_DASHLET = "dashlet";
    public static final String ELEMENT_GUESTCONFIG = "allow-guest-config";
    public static final String ELEMENT_DEFAULTDASHLETS = "default-dashlets";
    public static final String ATTR_ID = "id";
    public static final String ATTR_COLUMNS = "columns";
    public static final String ATTR_COLUMNLENGTH = "column-length";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_LABELID = "label-id";
    public static final String ATTR_DESCRIPTIONID = "description-id";
    public static final String ATTR_JSP = "jsp";
    public static final String ATTR_CONFIGJSP = "config-jsp";
    public static final String ATTR_ALLOWNARROW = "allow-narrow";

    public ConfigElement parse(Element element) {
        DashboardsConfigElement configElement = new DashboardsConfigElement();
        if (element != null) {
            Element guestConfigElement;
            Element defaultDashletsElement;
            Element dashletsElement;
            if (!ELEMENT_DASHBOARDS.equals(element.getName())) {
                throw new ConfigException("DashboardsElementReader can only process elements of type 'dashboards'");
            }
            Element layoutsElement = element.element(ELEMENT_LAYOUTS);
            if (layoutsElement != null) {
                Iterator layoutsItr = layoutsElement.elementIterator(ELEMENT_LAYOUT);
                while (layoutsItr.hasNext()) {
                    DashboardsConfigElement.LayoutDefinition layoutDef = DashboardsElementReader.parseLayoutDefinition((Element)layoutsItr.next());
                    configElement.addLayoutDefinition(layoutDef);
                }
            }
            if ((dashletsElement = element.element(ELEMENT_DASHLETS)) != null) {
                Iterator dashletsItr = dashletsElement.elementIterator(ELEMENT_DASHLET);
                while (dashletsItr.hasNext()) {
                    DashboardsConfigElement.DashletDefinition dashletDef = DashboardsElementReader.parseDashletDefinition((Element)dashletsItr.next());
                    configElement.addDashletDefinition(dashletDef);
                }
            }
            if ((defaultDashletsElement = element.element(ELEMENT_DEFAULTDASHLETS)) != null) {
                Iterator dashletsItr = defaultDashletsElement.elementIterator(ELEMENT_DASHLET);
                while (dashletsItr.hasNext()) {
                    String id = DashboardsElementReader.getMandatoryDashletAttributeValue((Element)dashletsItr.next(), ATTR_ID);
                    configElement.addDefaultDashlet(id);
                }
            }
            if ((guestConfigElement = element.element(ELEMENT_GUESTCONFIG)) != null) {
                boolean allow = Boolean.parseBoolean(guestConfigElement.getTextTrim());
                configElement.setAllowGuestConfig(allow);
            }
        }
        return configElement;
    }

    private static DashboardsConfigElement.LayoutDefinition parseLayoutDefinition(Element config) {
        String id = DashboardsElementReader.getMandatoryLayoutAttributeValue(config, ATTR_ID);
        DashboardsConfigElement.LayoutDefinition def = new DashboardsConfigElement.LayoutDefinition(id);
        String columns = DashboardsElementReader.getMandatoryLayoutAttributeValue(config, ATTR_COLUMNS);
        def.Columns = Integer.parseInt(columns);
        String columnLength = DashboardsElementReader.getMandatoryLayoutAttributeValue(config, ATTR_COLUMNLENGTH);
        def.ColumnLength = Integer.parseInt(columnLength);
        def.Image = DashboardsElementReader.getMandatoryLayoutAttributeValue(config, ATTR_IMAGE);
        def.JSPPage = DashboardsElementReader.getMandatoryLayoutAttributeValue(config, ATTR_JSP);
        String label = config.attributeValue(ATTR_LABEL);
        String labelId = config.attributeValue(ATTR_LABELID);
        if (!(label != null && label.length() != 0 || labelId != null && labelId.length() != 0)) {
            throw new ConfigException("Either 'label' or 'label-id' attribute must be specified for Dashboard 'layout' configuration element.");
        }
        def.Label = label;
        def.LabelId = labelId;
        String description = config.attributeValue(ATTR_DESCRIPTION);
        String descriptionId = config.attributeValue(ATTR_DESCRIPTIONID);
        if (!(description != null && description.length() != 0 || descriptionId != null && descriptionId.length() != 0)) {
            throw new ConfigException("Either 'description' or 'description-id' attribute must be specified for Dashboard 'layout' configuration element.");
        }
        def.Description = description;
        def.DescriptionId = descriptionId;
        return def;
    }

    private static String getMandatoryLayoutAttributeValue(Element config, String attr) {
        String value = config.attributeValue(attr);
        if (value == null || value.length() == 0) {
            throw new ConfigException("Missing mandatory '" + attr + "' attribute for Dashboard 'layout' configuration element.");
        }
        return value;
    }

    private static DashboardsConfigElement.DashletDefinition parseDashletDefinition(Element config) {
        String id = DashboardsElementReader.getMandatoryDashletAttributeValue(config, ATTR_ID);
        DashboardsConfigElement.DashletDefinition def = new DashboardsConfigElement.DashletDefinition(id);
        String allowNarrow = config.attributeValue(ATTR_ALLOWNARROW);
        if (allowNarrow != null && allowNarrow.length() != 0) {
            def.AllowNarrow = Boolean.parseBoolean(allowNarrow);
        }
        def.JSPPage = DashboardsElementReader.getMandatoryDashletAttributeValue(config, ATTR_JSP);
        def.ConfigJSPPage = config.attributeValue(ATTR_CONFIGJSP);
        String label = config.attributeValue(ATTR_LABEL);
        String labelId = config.attributeValue(ATTR_LABELID);
        if (!(label != null && label.length() != 0 || labelId != null && labelId.length() != 0)) {
            throw new ConfigException("Either 'label' or 'label-id' attribute must be specified for Dashboard 'dashlet' configuration element.");
        }
        def.Label = label;
        def.LabelId = labelId;
        String description = config.attributeValue(ATTR_DESCRIPTION);
        String descriptionId = config.attributeValue(ATTR_DESCRIPTIONID);
        if (!(description != null && description.length() != 0 || descriptionId != null && descriptionId.length() != 0)) {
            throw new ConfigException("Either 'description' or 'description-id' attribute must be specified for Dashboard 'dashlet' configuration element.");
        }
        def.Description = description;
        def.DescriptionId = descriptionId;
        return def;
    }

    private static String getMandatoryDashletAttributeValue(Element config, String attr) {
        String value = config.attributeValue(attr);
        if (value == null || value.length() == 0) {
            throw new ConfigException("Missing mandatory '" + attr + "' attribute for Dashboard 'dashlet' configuration element.");
        }
        return value;
    }
}

