/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.PropertySheetConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class PropertySheetElementReader
implements ConfigElementReader {
    public static final String ELEMENT_PROPERTY_SHEET = "property-sheet";
    public static final String ELEMENT_SHOW_PROPERTY = "show-property";
    public static final String ELEMENT_SHOW_ASSOC = "show-association";
    public static final String ELEMENT_SHOW_CHILD_ASSOC = "show-child-association";
    public static final String ELEMENT_SEPARATOR = "separator";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DISPLAY_LABEL = "display-label";
    public static final String ATTR_DISPLAY_LABEL_ID = "display-label-id";
    public static final String ATTR_READ_ONLY = "read-only";
    public static final String ATTR_CONVERTER = "converter";
    public static final String ATTR_SHOW_IN_EDIT_MODE = "show-in-edit-mode";
    public static final String ATTR_SHOW_IN_VIEW_MODE = "show-in-view-mode";
    public static final String ATTR_COMPONENT_GENERATOR = "component-generator";
    public static final String ATTR_IGNORE_IF_MISSING = "ignore-if-missing";

    public ConfigElement parse(Element element) {
        PropertySheetConfigElement configElement = null;
        if (element != null) {
            String name = element.getName();
            if (!name.equals(ELEMENT_PROPERTY_SHEET)) {
                throw new ConfigException("PropertySheetElementReader can only parse property-sheetelements, the element passed was '" + name + "'");
            }
            configElement = new PropertySheetConfigElement();
            Iterator items = element.elementIterator();
            while (items.hasNext()) {
                Element item = (Element)items.next();
                String propName = item.attributeValue(ATTR_NAME);
                String label = item.attributeValue(ATTR_DISPLAY_LABEL);
                String labelId = item.attributeValue(ATTR_DISPLAY_LABEL_ID);
                String readOnly = item.attributeValue(ATTR_READ_ONLY);
                String converter = item.attributeValue(ATTR_CONVERTER);
                String inEdit = item.attributeValue(ATTR_SHOW_IN_EDIT_MODE);
                String inView = item.attributeValue(ATTR_SHOW_IN_VIEW_MODE);
                String compGenerator = item.attributeValue(ATTR_COMPONENT_GENERATOR);
                if (ELEMENT_SHOW_PROPERTY.equals(item.getName())) {
                    String ignoreIfMissing = item.attributeValue(ATTR_IGNORE_IF_MISSING);
                    configElement.addProperty(propName, label, labelId, readOnly, converter, inView, inEdit, compGenerator, ignoreIfMissing);
                    continue;
                }
                if (ELEMENT_SHOW_ASSOC.equals(item.getName())) {
                    configElement.addAssociation(propName, label, labelId, readOnly, converter, inView, inEdit, compGenerator);
                    continue;
                }
                if (ELEMENT_SHOW_CHILD_ASSOC.equals(item.getName())) {
                    configElement.addChildAssociation(propName, label, labelId, readOnly, converter, inView, inEdit, compGenerator);
                    continue;
                }
                if (!ELEMENT_SEPARATOR.equals(item.getName())) continue;
                configElement.addSeparator(propName, label, labelId, inView, inEdit, compGenerator);
            }
        }
        return configElement;
    }
}

