/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.SidebarConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class SidebarElementReader
implements ConfigElementReader {
    public static final String ELEMENT_SIDEBAR = "sidebar";
    public static final String ELEMENT_PLUGINS = "plugins";
    public static final String ELEMENT_PLUGIN = "plugin";
    public static final String ELEMENT_DEFAULT_PLUGIN = "default-plugin";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LABEL_ID = "label-id";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_DESCRIPTION_ID = "description-id";
    public static final String ATTR_PAGE = "page";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_ACTIONS_CONFIG_ID = "actions-config-id";

    public ConfigElement parse(Element element) {
        SidebarConfigElement configElement = null;
        if (element != null) {
            Element defaultPlugin;
            String elementName = element.getName();
            if (!elementName.equals(ELEMENT_SIDEBAR)) {
                throw new ConfigException("SidebarElementReader can only parse sidebarelements, the element passed was '" + elementName + "'");
            }
            configElement = new SidebarConfigElement();
            Element pluginsElem = element.element(ELEMENT_PLUGINS);
            if (pluginsElem != null) {
                Iterator plugins = pluginsElem.elementIterator(ELEMENT_PLUGIN);
                while (plugins.hasNext()) {
                    Element plugin = (Element)plugins.next();
                    String id = plugin.attributeValue(ATTR_ID);
                    String page = plugin.attributeValue(ATTR_PAGE);
                    String label = plugin.attributeValue(ATTR_LABEL);
                    String labelId = plugin.attributeValue(ATTR_LABEL_ID);
                    String description = plugin.attributeValue(ATTR_DESCRIPTION);
                    String descriptionId = plugin.attributeValue(ATTR_DESCRIPTION_ID);
                    String actionsConfigId = plugin.attributeValue(ATTR_ACTIONS_CONFIG_ID);
                    String icon = plugin.attributeValue(ATTR_ICON);
                    SidebarConfigElement.SidebarPluginConfig cfg = new SidebarConfigElement.SidebarPluginConfig(id, page, label, labelId, description, descriptionId, actionsConfigId, icon);
                    configElement.addPlugin(cfg);
                }
            }
            if ((defaultPlugin = element.element(ELEMENT_DEFAULT_PLUGIN)) != null) {
                configElement.setDefaultPlugin(defaultPlugin.getTextTrim());
            }
        }
        return configElement;
    }
}

