/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewsConfigElement
extends ConfigElementAdapter
implements Serializable {
    private static final long serialVersionUID = -503735723795178986L;
    public static final String CONFIG_ELEMENT_ID = "views";
    public static final String VIEW_DETAILS = "details";
    public static final String VIEW_ICONS = "icons";
    public static final String VIEW_LIST = "list";
    public static final String VIEW_BUBBLE = "bubble";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_DESCENDING = "descending";
    private static final String SEPARATOR = ":";
    private int defaultPageSize = 10;
    private String defaultView = "details";
    private String defaultSortColumn = "name";
    private List<String> views = new ArrayList<String>(4);
    private Map<String, String> defaultViews = new HashMap<String, String>(4);
    private Map<String, Integer> pageSizes = new HashMap<String, Integer>(10);
    private Map<String, String> sortColumns = new HashMap<String, String>(4);
    private Map<String, String> sortDirections = new HashMap<String, String>(1);

    public ViewsConfigElement() {
        super(CONFIG_ELEMENT_ID);
        this.pageSizes.put(VIEW_DETAILS, this.defaultPageSize);
        this.pageSizes.put(VIEW_LIST, this.defaultPageSize);
        this.pageSizes.put(VIEW_ICONS, 9);
        this.pageSizes.put(VIEW_BUBBLE, 5);
    }

    public ViewsConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the views config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        ViewsConfigElement newElement = (ViewsConfigElement)configElement;
        ViewsConfigElement combinedElement = new ViewsConfigElement();
        for (String viewImpl : this.views) {
            combinedElement.addView(viewImpl);
        }
        for (String page : this.defaultViews.keySet()) {
            combinedElement.addDefaultView(page, this.defaultViews.get(page));
        }
        for (String pageView : this.pageSizes.keySet()) {
            if (pageView.indexOf(SEPARATOR) == -1) continue;
            String page = pageView.substring(0, pageView.indexOf(SEPARATOR));
            String view = pageView.substring(pageView.indexOf(SEPARATOR) + 1);
            combinedElement.addDefaultPageSize(page, view, this.pageSizes.get(pageView));
        }
        for (String page : this.sortColumns.keySet()) {
            combinedElement.addDefaultSortColumn(page, this.sortColumns.get(page));
        }
        for (String page : this.sortDirections.keySet()) {
            combinedElement.addSortDirection(page, this.sortDirections.get(page));
        }
        for (String viewImpl : newElement.getViews()) {
            combinedElement.addView(viewImpl);
        }
        Map<String, String> newDefaultViews = newElement.getDefaultViews();
        for (String page : newDefaultViews.keySet()) {
            combinedElement.addDefaultView(page, newDefaultViews.get(page));
        }
        Map<String, Integer> newPageSizes = newElement.getDefaultPageSizes();
        for (String pageView : newPageSizes.keySet()) {
            if (pageView.indexOf(SEPARATOR) == -1) continue;
            String page = pageView.substring(0, pageView.indexOf(SEPARATOR));
            String view = pageView.substring(pageView.indexOf(SEPARATOR) + 1);
            combinedElement.addDefaultPageSize(page, view, newPageSizes.get(pageView));
        }
        Map<String, String> newSortColumns = newElement.getDefaultSortColumns();
        for (String page : newSortColumns.keySet()) {
            combinedElement.addDefaultSortColumn(page, newSortColumns.get(page));
        }
        Map<String, String> existingSortDirs = newElement.getSortDirections();
        for (String page : existingSortDirs.keySet()) {
            combinedElement.addSortDirection(page, existingSortDirs.get(page));
        }
        return combinedElement;
    }

    void addView(String renderer) {
        this.views.add(renderer);
    }

    public List<String> getViews() {
        return this.views;
    }

    void addDefaultView(String page, String view) {
        this.defaultViews.put(page, view);
    }

    public String getDefaultView(String page) {
        String view = this.defaultViews.get(page);
        if (view == null) {
            view = this.defaultView;
        }
        return view;
    }

    Map<String, String> getDefaultViews() {
        return this.defaultViews;
    }

    void addDefaultPageSize(String page, String view, int size) {
        this.pageSizes.put(page + SEPARATOR + view, new Integer(size));
    }

    public int getDefaultPageSize(String page, String view) {
        Integer pageSize = this.pageSizes.get(page + SEPARATOR + view);
        if (pageSize == null && (pageSize = this.pageSizes.get(view)) == null) {
            pageSize = new Integer(10);
        }
        return pageSize;
    }

    Map<String, Integer> getDefaultPageSizes() {
        return this.pageSizes;
    }

    void addDefaultSortColumn(String page, String column) {
        this.sortColumns.put(page, column);
    }

    public String getDefaultSortColumn(String page) {
        String column = this.sortColumns.get(page);
        if (column == null) {
            column = this.defaultSortColumn;
        }
        return column;
    }

    Map<String, String> getDefaultSortColumns() {
        return this.sortColumns;
    }

    void addSortDirection(String page, String dir) {
        this.sortDirections.put(page, dir);
    }

    public boolean hasDescendingSort(String page) {
        boolean usesDescendingSort = false;
        String sortDir = this.sortDirections.get(page);
        if (sortDir != null && sortDir.equalsIgnoreCase(SORT_DESCENDING)) {
            usesDescendingSort = true;
        }
        return usesDescendingSort;
    }

    Map<String, String> getSortDirections() {
        return this.sortDirections;
    }
}

