/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseTest;
import org.alfresco.web.config.ActionsConfigElement;
import org.alfresco.web.config.AdvancedSearchConfigElement;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.config.LanguagesConfigElement;
import org.alfresco.web.config.NavigationConfigElement;
import org.alfresco.web.config.NavigationResult;
import org.alfresco.web.config.PropertySheetConfigElement;
import org.alfresco.web.config.ViewsConfigElement;
import org.alfresco.web.config.WizardsConfigElement;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.XMLConfigService;

public class WebClientConfigTest
extends BaseTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testPropertySheetConfig() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config global = svc.getGlobalConfig();
        ConfigElement globalPropSheet = global.getConfigElement("property-sheet");
        WebClientConfigTest.assertNotNull((String)"global property sheet element should not be null", (Object)globalPropSheet);
        WebClientConfigTest.assertTrue((String)"config element should be an instance of PropertySheetConfigElement", (boolean)(globalPropSheet instanceof PropertySheetConfigElement));
        List<String> propNames = ((PropertySheetConfigElement)globalPropSheet).getItemNamesToShow();
        WebClientConfigTest.assertTrue((String)"There should only be one property in the list", (propNames.size() == 1 ? 1 : 0) != 0);
        WebClientConfigTest.assertTrue((String)"The property name should be 'name'", (boolean)propNames.get(0).equals("name"));
        Config spaceAspectConfig = svc.getConfig((Object)"space-aspect");
        WebClientConfigTest.assertNotNull((String)"Space aspect config should not be null", (Object)spaceAspectConfig);
        PropertySheetConfigElement spacePropConfig = (PropertySheetConfigElement)spaceAspectConfig.getConfigElement("property-sheet");
        WebClientConfigTest.assertNotNull((String)"Space aspect property config should not be null", (Object)((Object)spacePropConfig));
        propNames = spacePropConfig.getItemNamesToShow();
        WebClientConfigTest.assertTrue((String)"There should be 6 properties in the list", (propNames.size() == 6 ? 1 : 0) != 0);
        Map<String, PropertySheetConfigElement.ItemConfig> props = spacePropConfig.getItemsToShow();
        PropertySheetConfigElement.ItemConfig descProp = props.get("description");
        WebClientConfigTest.assertNotNull((String)"description property config should not be null", (Object)descProp);
        WebClientConfigTest.assertEquals((String)"display label for description should be 'Description'", (String)descProp.getDisplayLabel(), (String)"Description");
        WebClientConfigTest.assertFalse((String)"read only for description should be 'false'", (boolean)descProp.isReadOnly());
        PropertySheetConfigElement.ItemConfig createdDataProp = props.get("createddate");
        WebClientConfigTest.assertNotNull((String)"createddate property config should not be null", (Object)createdDataProp);
        WebClientConfigTest.assertEquals((String)"display label for createddate should be null", null, (String)createdDataProp.getDisplayLabel());
        WebClientConfigTest.assertTrue((String)"read only for createddate should be 'true'", (boolean)createdDataProp.isReadOnly());
        WebClientConfigTest.assertTrue((String)"ignoreIfMissing for createddate should be 'true'", (boolean)createdDataProp.getIgnoreIfMissing());
        PropertySheetConfigElement.ItemConfig iconProp = props.get("icon");
        WebClientConfigTest.assertNotNull((String)"icon property config should not be null", (Object)iconProp);
        WebClientConfigTest.assertEquals((String)"display label for icon should be null", null, (String)iconProp.getDisplayLabel());
        WebClientConfigTest.assertEquals((String)"component-generator", (String)"SpaceIconPickerGenerator", (String)iconProp.getComponentGenerator());
        WebClientConfigTest.assertFalse((String)"read only for icon should be 'false'", (boolean)iconProp.isReadOnly());
        WebClientConfigTest.assertFalse((String)"ignoreIfMissing for icon should be 'false'", (boolean)iconProp.getIgnoreIfMissing());
        try {
            spacePropConfig.getChildren();
            WebClientConfigTest.fail((String)"getChildren() did not throw an excpetion");
        }
        catch (ConfigException ce) {
            // empty catch block
        }
    }

    public void testPropertyViewing() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config propViewConfig = svc.getConfig((Object)"Property Viewing");
        WebClientConfigTest.assertNotNull((String)"Property Viewing section should not be null", (Object)propViewConfig);
        PropertySheetConfigElement propSheet = (PropertySheetConfigElement)propViewConfig.getConfigElement("property-sheet");
        WebClientConfigTest.assertNotNull((String)"property-sheet config should not be null", (Object)((Object)propSheet));
        Map<String, PropertySheetConfigElement.ItemConfig> allItems = propSheet.getItems();
        WebClientConfigTest.assertNotNull((String)"allItems should not be null", allItems);
        WebClientConfigTest.assertEquals((String)"Total number of properties", (int)5, (int)allItems.size());
        WebClientConfigTest.assertNotNull((String)"name property is missing", (Object)allItems.get("name"));
        WebClientConfigTest.assertNotNull((String)"description property is missing", (Object)allItems.get("description"));
        WebClientConfigTest.assertNotNull((String)"icon property is missing", (Object)allItems.get("icon"));
        WebClientConfigTest.assertNotNull((String)"size property is missing", (Object)allItems.get("size"));
        WebClientConfigTest.assertNotNull((String)"uuid property is missing", (Object)allItems.get("uuid"));
        List<String> itemsToShow = propSheet.getItemNamesToShow();
        WebClientConfigTest.assertNotNull((String)"itemsToShow should not be null", itemsToShow);
        WebClientConfigTest.assertEquals((String)"Number of viewable properties", (int)3, (int)itemsToShow.size());
        WebClientConfigTest.assertEquals((String)"first viewable property name", (String)"name", (String)itemsToShow.get(0));
        WebClientConfigTest.assertEquals((String)"second viewable property name", (String)"description", (String)itemsToShow.get(1));
        WebClientConfigTest.assertEquals((String)"third viewable property name", (String)"size", (String)itemsToShow.get(2));
        List<String> editItems = propSheet.getEditableItemNamesToShow();
        WebClientConfigTest.assertNotNull((String)"editItems should not be null", editItems);
        WebClientConfigTest.assertEquals((String)"Number of editable properties", (int)3, (int)editItems.size());
        WebClientConfigTest.assertEquals((String)"first viewable property name", (String)"name", (String)editItems.get(0));
        WebClientConfigTest.assertEquals((String)"second viewable property name", (String)"description", (String)editItems.get(1));
        WebClientConfigTest.assertEquals((String)"third viewable property name", (String)"icon", (String)editItems.get(2));
    }

    public void testPropertyEditing() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config propEditConfig = svc.getConfig((Object)"Property Editing");
        WebClientConfigTest.assertNotNull((String)"Property Editing section should not be null", (Object)propEditConfig);
        PropertySheetConfigElement propSheet = (PropertySheetConfigElement)propEditConfig.getConfigElement("property-sheet");
        WebClientConfigTest.assertNotNull((String)"property-sheet config should not be null", (Object)((Object)propSheet));
        List<String> itemNamesToEdit = propSheet.getEditableItemNamesToShow();
        WebClientConfigTest.assertNotNull((String)"itemNamesToEdit should not be null", itemNamesToEdit);
        WebClientConfigTest.assertEquals((String)"Number of properties", (int)3, (int)itemNamesToEdit.size());
        WebClientConfigTest.assertEquals((String)"first property name", (String)"name", (String)itemNamesToEdit.get(0));
        WebClientConfigTest.assertEquals((String)"second property name", (String)"description", (String)itemNamesToEdit.get(1));
        WebClientConfigTest.assertEquals((String)"third property name", (String)"icon", (String)itemNamesToEdit.get(2));
        Map<String, PropertySheetConfigElement.ItemConfig> itemsToEditMap = propSheet.getEditableItemsToShow();
        WebClientConfigTest.assertNotNull((String)"itemsToEditMap should not be null", itemsToEditMap);
        WebClientConfigTest.assertEquals((String)"Number of properties", (int)3, (int)itemsToEditMap.size());
        PropertySheetConfigElement.ItemConfig item = itemsToEditMap.get("icon");
        WebClientConfigTest.assertNotNull((String)"icon should not be null", (Object)item);
        WebClientConfigTest.assertTrue((String)"icon property readOnly status should be true", (boolean)item.isReadOnly());
        item = itemsToEditMap.get("size");
        WebClientConfigTest.assertNull((String)"size should be null", (Object)item);
        Collection<PropertySheetConfigElement.ItemConfig> itemsToEdit = propSheet.getEditableItemsToShow().values();
        WebClientConfigTest.assertNotNull((String)"itemsToEdit should not be null", itemsToEdit);
        WebClientConfigTest.assertEquals((String)"Number of properties", (int)3, (int)itemsToEdit.size());
    }

    public void testPropertyOverride() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        PropertySheetConfigElement propSheet = (PropertySheetConfigElement)svc.getConfig((Object)"space-aspect").getConfigElement("property-sheet");
        WebClientConfigTest.assertNotNull((String)"propSheet should not be null", (Object)((Object)propSheet));
        WebClientConfigTest.assertEquals((String)"prop names to show size", (int)6, (int)propSheet.getItemNamesToShow().size());
        WebClientConfigTest.assertEquals((String)"props to show size", (int)6, (int)propSheet.getItemsToShow().size());
        WebClientConfigTest.assertEquals((String)"edit prop names to show size", (int)5, (int)propSheet.getEditableItemNamesToShow().size());
        WebClientConfigTest.assertEquals((String)"edit props to show size", (int)5, (int)propSheet.getEditableItemsToShow().size());
        PropertySheetConfigElement.PropertyConfig propConfig = (PropertySheetConfigElement.PropertyConfig)propSheet.getItemsToShow().get("size");
        WebClientConfigTest.assertNotNull((String)"propConfig should not be null", (Object)propConfig);
        WebClientConfigTest.assertTrue((String)"size should be shown in edit mode", (boolean)propConfig.isShownInEditMode());
        WebClientConfigTest.assertTrue((String)"size property should be read only", (boolean)propConfig.isReadOnly());
        WebClientConfigTest.assertNotNull((String)"size property should be in edit map", (Object)propSheet.getEditableItemsToShow().get("size"));
        propConfig = (PropertySheetConfigElement.PropertyConfig)propSheet.getItemsToShow().get("icon");
        WebClientConfigTest.assertNotNull((String)"propConfig should not be null", (Object)propConfig);
        propSheet = (PropertySheetConfigElement)svc.getConfig((Object)"Property Viewing").getConfigElement("property-sheet");
        WebClientConfigTest.assertNotNull((String)"property-sheet config should not be null", (Object)((Object)propSheet));
        Map<String, PropertySheetConfigElement.ItemConfig> allItems = propSheet.getItems();
        WebClientConfigTest.assertNotNull((String)"allItems should not be null", allItems);
        WebClientConfigTest.assertEquals((String)"Total number of properties", (int)5, (int)allItems.size());
        WebClientConfigTest.assertNotNull((String)"name property is missing", (Object)allItems.get("name"));
        WebClientConfigTest.assertNotNull((String)"description property is missing", (Object)allItems.get("description"));
        WebClientConfigTest.assertNotNull((String)"icon property is missing", (Object)allItems.get("icon"));
        WebClientConfigTest.assertNotNull((String)"size property is missing", (Object)allItems.get("size"));
        WebClientConfigTest.assertNotNull((String)"uuid property is missing", (Object)allItems.get("uuid"));
        List<String> itemsToShow = propSheet.getItemNamesToShow();
        WebClientConfigTest.assertNotNull((String)"itemsToShow should not be null", itemsToShow);
        WebClientConfigTest.assertEquals((String)"Number of viewable properties", (int)4, (int)itemsToShow.size());
        WebClientConfigTest.assertEquals((String)"first viewable property name", (String)"name", (String)itemsToShow.get(0));
        WebClientConfigTest.assertEquals((String)"second viewable property name", (String)"size", (String)itemsToShow.get(1));
        WebClientConfigTest.assertEquals((String)"third viewable property name", (String)"icon", (String)itemsToShow.get(2));
        WebClientConfigTest.assertEquals((String)"third viewable property name", (String)"uuid", (String)itemsToShow.get(3));
        List<String> editItems = propSheet.getEditableItemNamesToShow();
        WebClientConfigTest.assertNotNull((String)"editItems should not be null", editItems);
        WebClientConfigTest.assertEquals((String)"Number of editable properties", (int)3, (int)editItems.size());
        WebClientConfigTest.assertEquals((String)"first viewable property name", (String)"name", (String)editItems.get(0));
        WebClientConfigTest.assertEquals((String)"second viewable property name", (String)"icon", (String)editItems.get(1));
        WebClientConfigTest.assertEquals((String)"third viewable property name", (String)"uuid", (String)editItems.get(2));
        PropertySheetConfigElement.ItemConfig iconCfg = propSheet.getItemsToShow().get("icon");
        WebClientConfigTest.assertNotNull((String)"iconCfg not should not be null", (Object)iconCfg);
        WebClientConfigTest.assertFalse((String)"icon should not be read-only", (boolean)iconCfg.isReadOnly());
        WebClientConfigTest.assertTrue((String)"icon should be shown in view mode", (boolean)iconCfg.isShownInViewMode());
        WebClientConfigTest.assertTrue((String)"icon should be shown in edit mode", (boolean)iconCfg.isShownInEditMode());
        WebClientConfigTest.assertFalse((String)"ignoreIfMissing for icon should be 'false'", (boolean)iconCfg.getIgnoreIfMissing());
    }

    public void testClientConfig() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        ClientConfigElement clientConfig = (ClientConfigElement)svc.getGlobalConfig().getConfigElement("client");
        WebClientConfigTest.assertNotNull((String)"client config", (Object)((Object)clientConfig));
        WebClientConfigTest.assertEquals((String)"error page", (String)"/jsp/error.jsp", (String)clientConfig.getErrorPage());
        WebClientConfigTest.assertEquals((String)"login page", (String)"/jsp/login.jsp", (String)clientConfig.getLoginPage());
        WebClientConfigTest.assertEquals((String)"home space permission", (String)"Consumer", (String)clientConfig.getHomeSpacePermission());
        WebClientConfigTest.assertEquals((String)"help url", (String)"http://www.alfresco.org/help/webclient", (String)clientConfig.getHelpUrl());
        WebClientConfigTest.assertEquals((String)"edit link type", (String)"http", (String)clientConfig.getEditLinkType());
        WebClientConfigTest.assertEquals((String)"from address", (String)"alfresco@alfresco.org", (String)clientConfig.getFromEmailAddress());
        WebClientConfigTest.assertEquals((String)"recent spaces", (int)6, (int)clientConfig.getRecentSpacesItems());
        WebClientConfigTest.assertEquals((String)"search minimum", (int)3, (int)clientConfig.getSearchMinimum());
        WebClientConfigTest.assertTrue((String)"shelf visible", (boolean)clientConfig.isShelfVisible());
    }

    public void testClientOverride() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        Config globalSection = svc.getGlobalConfig();
        WebClientConfigTest.assertNotNull((String)"global section", (Object)globalSection);
        ClientConfigElement clientConfig = (ClientConfigElement)globalSection.getConfigElement("client");
        WebClientConfigTest.assertNotNull((String)"client config", (Object)((Object)clientConfig));
        WebClientConfigTest.assertEquals((String)"error page", (String)"/jsp/error.jsp", (String)clientConfig.getErrorPage());
        WebClientConfigTest.assertEquals((String)"login page", (String)"/jsp/login-override.jsp", (String)clientConfig.getLoginPage());
        WebClientConfigTest.assertEquals((String)"home space permission", (String)"Editor", (String)clientConfig.getHomeSpacePermission());
        WebClientConfigTest.assertEquals((String)"help url", (String)"http://www.somewhere.com/help", (String)clientConfig.getHelpUrl());
        WebClientConfigTest.assertEquals((String)"edit link type", (String)"webdav", (String)clientConfig.getEditLinkType());
        WebClientConfigTest.assertEquals((String)"from address", (String)"me@somewhere.com", (String)clientConfig.getFromEmailAddress());
        WebClientConfigTest.assertEquals((String)"recent spaces", (int)1, (int)clientConfig.getRecentSpacesItems());
        WebClientConfigTest.assertEquals((String)"search minimum", (int)10, (int)clientConfig.getSearchMinimum());
        WebClientConfigTest.assertFalse((String)"shelf visible", (boolean)clientConfig.isShelfVisible());
        List<QName> attrs = clientConfig.getSimpleSearchAdditionalAttributes();
        WebClientConfigTest.assertNotNull((String)"Expecting a list of search attributes", attrs);
        WebClientConfigTest.assertEquals((String)"Expecting 4 search attributes", (int)4, (int)attrs.size());
    }

    public void testNavigation() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config testCfg = svc.getConfig((Object)"viewid-navigation-result");
        WebClientConfigTest.assertNotNull((String)"viewid-navigation-result config should not be null", (Object)testCfg);
        NavigationConfigElement navCfg = (NavigationConfigElement)testCfg.getConfigElement("navigation");
        WebClientConfigTest.assertNotNull((String)"navigation config should not be null", (Object)((Object)navCfg));
        NavigationResult navResult = navCfg.getOverride("/jsp/browse/browse.jsp", null);
        WebClientConfigTest.assertEquals((String)"result should be '/jsp/forums/forums.jsp'", (String)"/jsp/forums/forums.jsp", (String)navResult.getResult());
        WebClientConfigTest.assertFalse((String)"isOutcome test should be false", (boolean)navResult.isOutcome());
        navResult = navCfg.getOverride(null, "browse");
        WebClientConfigTest.assertEquals((String)"result should be '/jsp/forums/topics.jsp'", (String)"/jsp/forums/topics.jsp", (String)navResult.getResult());
        WebClientConfigTest.assertFalse((String)"isOutcome test should be false", (boolean)navResult.isOutcome());
        navResult = navCfg.getOverride("/jsp/browse/browse.jsp", "browse");
        WebClientConfigTest.assertEquals((String)"result should be '/jsp/forums/topics.jsp'", (String)"/jsp/forums/topics.jsp", (String)navResult.getResult());
        WebClientConfigTest.assertFalse((String)"isOutcome test should be false", (boolean)navResult.isOutcome());
        testCfg = svc.getConfig((Object)"outcome-navigation-result");
        WebClientConfigTest.assertNotNull((String)"outcome-navigation-result config should not be null", (Object)testCfg);
        navCfg = (NavigationConfigElement)testCfg.getConfigElement("navigation");
        WebClientConfigTest.assertNotNull((String)"navigation config should not be null", (Object)((Object)navCfg));
        navResult = navCfg.getOverride("/jsp/browse/browse.jsp", null);
        WebClientConfigTest.assertEquals((String)"result should be 'showSomethingElse'", (String)"showSomethingElse", (String)navResult.getResult());
        WebClientConfigTest.assertTrue((String)"isOutcome test should be true", (boolean)navResult.isOutcome());
        navResult = navCfg.getOverride(null, "browse");
        WebClientConfigTest.assertEquals((String)"result should be 'showSomethingElse'", (String)"showSomethingElse", (String)navResult.getResult());
        WebClientConfigTest.assertTrue((String)"isOutcome test should be true", (boolean)navResult.isOutcome());
        navResult = navCfg.getOverride("/jsp/browse/browse.jsp", "browse");
        WebClientConfigTest.assertEquals((String)"result should be 'showSomethingElse'", (String)"showSomethingElse", (String)navResult.getResult());
        WebClientConfigTest.assertTrue((String)"isOutcome test should be true", (boolean)navResult.isOutcome());
        testCfg = svc.getConfig((Object)"duplicate-navigation-overrides");
        WebClientConfigTest.assertNotNull((String)"duplicate-navigation-overrides config should not be null", (Object)testCfg);
        navCfg = (NavigationConfigElement)testCfg.getConfigElement("navigation");
        WebClientConfigTest.assertNotNull((String)"navigation config should not be null", (Object)((Object)navCfg));
        navResult = navCfg.getOverride(null, "browse");
        WebClientConfigTest.assertEquals((String)"result should be 'newOutcome'", (String)"newOutcome", (String)navResult.getResult());
        WebClientConfigTest.assertTrue((String)"isOutcome test should be true", (boolean)navResult.isOutcome());
        navResult = navCfg.getOverride("/jsp/browse/browse.jsp", "nonExistentOutcome");
        WebClientConfigTest.assertNull((String)"result should be null", (Object)navResult);
    }

    public void testNavigationGenericConfig() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config testCfg = svc.getConfig((Object)"duplicate-navigation-overrides");
        WebClientConfigTest.assertNotNull((String)"duplicate-navigation-overrides config should not be null", (Object)testCfg);
        ConfigElement ce = testCfg.getConfigElement("navigation");
        WebClientConfigTest.assertNotNull((String)"navigation config should not be null", (Object)ce);
        List children = ce.getChildren();
        WebClientConfigTest.assertNotNull((Object)children);
        WebClientConfigTest.assertEquals((String)"There should be 2 children", (int)2, (int)children.size());
        ConfigElement child = (ConfigElement)children.get(0);
        String fromViewId = child.getAttribute("from-view-id");
        String fromOutcome = child.getAttribute("from-outcome");
        String toViewId = child.getAttribute("to-view-id");
        String toOutcome = child.getAttribute("to-outcome");
        WebClientConfigTest.assertNull((String)"fromOutcome", (Object)fromOutcome);
        WebClientConfigTest.assertNull((String)"toOutcome", (Object)toOutcome);
        WebClientConfigTest.assertEquals((String)"fromViewId", (String)"/jsp/browse/browse.jsp", (String)fromViewId);
        WebClientConfigTest.assertEquals((String)"toViewId", (String)"/jsp/forums/forums.jsp", (String)toViewId);
        child = (ConfigElement)children.get(1);
        fromViewId = child.getAttribute("from-view-id");
        fromOutcome = child.getAttribute("from-outcome");
        toViewId = child.getAttribute("to-view-id");
        toOutcome = child.getAttribute("to-outcome");
        WebClientConfigTest.assertNull((String)"fromViewId", (Object)fromViewId);
        WebClientConfigTest.assertNull((String)"toViewId", (Object)toViewId);
        WebClientConfigTest.assertEquals((String)"fromOutcome", (String)"browse", (String)fromOutcome);
        WebClientConfigTest.assertEquals((String)"toOutcome", (String)"newOutcome", (String)toOutcome);
    }

    public void testLanguages() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        LanguagesConfigElement config = (LanguagesConfigElement)svc.getConfig((Object)"Languages").getConfigElement("languages");
        WebClientConfigTest.assertNotNull((String)"languages config", (Object)((Object)config));
        WebClientConfigTest.assertEquals((String)"number of languages", (int)4, (int)config.getLanguages().size());
        WebClientConfigTest.assertEquals((String)"first language", (String)"en_US", (String)config.getLanguages().get(0));
        WebClientConfigTest.assertEquals((String)"second language", (String)"fr_FR", (String)config.getLanguages().get(1));
        WebClientConfigTest.assertEquals((String)"third language", (String)"de_DE", (String)config.getLanguages().get(2));
        WebClientConfigTest.assertEquals((String)"fourth language", (String)"ja_JP", (String)config.getLanguages().get(3));
        WebClientConfigTest.assertEquals((String)"en_US", (String)"English", (String)config.getLabelForLanguage("en_US"));
        WebClientConfigTest.assertEquals((String)"fr_FR", (String)"French", (String)config.getLabelForLanguage("fr_FR"));
        WebClientConfigTest.assertEquals((String)"de_DE", (String)"German", (String)config.getLabelForLanguage("de_DE"));
        WebClientConfigTest.assertEquals((String)"ja_JP", (String)"Japanese", (String)config.getLabelForLanguage("ja_JP"));
        try {
            config.getChildren();
            WebClientConfigTest.fail((String)"getChildren() did not throw an excpetion");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void testAdvancedSearch() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        AdvancedSearchConfigElement config = (AdvancedSearchConfigElement)svc.getConfig((Object)"Advanced Search").getConfigElement("advanced-search");
        WebClientConfigTest.assertNotNull((String)"advanced search config", (Object)config);
        WebClientConfigTest.assertEquals((String)"number of content types", (int)2, (int)config.getContentTypes().size());
        WebClientConfigTest.assertEquals((String)"first type", (String)"cm:dictionaryModel", (String)config.getContentTypes().get(0));
        WebClientConfigTest.assertEquals((String)"second type", (String)"fm:post", (String)config.getContentTypes().get(1));
        WebClientConfigTest.assertEquals((String)"number of content properties", (int)3, (int)config.getCustomProperties().size());
        AdvancedSearchConfigElement.CustomProperty property = config.getCustomProperties().get(0);
        WebClientConfigTest.assertTrue((String)"first property is type", (property.Type != null ? 1 : 0) != 0);
        property = config.getCustomProperties().get(1);
        WebClientConfigTest.assertTrue((String)"second property is aspect", (property.Type == null ? 1 : 0) != 0);
        WebClientConfigTest.assertTrue((String)"second property is aspect", (property.Aspect != null ? 1 : 0) != 0);
        WebClientConfigTest.assertEquals((String)"second property aspect", (String)"app:simpleworkflow", (String)property.Aspect);
        WebClientConfigTest.assertEquals((String)"second property name", (String)"app:approveStep", (String)property.Property);
        property = config.getCustomProperties().get(2);
        WebClientConfigTest.assertEquals((String)"third property name", (String)"app:rejectStep", (String)property.Property);
        WebClientConfigTest.assertEquals((String)"third property display id", (String)"reject_step", (String)property.LabelId);
        try {
            config.getChildren();
            WebClientConfigTest.fail((String)"getChildren() did not throw an excpetion");
        }
        catch (ConfigException ce) {
            // empty catch block
        }
    }

    public void testViews() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        ViewsConfigElement config = (ViewsConfigElement)svc.getConfig((Object)"Views").getConfigElement("views");
        WebClientConfigTest.assertNotNull((String)"views config", (Object)config);
        List<String> views = config.getViews();
        WebClientConfigTest.assertEquals((String)"configured views", (int)4, (int)views.size());
        WebClientConfigTest.assertEquals((String)"details view renderer", (String)"org.alfresco.web.ui.common.renderer.data.RichListRenderer$DetailsViewRenderer", (String)views.get(0));
        WebClientConfigTest.assertEquals((String)"icons view renderer", (String)"org.alfresco.web.ui.common.renderer.data.RichListRenderer$IconViewRenderer", (String)views.get(1));
        WebClientConfigTest.assertEquals((String)"list view renderer", (String)"org.alfresco.web.ui.common.renderer.data.RichListRenderer$ListViewRenderer", (String)views.get(2));
        WebClientConfigTest.assertEquals((String)"bubble view renderer", (String)"org.alfresco.web.bean.ForumsBean$TopicBubbleViewRenderer", (String)views.get(3));
        WebClientConfigTest.assertEquals((String)"default view", (String)"details", (String)config.getDefaultView("not-there"));
        WebClientConfigTest.assertEquals((String)"default view for topic", (String)"bubble", (String)config.getDefaultView("topic"));
        WebClientConfigTest.assertEquals((String)"default page size", (int)10, (int)config.getDefaultPageSize("not", "there"));
        WebClientConfigTest.assertEquals((String)"forums icons page size", (int)20, (int)config.getDefaultPageSize("forums", "icons"));
        WebClientConfigTest.assertEquals((String)"forum details page size", (int)50, (int)config.getDefaultPageSize("forum", "details"));
        WebClientConfigTest.assertEquals((String)"icons view page size", (int)9, (int)config.getDefaultPageSize("not-there", "icons"));
        WebClientConfigTest.assertEquals((String)"default sort column", (String)"name", (String)config.getDefaultSortColumn("not-there"));
        WebClientConfigTest.assertEquals((String)"browse page sort column", (String)"name", (String)config.getDefaultSortColumn("browse"));
        WebClientConfigTest.assertEquals((String)"forum page sort column", (String)"modified", (String)config.getDefaultSortColumn("forum"));
        WebClientConfigTest.assertEquals((String)"topic page sort column", (String)"created", (String)config.getDefaultSortColumn("topic"));
        WebClientConfigTest.assertFalse((String)"default sort direction should be ascending", (boolean)config.hasDescendingSort("not-there"));
        WebClientConfigTest.assertFalse((String)"browse screen should use an ascending sort", (boolean)config.hasDescendingSort("browse"));
        WebClientConfigTest.assertTrue((String)"topic screen should use a descending sort", (boolean)config.hasDescendingSort("forum"));
        WebClientConfigTest.assertFalse((String)"topic screen should use an ascending sort", (boolean)config.hasDescendingSort("topic"));
        try {
            config.getChildren();
            WebClientConfigTest.fail((String)"getChildren() did not throw an excpetion");
        }
        catch (ConfigException ce) {
            // empty catch block
        }
    }

    public void testDialogs() {
        XMLConfigService svc = this.initXMLConfigService("test-config-dialogs-wizards.xml");
        Config dialogsConfig = svc.getConfig((Object)"Dialogs");
        WebClientConfigTest.assertNotNull((String)"dialogsConfig should not be null", (Object)dialogsConfig);
        WebClientConfigTest.assertEquals((String)"dialog container", (String)"/jsp/dialog/container.jsp", (String)dialogsConfig.getConfigElement("dialog-container").getValue());
        WebClientConfigTest.assertNull((String)"non existent dialog test should return null", (Object)dialogsConfig.getConfigElement("Non Existent Dialog"));
        DialogsConfigElement dialogsElement = (DialogsConfigElement)dialogsConfig.getConfigElement("dialogs");
        WebClientConfigTest.assertNotNull((String)"dialogsElement should not be null", (Object)((Object)dialogsElement));
        WebClientConfigTest.assertEquals((String)"map size", (int)2, (int)dialogsElement.getDialogs().size());
        DialogsConfigElement.DialogConfig dialog = dialogsElement.getDialog("createSpace");
        WebClientConfigTest.assertNotNull((String)"createSpace dialog config should not be null", (Object)dialog);
        WebClientConfigTest.assertEquals((String)"name", (String)"createSpace", (String)dialog.getName());
        WebClientConfigTest.assertEquals((String)"page", (String)"/jsp/dialog/create-space.jsp", (String)dialog.getPage());
        WebClientConfigTest.assertEquals((String)"managed-bean", (String)"NewSpaceDialog", (String)dialog.getManagedBean());
        WebClientConfigTest.assertEquals((String)"icon", (String)"/images/icons/create_space_large.gif", (String)dialog.getIcon());
        WebClientConfigTest.assertEquals((String)"title-id", (String)"create_space_title", (String)dialog.getTitleId());
        WebClientConfigTest.assertEquals((String)"subtitle-id", (String)"create_space_subtitle", (String)dialog.getSubTitleId());
        WebClientConfigTest.assertEquals((String)"description-id", (String)"create_space_description", (String)dialog.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"error-message-id", (String)"error_create_space_dialog", (String)dialog.getErrorMessageId());
        WebClientConfigTest.assertEquals((String)"actions-config-id", (String)"space-actions", (String)dialog.getActionsConfigId());
        WebClientConfigTest.assertEquals((String)"more-actions-config-id", (String)"more-actions", (String)dialog.getMoreActionsConfigId());
        WebClientConfigTest.assertTrue((String)"actions-as-menu should be true", (boolean)dialog.getActionsAsMenu());
        WebClientConfigTest.assertEquals((String)"actions-menu-label-id", (String)"actions_menu_label", (String)dialog.getActionsMenuLabelId());
        WebClientConfigTest.assertEquals((String)"more-actions-menu-label-id", (String)"more_actions_menu_label", (String)dialog.getMoreActionsMenuLabelId());
        WebClientConfigTest.assertNull((String)"title should be null", (Object)dialog.getTitle());
        WebClientConfigTest.assertNull((String)"subtitle should be null", (Object)dialog.getSubTitle());
        WebClientConfigTest.assertNull((String)"description should be null", (Object)dialog.getDescription());
        WebClientConfigTest.assertNull((String)"actions-menu-label should be null", (Object)dialog.getActionsMenuLabel());
        WebClientConfigTest.assertNull((String)"more-actions-menu-label should be null", (Object)dialog.getMoreActionsMenuLabel());
        dialog = dialogsElement.getDialog("spaceDetails");
        WebClientConfigTest.assertNotNull((String)"spaceDetails dialog config should not be null", (Object)dialog);
        WebClientConfigTest.assertEquals((String)"name", (String)"spaceDetails", (String)dialog.getName());
        WebClientConfigTest.assertEquals((String)"page", (String)"/jsp/spaces/space-details.jsp", (String)dialog.getPage());
        WebClientConfigTest.assertEquals((String)"managed-bean", (String)"SpaceDetailsDialog", (String)dialog.getManagedBean());
        WebClientConfigTest.assertEquals((String)"icon", (String)"/images/icons/create_space_large.gif", (String)dialog.getIcon());
        WebClientConfigTest.assertEquals((String)"title", (String)"Space Details Dialog", (String)dialog.getTitle());
        WebClientConfigTest.assertEquals((String)"subtitle", (String)"Space details subtitle", (String)dialog.getSubTitle());
        WebClientConfigTest.assertEquals((String)"description", (String)"Space Details Dialog Decsription", (String)dialog.getDescription());
        WebClientConfigTest.assertEquals((String)"error-message-id", (String)"error_dialog", (String)dialog.getErrorMessageId());
        WebClientConfigTest.assertEquals((String)"actions-config-id", (String)"space-actions", (String)dialog.getActionsConfigId());
        WebClientConfigTest.assertNull((String)"more-actions-config-id should be null", (Object)dialog.getMoreActionsConfigId());
        WebClientConfigTest.assertFalse((String)"actions-as-menu should be false", (boolean)dialog.getActionsAsMenu());
        WebClientConfigTest.assertEquals((String)"actions-menu-label", (String)"Create", (String)dialog.getActionsMenuLabel());
        WebClientConfigTest.assertEquals((String)"more-actions-menu-label", (String)"More Actions", (String)dialog.getMoreActionsMenuLabel());
        WebClientConfigTest.assertNull((String)"title-id should be null", (Object)dialog.getTitleId());
        WebClientConfigTest.assertNull((String)"subtitle-id should be null", (Object)dialog.getSubTitleId());
        WebClientConfigTest.assertNull((String)"description-id should be null", (Object)dialog.getDescriptionId());
        WebClientConfigTest.assertNull((String)"actions-menu-label-id should be null", (Object)dialog.getActionsMenuLabelId());
        WebClientConfigTest.assertNull((String)"more-actions-menu-label-id should be null", (Object)dialog.getMoreActionsMenuLabelId());
    }

    public void testDialogOverride() {
        XMLConfigService svc = this.initXMLConfigService("test-config-dialogs-wizards.xml", "test-config-override.xml");
        DialogsConfigElement dialogsElement = (DialogsConfigElement)svc.getConfig((Object)"Dialogs").getConfigElement("dialogs");
        WebClientConfigTest.assertEquals((String)"map size", (int)2, (int)dialogsElement.getDialogs().size());
        DialogsConfigElement.DialogConfig dialog = dialogsElement.getDialog("createSpace");
        WebClientConfigTest.assertNotNull((String)"createSpace dialog should not be null", (Object)dialog);
        WebClientConfigTest.assertEquals((String)"page", (String)"/custom/my-create-space.jsp", (String)dialog.getPage());
        WebClientConfigTest.assertEquals((String)"managed-bean", (String)"MyNewSpaceDialog", (String)dialog.getManagedBean());
        WebClientConfigTest.assertEquals((String)"title-id", (String)"my_create_space_title", (String)dialog.getTitleId());
        WebClientConfigTest.assertEquals((String)"description-id", (String)"my_create_space_description", (String)dialog.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"subtitle-id", (String)"my_create_space_subtitle", (String)dialog.getSubTitleId());
        WebClientConfigTest.assertEquals((String)"actions-config-id", (String)"my-space-actions", (String)dialog.getActionsConfigId());
    }

    public void testWizards() {
        XMLConfigService svc = this.initXMLConfigService("test-config-dialogs-wizards.xml");
        Config wizardsConfig = svc.getConfig((Object)"Wizards");
        WebClientConfigTest.assertNotNull((String)"wizardsConfig should not be null", (Object)wizardsConfig);
        WebClientConfigTest.assertEquals((String)"wizard container", (String)"/jsp/wizard/container.jsp", (String)wizardsConfig.getConfigElement("wizard-container").getValue());
        WebClientConfigTest.assertNull((String)"non existent wizard should not be null", (Object)wizardsConfig.getConfigElement("Non Existent Wizard"));
        WizardsConfigElement wizardsElement = (WizardsConfigElement)wizardsConfig.getConfigElement("wizards");
        WebClientConfigTest.assertNotNull((String)"wizardsElement should not be null", (Object)((Object)wizardsElement));
        WebClientConfigTest.assertEquals((String)"map size", (int)2, (int)wizardsElement.getWizards().size());
        WizardsConfigElement.WizardConfig wizard = wizardsElement.getWizard("exampleWizard");
        WebClientConfigTest.assertNotNull((String)"exampleWizard wizard should not be null", (Object)wizard);
        WebClientConfigTest.assertEquals((String)"name", (String)"exampleWizard", (String)wizard.getName());
        WebClientConfigTest.assertEquals((String)"exampleWizard steps", (int)2, (int)wizard.getNumberSteps());
        WebClientConfigTest.assertEquals((String)"managed-bean", (String)"ExampleWizard", (String)wizard.getManagedBean());
        WebClientConfigTest.assertEquals((String)"icon", (String)"/images/icons/example-logo.gif", (String)wizard.getIcon());
        WebClientConfigTest.assertEquals((String)"title", (String)"Example Wizard Title", (String)wizard.getTitle());
        WebClientConfigTest.assertEquals((String)"subtitle", (String)"Example wizard sub title", (String)wizard.getSubTitle());
        WebClientConfigTest.assertEquals((String)"description", (String)"Example Wizard Description", (String)wizard.getDescription());
        WebClientConfigTest.assertEquals((String)"error-message-id", (String)"error_wizard", (String)wizard.getErrorMessageId());
        WebClientConfigTest.assertNull((String)"title-id should be null", (Object)wizard.getTitleId());
        WebClientConfigTest.assertNull((String)"subtitle-id should be null", (Object)wizard.getSubTitleId());
        WebClientConfigTest.assertNull((String)"description-id should be null", (Object)wizard.getDescriptionId());
        Map<String, WizardsConfigElement.StepConfig> stepsMap = wizard.getSteps();
        WizardsConfigElement.StepConfig step1 = stepsMap.get("details");
        WebClientConfigTest.assertNotNull((String)"step 1 of example wizard should not be null", (Object)step1);
        WebClientConfigTest.assertEquals((String)"step title", (String)"Details", (String)step1.getTitle());
        WebClientConfigTest.assertNull((String)"step 1 title-id should be null", (Object)step1.getTitleId());
        wizard = wizardsElement.getWizard("createSpace");
        WebClientConfigTest.assertEquals((String)"name", (String)"createSpace", (String)wizard.getName());
        WebClientConfigTest.assertEquals((String)"createSpace steps", (int)3, (int)wizard.getNumberSteps());
        WebClientConfigTest.assertEquals((String)"managed-bean", (String)"AdvancedSpaceWizard", (String)wizard.getManagedBean());
        WebClientConfigTest.assertEquals((String)"icon", (String)"/images/icons/create_space_large.gif", (String)wizard.getIcon());
        WebClientConfigTest.assertEquals((String)"title-id", (String)"advanced_space_details_title", (String)wizard.getTitleId());
        WebClientConfigTest.assertEquals((String)"subtitle-id", (String)"advanced_space_details_subtitle", (String)wizard.getSubTitleId());
        WebClientConfigTest.assertEquals((String)"description-id", (String)"advanced_space_details_description", (String)wizard.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"error-message-id", (String)"error_create_space_wizard", (String)wizard.getErrorMessageId());
        WebClientConfigTest.assertNull((String)"title should be null", (Object)wizard.getTitle());
        WebClientConfigTest.assertNull((String)"subtitle should be null", (Object)wizard.getSubTitle());
        WebClientConfigTest.assertNull((String)"description should be null", (Object)wizard.getDescription());
        List<WizardsConfigElement.StepConfig> steps = wizard.getStepsAsList();
        WebClientConfigTest.assertNotNull((String)"steps should not be null", steps);
        step1 = steps.get(0);
        WebClientConfigTest.assertEquals((String)"step 1 name", (String)"details", (String)step1.getName());
        WebClientConfigTest.assertEquals((String)"step 1 title-id", (String)"starting_space", (String)step1.getTitleId());
        WebClientConfigTest.assertFalse((String)"step 1 should not have conditional pages", (boolean)step1.hasConditionalPages());
        WizardsConfigElement.PageConfig step1Page = step1.getDefaultPage();
        WebClientConfigTest.assertNotNull((String)"step1Page should not be null", (Object)step1Page);
        WebClientConfigTest.assertEquals((String)"step 1 page", (String)"/jsp/wizard/new-space/create-from.jsp", (String)step1Page.getPath());
        WebClientConfigTest.assertEquals((String)"step 1 title-id", (String)"create_space_details_title", (String)step1Page.getTitleId());
        WebClientConfigTest.assertEquals((String)"step 1 description-id", (String)"create_space_details_desc", (String)step1Page.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"step 1 instruction-id", (String)"create_space_details_instruction", (String)step1Page.getInstructionId());
        WebClientConfigTest.assertNull((String)"step 1 title should be null", (Object)step1Page.getTitle());
        WebClientConfigTest.assertNull((String)"step 1 description should be null", (Object)step1Page.getDescription());
        WizardsConfigElement.StepConfig step2 = steps.get(1);
        WebClientConfigTest.assertEquals((String)"step 2 name", (String)"properties", (String)step2.getName());
        WebClientConfigTest.assertEquals((String)"step 2 title-id", (String)"space_options", (String)step2.getTitleId());
        WebClientConfigTest.assertTrue((String)"step 2 should have conditional pages", (boolean)step2.hasConditionalPages());
        WizardsConfigElement.PageConfig step2DefaultPage = step2.getDefaultPage();
        WebClientConfigTest.assertNotNull((String)"step 2 default page should not be null", (Object)step2DefaultPage);
        WebClientConfigTest.assertEquals((String)"step 2 default page", (String)"/jsp/wizard/new-space/from-scratch.jsp", (String)step2DefaultPage.getPath());
        WebClientConfigTest.assertEquals((String)"step 2 default title-id", (String)"create_space_scratch_title", (String)step2DefaultPage.getTitleId());
        WebClientConfigTest.assertEquals((String)"step 2 default description-id", (String)"create_space_scratch_desc", (String)step2DefaultPage.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"step 2 default instruction-id", (String)"create_space_scratch_instruction", (String)step2DefaultPage.getInstructionId());
        WebClientConfigTest.assertNull((String)"step 2 default title should be null", (Object)step2DefaultPage.getTitle());
        WebClientConfigTest.assertNull((String)"step 2 default description should be null", (Object)step2DefaultPage.getDescription());
        List<WizardsConfigElement.ConditionalPageConfig> conditionalPages = step2.getConditionalPages();
        WebClientConfigTest.assertEquals((String)"number of conditional pages for step 2", (int)1, (int)conditionalPages.size());
        WizardsConfigElement.ConditionalPageConfig step2CondPage = conditionalPages.get(0);
        WebClientConfigTest.assertNotNull((String)"step 2 cond page should not be null", (Object)step2CondPage);
        WebClientConfigTest.assertEquals((String)"step 2 conditon", (String)"#{AdvancedSpaceWizard.createFrom == 'template'}", (String)step2CondPage.getCondition());
        WebClientConfigTest.assertEquals((String)"step 2 cond page", (String)"/jsp/wizard/new-space/from-template.jsp", (String)step2CondPage.getPath());
        WebClientConfigTest.assertEquals((String)"step 2 cond title-id", (String)"create_space_template_title", (String)step2CondPage.getTitleId());
        WebClientConfigTest.assertEquals((String)"step 2 cond description-id", (String)"create_space_template_desc", (String)step2CondPage.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"step 2 cond instruction-id", (String)"create_space_template_instruction", (String)step2CondPage.getInstructionId());
        WebClientConfigTest.assertNull((String)"step 2 cond title should be null", (Object)step2CondPage.getTitle());
        WebClientConfigTest.assertNull((String)"step 2 cond description should be null", (Object)step2CondPage.getDescription());
        WizardsConfigElement.StepConfig step3 = steps.get(2);
        WebClientConfigTest.assertEquals((String)"step 3 name", (String)"summary", (String)step3.getName());
        WebClientConfigTest.assertEquals((String)"step 3 title-id", (String)"summary", (String)step3.getTitleId());
        WebClientConfigTest.assertFalse((String)"step 3 should not have conditional pages", (boolean)step3.hasConditionalPages());
        WizardsConfigElement.PageConfig step3Page = step3.getDefaultPage();
        WebClientConfigTest.assertNotNull((String)"step3Page should not be null", (Object)step3Page);
        WebClientConfigTest.assertEquals((String)"step 3 page", (String)"/jsp/wizard/new-space/summary.jsp", (String)step3Page.getPath());
        WebClientConfigTest.assertEquals((String)"step 3 title-id", (String)"create_space_summary_title", (String)step3Page.getTitleId());
        WebClientConfigTest.assertEquals((String)"step 3 description-id", (String)"create_space_summary_desc", (String)step3Page.getDescriptionId());
        WebClientConfigTest.assertEquals((String)"step 3 instruction-id", (String)"create_space_summary_instruction", (String)step3Page.getInstructionId());
        WebClientConfigTest.assertNull((String)"step 3 title should be null", (Object)step3Page.getTitle());
        WebClientConfigTest.assertNull((String)"step 3 description should be null", (Object)step3Page.getDescription());
    }

    public void testActions() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config cfg = svc.getGlobalConfig();
        WebClientConfigTest.assertNotNull((String)"cfg should not be null", (Object)cfg);
        ActionsConfigElement actionsConfig = (ActionsConfigElement)cfg.getConfigElement("actions");
        WebClientConfigTest.assertNotNull((String)"actions config element should not be null", (Object)((Object)actionsConfig));
        ActionsConfigElement.ActionDefinition docDetails = actionsConfig.getActionDefinition("details_doc");
        WebClientConfigTest.assertNotNull((String)"details_doc action definition should not be null", (Object)docDetails);
        WebClientConfigTest.assertEquals((String)"details_doc action", (String)"dialog:showDocDetails", (String)docDetails.Action);
        ActionsConfigElement.ActionDefinition spaceDetails = actionsConfig.getActionDefinition("details_space");
        WebClientConfigTest.assertNotNull((String)"details_space action definition should not be null", (Object)spaceDetails);
        WebClientConfigTest.assertEquals((String)"details_space action", (String)"dialog:showSpaceDetails", (String)spaceDetails.Action);
        ActionsConfigElement.ActionGroup group = actionsConfig.getActionGroup("document_browse");
        WebClientConfigTest.assertNotNull((String)"group definition should not be null", (Object)group);
        WebClientConfigTest.assertFalse((String)"showLink for document_browse group should be false", (boolean)group.ShowLink);
        for (String actionId : group) {
            if (actionId.equals("details_doc") || actionId.equals("details_space")) continue;
            WebClientConfigTest.fail((String)("Unrecognised action-id '" + actionId + "' in action group '" + group.getId() + "'"));
        }
    }

    public void testActionsOverriding() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        Config cfg = svc.getConfig((Object)"Actions Override");
        WebClientConfigTest.assertNotNull((String)"cfg should not be null", (Object)cfg);
        ActionsConfigElement actionsConfig = (ActionsConfigElement)cfg.getConfigElement("actions");
        WebClientConfigTest.assertNotNull((String)"actions config element should not be null", (Object)((Object)actionsConfig));
        ActionsConfigElement.ActionDefinition docDetails = actionsConfig.getActionDefinition("details_doc");
        WebClientConfigTest.assertNotNull((String)"details_doc action definition should not be null", (Object)docDetails);
        WebClientConfigTest.assertEquals((String)"details_doc action", (String)"dialog:showCustomDocDetails", (String)docDetails.Action);
        ActionsConfigElement.ActionDefinition spaceDetails = actionsConfig.getActionDefinition("details_space");
        WebClientConfigTest.assertNotNull((String)"details_space action definition should not be null", (Object)spaceDetails);
        WebClientConfigTest.assertEquals((String)"details_space action", (String)"dialog:showSpaceDetails", (String)spaceDetails.Action);
        ActionsConfigElement.ActionDefinition customAction = actionsConfig.getActionDefinition("custom_action");
        WebClientConfigTest.assertNotNull((String)"custom_action action definition should not be null", (Object)customAction);
        WebClientConfigTest.assertEquals((String)"custom_action action", (String)"customAction", (String)customAction.Action);
        ActionsConfigElement.ActionGroup group = actionsConfig.getActionGroup("document_browse");
        WebClientConfigTest.assertNotNull((String)"group definition should not be null", (Object)group);
        WebClientConfigTest.assertTrue((String)"showLink for document_browse group should be true", (boolean)group.ShowLink);
        WebClientConfigTest.assertEquals((String)"document_browse group style class", (String)"inlineAction", (String)group.StyleClass);
        WebClientConfigTest.assertNull((String)"Style for document_browse group should be null", (Object)group.Style);
        ArrayList<String> actions = new ArrayList<String>(3);
        for (String actionId : group) {
            actions.add(actionId);
        }
        WebClientConfigTest.assertEquals((String)"number of items in document_browse group", (int)2, (int)actions.size());
        WebClientConfigTest.assertEquals((String)"first action", (String)"details_doc", (String)((String)actions.get(0)));
        WebClientConfigTest.assertEquals((String)"second action", (String)"custom_action", (String)((String)actions.get(1)));
        ActionsConfigElement.ActionGroup newGroup = actionsConfig.getActionGroup("new_group");
        WebClientConfigTest.assertNotNull((String)"new_group definition should not be null", (Object)newGroup);
        actions = new ArrayList(1);
        for (String actionId : newGroup) {
            actions.add(actionId);
        }
        WebClientConfigTest.assertEquals((String)"number of items in new_group group", (int)1, (int)actions.size());
        WebClientConfigTest.assertEquals((String)"action", (String)"custom_action", (String)((String)actions.get(0)));
    }

    public void testETHREEOH2145() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-e30-2145.xml");
        Config cfg = svc.getGlobalConfig();
        WebClientConfigTest.assertNotNull((String)"cfg should not be null", (Object)cfg);
        ClientConfigElement clientConfig = (ClientConfigElement)cfg.getConfigElement("client");
        WebClientConfigTest.assertNotNull((String)"clientConfig should not be null", (Object)((Object)clientConfig));
        WebClientConfigTest.assertEquals((String)"from-email-address", (String)"alfresco@alfresco.org", (String)clientConfig.getFromEmailAddress());
        WebClientConfigTest.assertEquals((String)"cifs-url-suffix", (String)".alfresco.org", (String)clientConfig.getCifsURLSuffix());
        WebClientConfigTest.assertEquals((String)"edit-link-type", (String)"http", (String)clientConfig.getEditLinkType());
        WebClientConfigTest.assertEquals((String)"error-page", (String)"/jsp/error.jsp", (String)clientConfig.getErrorPage());
        WebClientConfigTest.assertEquals((String)"home-space-permission", (String)"Consumer", (String)clientConfig.getHomeSpacePermission());
        List<QName> attrs = clientConfig.getSimpleSearchAdditionalAttributes();
        WebClientConfigTest.assertNotNull((String)"Expecting a list of search attributes", attrs);
        WebClientConfigTest.assertEquals((String)"Expecting 2 search attributes", (int)2, (int)attrs.size());
    }

    public void testWCM() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml");
        Config global = svc.getGlobalConfig();
        WebClientConfigTest.assertNotNull((Object)global);
        ConfigElement wcmConfig = global.getConfigElement("wcm");
        WebClientConfigTest.assertNotNull((Object)wcmConfig);
        ConfigElement workflows = wcmConfig.getChild("workflows");
        WebClientConfigTest.assertNotNull((Object)workflows);
        WebClientConfigTest.assertEquals((String)"wcmwf:submit", (String)workflows.getValue());
        ConfigElement adminWorkflows = wcmConfig.getChild("admin-workflows");
        WebClientConfigTest.assertNotNull((Object)adminWorkflows);
        WebClientConfigTest.assertEquals((String)"wcmwf:changerequest", (String)adminWorkflows.getValue());
        ConfigElement viewsConfig = wcmConfig.getChild("views");
        WebClientConfigTest.assertNotNull((Object)viewsConfig);
        ConfigElement browsePageSizeConfig = viewsConfig.getChild("browse-page-size");
        WebClientConfigTest.assertNotNull((Object)browsePageSizeConfig);
        WebClientConfigTest.assertEquals((String)"25", (String)browsePageSizeConfig.getValue());
        ConfigElement deploymentConfig = wcmConfig.getChild("deployment");
        WebClientConfigTest.assertNotNull((Object)deploymentConfig);
        ConfigElement pollingConfig = deploymentConfig.getChild("progress-polling-frequency");
        WebClientConfigTest.assertNotNull((Object)pollingConfig);
        WebClientConfigTest.assertEquals((String)"2", (String)pollingConfig.getValue());
        ConfigElement linksConfig = wcmConfig.getChild("links-management");
        WebClientConfigTest.assertNotNull((Object)linksConfig);
        pollingConfig = linksConfig.getChild("progress-polling-frequency");
        WebClientConfigTest.assertNotNull((Object)pollingConfig);
        WebClientConfigTest.assertEquals((String)"2", (String)pollingConfig.getValue());
        ConfigElement xformsConfig = wcmConfig.getChild("xforms");
        WebClientConfigTest.assertNotNull((Object)xformsConfig);
        List widgetConfig = xformsConfig.getChildren("widget");
        WebClientConfigTest.assertEquals((int)2, (int)widgetConfig.size());
        ConfigElement scriptsConfig = wcmConfig.getChild("xforms-scripts");
        WebClientConfigTest.assertNull((Object)scriptsConfig);
        ConfigElement customConfig = wcmConfig.getChild("custom-config");
        WebClientConfigTest.assertNull((Object)customConfig);
    }

    public void testWCMOverride() {
        XMLConfigService svc = this.initXMLConfigService("test-config.xml", "test-config-override.xml");
        Config global = svc.getGlobalConfig();
        WebClientConfigTest.assertNotNull((Object)global);
        ConfigElement wcmConfig = global.getConfigElement("wcm");
        WebClientConfigTest.assertNotNull((Object)wcmConfig);
        ConfigElement workflows = wcmConfig.getChild("workflows");
        WebClientConfigTest.assertNotNull((Object)workflows);
        WebClientConfigTest.assertEquals((String)"custom:submit", (String)workflows.getValue().trim());
        StringTokenizer t = new StringTokenizer(workflows.getValue().trim(), ", ");
        while (t.hasMoreTokens()) {
            System.out.println("workflow = '" + t.nextToken() + "'");
        }
        ConfigElement adminWorkflows = wcmConfig.getChild("admin-workflows");
        WebClientConfigTest.assertNotNull((Object)adminWorkflows);
        WebClientConfigTest.assertEquals((String)"custom:changerequest, custom:somejob", (String)adminWorkflows.getValue());
        t = new StringTokenizer(adminWorkflows.getValue().trim(), ", ");
        while (t.hasMoreTokens()) {
            System.out.println("admin workflow = '" + t.nextToken() + "'");
        }
        ConfigElement viewsConfig = wcmConfig.getChild("views");
        WebClientConfigTest.assertNotNull((Object)viewsConfig);
        ConfigElement browsePageSizeConfig = viewsConfig.getChild("browse-page-size");
        WebClientConfigTest.assertNotNull((Object)browsePageSizeConfig);
        WebClientConfigTest.assertEquals((String)"50", (String)browsePageSizeConfig.getValue());
        ConfigElement deploymentConfig = wcmConfig.getChild("deployment");
        WebClientConfigTest.assertNotNull((Object)deploymentConfig);
        ConfigElement pollingConfig = deploymentConfig.getChild("progress-polling-frequency");
        WebClientConfigTest.assertNotNull((Object)pollingConfig);
        WebClientConfigTest.assertEquals((String)"10", (String)pollingConfig.getValue());
        ConfigElement linksConfig = wcmConfig.getChild("links-management");
        WebClientConfigTest.assertNotNull((Object)linksConfig);
        pollingConfig = linksConfig.getChild("progress-polling-frequency");
        WebClientConfigTest.assertNotNull((Object)pollingConfig);
        WebClientConfigTest.assertEquals((String)"15", (String)pollingConfig.getValue());
        ConfigElement xformsConfig = wcmConfig.getChild("xforms");
        WebClientConfigTest.assertNotNull((Object)xformsConfig);
        List widgetConfig = xformsConfig.getChildren("widget");
        WebClientConfigTest.assertEquals((int)3, (int)widgetConfig.size());
        ConfigElement scriptsConfig = wcmConfig.getChild("xforms-scripts");
        WebClientConfigTest.assertNotNull((Object)scriptsConfig);
        WebClientConfigTest.assertEquals((String)"/custom/custom-xforms.js, /custom/another-custom-xforms.js", (String)scriptsConfig.getValue());
        t = new StringTokenizer(scriptsConfig.getValue().trim(), ", ");
        while (t.hasMoreTokens()) {
            System.out.println("custom script = '" + t.nextToken() + "'");
        }
        ConfigElement customConfig = wcmConfig.getChild("custom-config");
        WebClientConfigTest.assertNotNull((Object)customConfig);
        WebClientConfigTest.assertEquals((String)"50", (String)customConfig.getValue());
    }
}

