/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormImpl;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormInstanceDataImpl;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FreeMarkerRenderingEngine;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.forms.RenditionImpl;
import org.alfresco.web.forms.XSLFORenderingEngine;
import org.alfresco.web.forms.XSLTRenderingEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormsService {
    private static final Log LOGGER = LogFactory.getLog(FormsService.class);
    private static final RenderingEngine[] RENDERING_ENGINES = new RenderingEngine[]{new FreeMarkerRenderingEngine(), new XSLTRenderingEngine(), new XSLFORenderingEngine()};
    private final ContentService contentService;
    private final NodeService nodeService;
    private final NamespaceService namespaceService;
    private final SearchService searchService;
    private NodeRef contentFormsNodeRef;
    private NodeRef webContentFormsNodeRef;

    public FormsService(ContentService contentService, NodeService nodeService, NamespaceService namespaceService, SearchService searchService, PolicyComponent policyComponent) {
        this.contentService = contentService;
        this.nodeService = nodeService;
        this.namespaceService = namespaceService;
        this.searchService = searchService;
        policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), WCMAppModel.TYPE_FORMFOLDER, (Behaviour)new JavaBehaviour((Object)this, "handleMoveFormFolder", Behaviour.NotificationFrequency.FIRST_EVENT));
        policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), WCMAppModel.TYPE_FORMFOLDER, (Behaviour)new JavaBehaviour((Object)this, "handleDeleteFormFolder", Behaviour.NotificationFrequency.FIRST_EVENT));
    }

    public RenderingEngine[] getRenderingEngines() {
        return RENDERING_ENGINES;
    }

    public RenderingEngine getRenderingEngine(String name) {
        for (RenderingEngine re : this.getRenderingEngines()) {
            if (!re.getName().equals(name)) continue;
            return re;
        }
        return null;
    }

    public RenderingEngine guessRenderingEngine(String fileName) {
        for (RenderingEngine re : this.getRenderingEngines()) {
            if (!fileName.endsWith(re.getDefaultTemplateFileExtension())) continue;
            return re;
        }
        return null;
    }

    public NodeRef getContentFormsNodeRef() {
        if (this.contentFormsNodeRef == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getContentFormsFolderName(fc);
            this.contentFormsNodeRef = this.getNodeRefFromXPath(xpath);
        }
        return this.contentFormsNodeRef;
    }

    public NodeRef getWebContentFormsNodeRef() {
        if (this.webContentFormsNodeRef == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getWebContentFormsFolderName(fc);
            this.webContentFormsNodeRef = this.getNodeRefFromXPath(xpath);
        }
        return this.webContentFormsNodeRef;
    }

    private NodeRef getNodeRefFromXPath(String xpath) {
        List results;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("locating noderef at " + xpath));
        }
        return (results = this.searchService.selectNodes(this.nodeService.getRootNode(Repository.getStoreRef()), xpath, null, (NamespacePrefixResolver)this.namespaceService, false)) != null && results.size() == 1 ? (NodeRef)results.get(0) : null;
    }

    public Collection<Form> getForms() {
        String query = "+ASPECT:\"" + WCMAppModel.ASPECT_FORM + "\" +PARENT:\"" + this.getContentFormsNodeRef() + "\"";
        return this.getForms(query);
    }

    public Collection<Form> getWebForms() {
        String query = "+ASPECT:\"" + WCMAppModel.ASPECT_FORM + "\" +PARENT:\"" + this.getWebContentFormsNodeRef() + "\"";
        return this.getForms(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Form> getForms(String query) {
        ResultSet rs = this.searchService.query(Repository.getStoreRef(), "lucene", query);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("found " + rs.length() + " form definitions"));
            }
            ArrayList<Form> result = new ArrayList<Form>(rs.length());
            for (ResultSetRow row : rs) {
                result.add(this.getForm(row.getNodeRef()));
            }
            QuickSort sorter = new QuickSort(result, "name", true, "case-insensitive");
            sorter.sort();
            ArrayList<Form> arrayList = result;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }

    public Form getForm(String name) throws FormNotFoundException {
        NodeRef result = this.nodeService.getChildByName(this.getContentFormsNodeRef(), ContentModel.ASSOC_CONTAINS, name);
        if (result == null) {
            throw new FormNotFoundException(name);
        }
        return this.getForm(result);
    }

    public Form getWebForm(String name) throws FormNotFoundException {
        NodeRef result = this.nodeService.getChildByName(this.getWebContentFormsNodeRef(), ContentModel.ASSOC_CONTAINS, name);
        if (result == null) {
            throw new FormNotFoundException(name);
        }
        return this.getForm(result);
    }

    public Form getForm(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, WCMAppModel.ASPECT_FORM)) {
            throw new IllegalArgumentException("node " + nodeRef + " is not a form");
        }
        FormImpl result = new FormImpl(nodeRef, this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("loaded form " + result + " for noderef " + nodeRef));
        }
        return result;
    }

    public FormInstanceData getFormInstanceData(int version, String avmPath) throws FormNotFoundException {
        return this.getFormInstanceData(AVMNodeConverter.ToNodeRef((int)version, (String)avmPath));
    }

    public FormInstanceData getFormInstanceData(NodeRef nodeRef) throws FormNotFoundException {
        String avmPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getSecond();
        WebProject webProject = new WebProject(avmPath);
        FormInstanceDataImpl fid = null;
        try {
            fid = new FormInstanceDataImpl(nodeRef, this, webProject);
            return fid;
        }
        catch (IllegalArgumentException iae) {
            throw new FormNotFoundException(iae.getMessage());
        }
    }

    public Rendition getRendition(int version, String avmPath) {
        return this.getRendition(AVMNodeConverter.ToNodeRef((int)version, (String)avmPath));
    }

    public Rendition getRendition(NodeRef nodeRef) {
        return new RenditionImpl(nodeRef, this);
    }

    public List<WebProject> getAssociatedWebProjects(Form form) {
        List<NodeRef> formConfigurations = this.getFormConfigurations(form.getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("found " + formConfigurations.size() + " web projects configured with " + form.getName()));
        }
        ArrayList<WebProject> result = new ArrayList<WebProject>(formConfigurations.size());
        for (NodeRef ref : formConfigurations) {
            List parents = this.nodeService.getParentAssocs(ref);
            assert (parents.size() != 1) : "expected only one parent for " + ref + " got " + parents.size();
            result.add(new WebProject(((ChildAssociationRef)parents.get(0)).getParentRef()));
        }
        return result;
    }

    public void handleMoveFormFolder(ChildAssociationRef oldChild, ChildAssociationRef newChild) {
        String oldName = oldChild.getQName().getLocalName();
        String newName = newChild.getQName().getLocalName();
        List<NodeRef> formConfigurations = this.getFormConfigurations(oldName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("handling rename (" + oldName + " => " + newName + ") for " + formConfigurations.size()));
        }
        for (NodeRef ref : formConfigurations) {
            this.nodeService.setProperty(ref, WCMAppModel.PROP_FORMNAME, (Serializable)((Object)newName));
        }
    }

    public void handleDeleteFormFolder(ChildAssociationRef childRef, boolean isArchivedNode) {
        String formName = childRef.getQName().getLocalName();
        List<NodeRef> formConfigurations = this.getFormConfigurations(formName);
        for (NodeRef ref : formConfigurations) {
            List parents = this.nodeService.getParentAssocs(ref);
            assert (parents.size() != 1) : "expected only one parent for " + ref + " got " + parents.size();
            NodeRef parentRef = ((ChildAssociationRef)parents.get(0)).getParentRef();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("removing configuration for " + formName + " from web project " + this.nodeService.getProperty(parentRef, ContentModel.PROP_NAME)));
            }
            if (!childRef.getParentRef().equals((Object)parentRef)) continue;
            this.nodeService.removeChild(parentRef, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeRef> getFormConfigurations(String formName) {
        String query = "+TYPE:\"" + WCMAppModel.TYPE_WEBFORM + "\"" + " +@" + Repository.escapeQName(WCMAppModel.PROP_FORMNAME) + ":\"" + formName + "\"";
        ResultSet rs = this.searchService.query(Repository.getStoreRef(), "lucene", query);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("query " + query + " returned " + rs.length() + " results"));
            }
            ArrayList<NodeRef> result = new ArrayList<NodeRef>(rs.length());
            for (ResultSetRow row : rs) {
                result.add(row.getNodeRef());
            }
            ArrayList<NodeRef> arrayList = result;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }
}

