/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

class RenditionImpl
implements Rendition {
    private static final long serialVersionUID = -342658762155499039L;
    private static final Log LOGGER = LogFactory.getLog(RenditionImpl.class);
    private final NodeRef nodeRef;
    private transient FormsService formsService;
    private transient RenderingEngineTemplate renderingEngineTemplate;
    private String descriptionAttribute;

    RenditionImpl(NodeRef nodeRef, FormsService formsService) {
        if (nodeRef == null) {
            throw new NullPointerException();
        }
        if (formsService == null) {
            throw new NullPointerException();
        }
        AVMService avmService = this.getServiceRegistry().getAVMService();
        if (!avmService.hasAspect(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getSecond(), WCMAppModel.ASPECT_RENDITION)) {
            throw new IllegalArgumentException("node " + nodeRef + " does not have aspect " + WCMAppModel.ASPECT_RENDITION);
        }
        this.nodeRef = nodeRef;
        this.formsService = formsService;
    }

    RenditionImpl(int version, String avmPath, FormsService formsService) {
        this(AVMNodeConverter.ToNodeRef((int)version, (String)avmPath), formsService);
    }

    private FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public String getName() {
        return AVMNodeConverter.SplitBase((String)((String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond()))[1];
    }

    public String getDescription() {
        AVMService avmService = this.getServiceRegistry().getAVMService();
        return avmService.getNodeProperty(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond(), ContentModel.PROP_DESCRIPTION).getStringValue();
    }

    public String getWebappRelativePath() {
        return AVMUtil.getWebappRelativePath(this.getPath());
    }

    public String getSandboxRelativePath() {
        return AVMUtil.getSandboxRelativePath(this.getPath());
    }

    public FormInstanceData getPrimaryFormInstanceData() throws FileNotFoundException {
        return this.getPrimaryFormInstanceData(false);
    }

    public FormInstanceData getPrimaryFormInstanceData(boolean includeDeleted) throws FileNotFoundException {
        AVMService avmService = this.getServiceRegistry().getAVMLockingAwareService();
        String fidAVMStoreRelativePath = (String)((Object)avmService.getNodeProperty(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond(), WCMAppModel.PROP_PRIMARY_FORM_INSTANCE_DATA).getValue(DataTypeDefinition.TEXT));
        String avmStore = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond();
        String path = (avmStore = avmStore.substring(0, avmStore.indexOf(58))) + ':' + fidAVMStoreRelativePath;
        if (avmService.lookup(-1, path, includeDeleted) == null) {
            throw new FileNotFoundException("unable to find primary form instance data " + path);
        }
        return this.getFormsService().getFormInstanceData(-1, path);
    }

    public RenderingEngineTemplate getRenderingEngineTemplate() {
        if (this.renderingEngineTemplate == null) {
            AVMService avmService = this.getServiceRegistry().getAVMLockingAwareService();
            PropertyValue pv = avmService.getNodeProperty(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond(), WCMAppModel.PROP_PARENT_RENDERING_ENGINE_TEMPLATE);
            if (pv == null) {
                LOGGER.debug((Object)("property " + WCMAppModel.PROP_PARENT_RENDERING_ENGINE_TEMPLATE + " not set on " + this.getPath()));
                return null;
            }
            NodeRef retNodeRef = (NodeRef)pv.getValue(DataTypeDefinition.NODE_REF);
            if (retNodeRef == null) {
                LOGGER.debug((Object)("unable to locate parent rendering engine template of rendition " + this.getPath()));
                return null;
            }
            pv = avmService.getNodeProperty(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond(), WCMAppModel.PROP_PARENT_RENDITION_PROPERTIES);
            if (pv == null) {
                LOGGER.debug((Object)("property " + WCMAppModel.PROP_PARENT_RENDITION_PROPERTIES + " not set on " + this.getPath()));
                return null;
            }
            NodeRef rpNodeRef = (NodeRef)pv.getValue(DataTypeDefinition.NODE_REF);
            if (rpNodeRef == null) {
                LOGGER.debug((Object)("unable to locate parent rendering engine template properties of rendition " + this.getPath()));
                return null;
            }
            this.renderingEngineTemplate = new RenderingEngineTemplateImpl(retNodeRef, rpNodeRef, this.getFormsService());
        }
        return this.renderingEngineTemplate;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String getPath() {
        return (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond();
    }

    public String getUrl() {
        return AVMUtil.getPreviewURI(this.getPath());
    }

    public String getFileTypeImage() {
        return FileTypeImageUtils.getFileTypeImage((String)this.getName(), (boolean)false);
    }

    public OutputStream getOutputStream() {
        Pair p;
        AVMService avmService = this.getServiceRegistry().getAVMLockingAwareService();
        return avmService.lookup(((Integer)(p = AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef)).getFirst()).intValue(), (String)p.getSecond()) == null ? avmService.createFile(AVMNodeConverter.SplitBase((String)((String)p.getSecond()))[0], AVMNodeConverter.SplitBase((String)((String)p.getSecond()))[1]) : avmService.getFileOutputStream(this.getPath());
    }

    public void regenerate() throws IOException, RenderingEngine.RenderingException, SAXException {
        this.regenerate(this.getPrimaryFormInstanceData());
    }

    @Deprecated
    public void regenerate(FormInstanceData formInstanceData) throws IOException, RenderingEngine.RenderingException, SAXException {
        this.getRenderingEngineTemplate().render(formInstanceData, this);
    }

    private ServiceRegistry getServiceRegistry() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Repository.getServiceRegistry(fc);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof RenditionImpl && this.getNodeRef().equals((Object)((RenditionImpl)other).getNodeRef());
    }

    public String toString() {
        return this.getClass().getName() + "{path : " + this.getPath() + ", rendering_engine_template : " + this.getRenderingEngineTemplate() + "}";
    }

    public String getDescriptionAttribute() {
        if (StringUtils.isEmpty((String)this.descriptionAttribute)) {
            this.descriptionAttribute = this.buildDescriptionAttribute();
        }
        return this.descriptionAttribute;
    }

    public String getLabelAttribute() {
        StringBuilder builder = new StringBuilder("<b>");
        builder.append(Utils.encode((String)this.getName()));
        builder.append("</b>");
        return builder.toString();
    }

    private String buildDescriptionAttribute() {
        int hashCode = this.hashCode();
        String contextPath = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath();
        StringBuilder attribute = new StringBuilder(255);
        attribute.append("<span style=\"float:right;\"><a id=\"preview").append(hashCode).append("\" ");
        attribute.append("href=\"").append(this.getUrl()).append("\" ");
        attribute.append("style=\"text-decoration: none;\" ");
        attribute.append("target=\"window_").append(hashCode).append("_").append(this.getName()).append("\">");
        attribute.append("<img src=\"").append(contextPath).append("/images/icons/preview_website.gif\" ");
        attribute.append("align=\"absmiddle\" style=\"border: 0px\" alt=\"").append(this.getName()).append("\">");
        attribute.append("</a></span><span>").append(this.getDescription()).append("</span>");
        return attribute.toString();
    }
}

