/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static final Log LOGGER = LogFactory.getLog(XMLUtil.class);

    public static Document newDocument() {
        return XMLUtil.getDocumentBuilder().newDocument();
    }

    public static void print(Node n, Writer output) {
        XMLUtil.print(n, output, true);
    }

    public static void print(Node n, Writer output, boolean indent) {
        block3: {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer t = tf.newTransformer();
                t.setOutputProperty("indent", indent ? "yes" : "no");
                t.setOutputProperty("encoding", "UTF-8");
                t.setOutputProperty("omit-xml-declaration", "no");
                t.setOutputProperty("method", "xml");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("writing out a document for " + (n instanceof Document ? ((Document)n).getDocumentElement() : n).getNodeName() + " to " + (output instanceof StringWriter ? "string" : output)));
                }
                t.transform(new DOMSource(n), new StreamResult(output));
            }
            catch (TransformerException te) {
                te.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)te.getMessage());
            }
        }
    }

    public static void print(Node n, File output) throws IOException {
        XMLUtil.print(n, new FileWriter(output));
    }

    public static String toString(Node n) {
        return XMLUtil.toString(n, true);
    }

    public static String toString(Node n, boolean indent) {
        StringWriter result = new StringWriter();
        XMLUtil.print(n, result, indent);
        return result.toString();
    }

    public static Document parse(String source) throws SAXException, IOException {
        return XMLUtil.parse(new ByteArrayInputStream(source.getBytes("UTF-8")));
    }

    public static Document parse(NodeRef nodeRef, ContentService contentService) throws SAXException, IOException {
        ContentReader contentReader = contentService.getReader(nodeRef, ContentModel.TYPE_CONTENT);
        InputStream in = contentReader.getContentInputStream();
        return XMLUtil.parse(in);
    }

    public static Document parse(int version, String path, AVMService avmService) throws SAXException, IOException {
        return XMLUtil.parse(avmService.getFileInputStream(version, path));
    }

    public static Document parse(File source) throws SAXException, IOException {
        return XMLUtil.parse(new FileInputStream(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream source) throws SAXException, IOException {
        try {
            DocumentBuilder db = XMLUtil.getDocumentBuilder();
            Document document = db.parse(source);
            return document;
        }
        finally {
            source.close();
        }
    }

    public static DocumentBuilder getDocumentBuilder() {
        return XMLUtil.getDocumentBuilder(true, false);
    }

    public static String buildXPath(Node from, Element to) {
        String result = "";
        Node tmp = from;
        do {
            if (tmp instanceof Attr) {
                assert (result.length() == 0);
                result = "@" + tmp.getNodeName();
                continue;
            }
            if (tmp instanceof Element) {
                Node tmp2 = tmp;
                int position = 1;
                while (tmp2.getPreviousSibling() != null) {
                    if (tmp2.getNodeName().equals(tmp.getNodeName())) {
                        ++position;
                    }
                    tmp2 = tmp2.getPreviousSibling();
                }
                String part = tmp.getNodeName() + "[" + position + "]";
                result = "/" + part + result;
                continue;
            }
            if (tmp instanceof Text) {
                assert (result.length() == 0);
                result = "/text()";
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            throw new IllegalArgumentException("unsupported node type " + tmp);
        } while ((tmp = tmp.getParentNode()) != to.getParentNode() && tmp != null);
        return result;
    }

    public static DocumentBuilder getDocumentBuilder(boolean namespaceAware, boolean validating) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(namespaceAware);
            dbf.setValidating(validating);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            LOGGER.error((Object)pce);
            return null;
        }
    }

    public static NodeList combine(final NodeList ... nls) {
        return new NodeList(){

            public Node item(int index) {
                int offset = 0;
                for (int i = 0; i < nls.length; ++i) {
                    if (index - offset < nls[i].getLength()) {
                        return nls[i].item(index - offset);
                    }
                    offset += nls[i].getLength();
                }
                return null;
            }

            public int getLength() {
                int result = 0;
                for (int i = 0; i < nls.length; ++i) {
                    result += nls[i].getLength();
                }
                return result;
            }
        };
    }
}

