/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIMenu
extends SelfRenderingComponent {
    private static final String MENU_ID_KEY = "__awc_menu_id";
    private String label;
    private String tooltip;

    public String getFamily() {
        return "org.alfresco.faces.Controls";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String menuId = UIMenu.getNextMenuId((UIComponent)this, context);
        out.write("<a href='#' onclick=\"javascript:_toggleMenu(event, '");
        out.write(menuId);
        out.write("');return false;\"");
        UIMenu.outputAttribute((ResponseWriter)out, this.getAttributes().get("style"), (String)"style");
        UIMenu.outputAttribute((ResponseWriter)out, this.getAttributes().get("styleClass"), (String)"class");
        UIMenu.outputAttribute((ResponseWriter)out, (Object)this.getTooltip(), (String)"title");
        out.write(62);
        String label = this.getLabel();
        if (label != null) {
            out.write(Utils.encode((String)label));
        }
        if (this.getAttributes().get("image") != null) {
            out.write(Utils.buildImageTag(context, (String)this.getAttributes().get("image"), null, "-4px"));
        }
        out.write("</a>");
        out.write("<br><div id='");
        out.write(menuId);
        out.write("' style=\"position:absolute;display:none;padding-left:2px;*width:0px\">");
        out.write("<table border='0' cellpadding='0'");
        UIMenu.outputAttribute((ResponseWriter)out, this.getAttributes().get("itemSpacing"), (String)"cellspacing");
        UIMenu.outputAttribute((ResponseWriter)out, this.getAttributes().get("menuStyle"), (String)"style");
        UIMenu.outputAttribute((ResponseWriter)out, this.getAttributes().get("menuStyleClass"), (String)"class");
        out.write(">");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("</table></div>");
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.label = (String)values[1];
        this.tooltip = (String)values[2];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.label, this.tooltip};
    }

    public String getLabel() {
        ValueBinding vb = this.getValueBinding("label");
        if (vb != null) {
            this.label = (String)vb.getValue(this.getFacesContext());
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTooltip() {
        ValueBinding vb = this.getValueBinding("tooltip");
        if (vb != null) {
            this.tooltip = (String)vb.getValue(this.getFacesContext());
        }
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public static String getNextMenuId(UIComponent component, FacesContext context) {
        Integer val = (Integer)context.getExternalContext().getRequestMap().get(MENU_ID_KEY);
        if (val == null) {
            val = 0;
        }
        String id = component.getClientId(context) + '_' + val.toString();
        val = val + 1;
        context.getExternalContext().getRequestMap().put(MENU_ID_KEY, val);
        return id;
    }
}

