/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.description;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.description.UIDescription;
import org.alfresco.web.ui.common.component.description.UIDescriptions;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIDynamicDescription
extends SelfRenderingComponent {
    private String selected;
    private String functionName;

    public String getSelected() {
        ValueBinding vb;
        if (this.selected == null && (vb = this.getValueBinding("selected")) != null) {
            this.selected = (String)vb.getValue(this.getFacesContext());
        }
        return this.selected;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public String getFunctionName() {
        if (this.functionName == null) {
            this.functionName = "itemSelected";
        }
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFamily() {
        return "org.alfresco.faces.DynamicDescription";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("<script language='JavaScript'>\n");
        out.write("var m_");
        out.write(this.getFunctionName());
        out.write(" = '");
        if (this.getSelected() != null) {
            out.write("desc-");
            out.write(this.getSelected());
        }
        out.write("';\n");
        out.write("function ");
        out.write(this.getFunctionName());
        out.write("(inputControl) {\n");
        out.write("if (m_");
        out.write(this.getFunctionName());
        out.write(" != '') {\n");
        out.write("   document.getElementById(m_");
        out.write(this.getFunctionName());
        out.write(").style.display = 'none';\n");
        out.write("}\nm_");
        out.write(this.getFunctionName());
        out.write(" = 'desc-' + inputControl.value;\n");
        out.write("document.getElementById(m_");
        out.write(this.getFunctionName());
        out.write(").style.display = 'inline';\n");
        out.write("} </script>\n");
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        List kids = this.getChildren();
        for (UIComponent child : kids) {
            if (child instanceof UIDescription) {
                this.renderDescription(context, ((UIDescription)child).getControlValue(), ((UIDescription)child).getText());
                continue;
            }
            if (!(child instanceof UIDescriptions)) continue;
            this.renderDescriptions(context, (UIDescriptions)child);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.selected = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.selected};
        return values;
    }

    private void renderDescription(FacesContext context, String controlId, String text) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.write("<span");
        String spanId = "desc-" + controlId;
        UIDynamicDescription.outputAttribute((ResponseWriter)out, (Object)spanId, (String)"id");
        if (controlId.equals(this.selected)) {
            UIDynamicDescription.outputAttribute((ResponseWriter)out, (Object)"display: inline", (String)"style");
        } else {
            UIDynamicDescription.outputAttribute((ResponseWriter)out, (Object)"display: none", (String)"style");
        }
        out.write(">");
        out.write(Utils.encode((String)text));
        out.write("</span>\n");
    }

    private void renderDescriptions(FacesContext context, UIDescriptions descriptions) throws IOException {
        block3: {
            Object obj;
            block2: {
                obj = descriptions.getValue();
                if (!(obj instanceof Map)) break block2;
                Map items = (Map)obj;
                for (String id : items.keySet()) {
                    this.renderDescription(context, id, (String)items.get(id));
                }
                break block3;
            }
            if (!(obj instanceof List)) break block3;
            for (UIDescription desc : (List)obj) {
                this.renderDescription(context, desc.getControlValue(), desc.getText());
            }
        }
    }
}

