/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.springframework.web.jsf.FacesContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemSelector
extends UIInput {
    private static final String MSG_GO_UP = "go_up";
    private static final String MSG_OK = "ok";
    private static final String MSG_CANCEL = "cancel";
    private static final String OK_BUTTON = "_ok";
    protected static final String OPTION = "_option";
    protected static final int MODE_BEFORE_SELECTION = 0;
    protected static final int MODE_INITIAL_SELECTION = 1;
    protected static final int MODE_DRILLDOWN_SELECTION = 2;
    protected static final int MODE_CONFIRM_SELECTION = 3;
    protected static final int MODE_CANCEL_SELECTION = 4;
    protected String label = null;
    protected Integer spacing = null;
    protected int mode = 0;
    protected String navigationId = null;
    protected String avmStore = null;
    protected String initialSelectionId = null;
    protected Boolean disabled;

    public AbstractItemSelector() {
        this.setRendererType(null);
    }

    public abstract String getFamily();

    public abstract String getDefaultLabel();

    public abstract String getParentNodeId(FacesContext var1);

    public abstract Collection<NodeRef> getChildrenForNode(FacesContext var1);

    public abstract Collection<NodeRef> getRootChildren(FacesContext var1);

    public abstract String getItemIcon(FacesContext var1, NodeRef var2);

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.label = (String)values[1];
        this.spacing = (Integer)values[2];
        this.mode = (Integer)values[3];
        this.navigationId = (String)values[4];
        this.initialSelectionId = (String)values[5];
        this.disabled = (Boolean)values[6];
        this.avmStore = (String)values[7];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.label, this.spacing, this.mode, this.navigationId, this.initialSelectionId, this.disabled, this.avmStore};
        return values;
    }

    public void decode(FacesContext context) {
        String selection;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String fieldId = this.getHiddenFieldName();
        String value = (String)requestMap.get(fieldId);
        int mode = this.mode;
        if (value != null && value.length() != 0) {
            String id = null;
            int sepIndex = value.indexOf(58);
            if (sepIndex != -1) {
                mode = Integer.parseInt(value.substring(0, sepIndex));
                if (value.length() > sepIndex + 1) {
                    id = value.substring(sepIndex + 1);
                }
            } else {
                mode = Integer.parseInt(value);
            }
            ItemSelectorEvent event = new ItemSelectorEvent((UIComponent)this, mode, id);
            this.queueEvent((FacesEvent)event);
        }
        if (mode == 3 && (selection = (String)requestMap.get(this.getClientId(context) + OPTION)) != null && selection.length() != 0) {
            if (selection.startsWith("-1;")) {
                String translatedPath = selection.substring(3);
                String path = translatedPath.replace(';', '/');
                String avmPath = this.avmStore + ":/" + path;
                this.setSubmittedValue(AVMNodeConverter.ToNodeRef((int)-1, (String)avmPath));
            } else {
                this.setSubmittedValue(new NodeRef(Repository.getStoreRef(), selection));
            }
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ItemSelectorEvent) {
            ItemSelectorEvent spaceEvent = (ItemSelectorEvent)event;
            this.mode = spaceEvent.Mode;
            this.navigationId = spaceEvent.Id;
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        NodeService service = AbstractItemSelector.getNodeService(context);
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            if (this.isDisabled()) {
                ResponseWriter out = context.getResponseWriter();
                NodeRef nodeRef = (NodeRef)this.getSubmittedValue();
                if (nodeRef == null) {
                    Object val = this.getValue();
                    if (val instanceof NodeRef) {
                        nodeRef = (NodeRef)val;
                    } else if (val instanceof String && ((String)val).length() != 0) {
                        nodeRef = new NodeRef((String)val);
                    } else if (val instanceof List) {
                        List nodes = (List)val;
                        StringBuilder buffer = new StringBuilder(64);
                        for (Object obj : nodes) {
                            if (buffer.length() != 0) {
                                buffer.append(", ");
                            }
                            if (obj instanceof NodeRef) {
                                buffer.append(Utils.encode((String)Repository.getNameForNode(service, (NodeRef)obj)));
                                continue;
                            }
                            buffer.append(obj.toString());
                        }
                        out.write(buffer.toString());
                    }
                }
                if (nodeRef != null) {
                    out.write(Utils.encode((String)Repository.getNameForNode(service, nodeRef)));
                }
            } else {
                String clientId = this.getClientId(context);
                StringBuilder buf = new StringBuilder(512);
                Map attrs = this.getAttributes();
                boolean showValueInHiddenField = false;
                NodeRef value = null;
                switch (this.mode) {
                    case 0: 
                    case 3: 
                    case 4: {
                        String fieldValue;
                        String label;
                        NodeRef submittedValue = (NodeRef)this.getSubmittedValue();
                        if (submittedValue != null) {
                            value = submittedValue;
                        } else {
                            Object val = this.getValue();
                            if (val instanceof NodeRef) {
                                value = (NodeRef)val;
                            } else if (val instanceof String && ((String)val).length() != 0) {
                                value = new NodeRef((String)val);
                            }
                        }
                        if (value == null) {
                            label = this.getLabel();
                            if (label == null) {
                                label = this.getDefaultLabel();
                            }
                        } else {
                            if (value.getStoreRef().getProtocol().equals("avm")) {
                                Pair avmNode = AVMNodeConverter.ToAVMVersionPath((NodeRef)value);
                                String avmPath = (String)avmNode.getSecond();
                                int rootPosition = avmPath.indexOf("ROOT");
                                if (rootPosition > 0) {
                                    label = avmPath.substring(rootPosition + "ROOT".length());
                                    if (label.length() == 0) {
                                        int storeEnd = avmPath.indexOf(":");
                                        label = storeEnd > 0 ? avmPath.substring(0, storeEnd) : "ROOT";
                                    }
                                } else {
                                    label = avmPath;
                                }
                            } else {
                                label = Repository.getNameForNode(service, value);
                            }
                            showValueInHiddenField = true;
                        }
                        buf.append("<span");
                        if (attrs.get("style") != null) {
                            buf.append(" style=\"").append(attrs.get("style")).append('\"');
                        }
                        if (attrs.get("styleClass") != null) {
                            buf.append(" class=").append(attrs.get("styleClass"));
                        }
                        buf.append(">");
                        int theMode = 1;
                        if (value == null && this.getInitialSelection() != null) {
                            value = new NodeRef(Repository.getStoreRef(), this.getInitialSelection());
                        }
                        if (value != null) {
                            fieldValue = this.encodeFieldValues(theMode, value.getId());
                            if (value.getStoreRef().getProtocol().equals("avm")) {
                                this.avmStore = value.getStoreRef().getIdentifier();
                            }
                        } else {
                            fieldValue = this.encodeFieldValues(theMode, null);
                        }
                        buf.append("<a href='#' onclick=\"");
                        buf.append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), fieldValue));
                        buf.append('\"');
                        if (attrs.get("nodeStyle") != null) {
                            buf.append(" style=\"").append(attrs.get("nodeStyle")).append('\"');
                        }
                        if (attrs.get("nodeStyleClass") != null) {
                            buf.append(" class=").append(attrs.get("nodeStyleClass"));
                        }
                        buf.append(">").append(Utils.encode((String)label)).append("</a></span>");
                        break;
                    }
                    case 1: 
                    case 2: {
                        buf.append("<table border=0 cellspacing=1 cellpadding=1");
                        if (attrs.get("style") != null) {
                            buf.append(" style=\"").append(attrs.get("style")).append('\"');
                        }
                        if (attrs.get("styleClass") != null) {
                            buf.append(" class=").append(attrs.get("styleClass"));
                        }
                        buf.append(">");
                        if (this.mode == 1) {
                            this.navigationId = this.getParentNodeId(context);
                        }
                        if (this.navigationId != null) {
                            String id = this.getParentNodeId(context);
                            buf.append("<tr><td></td><td>");
                            String upImage = Utils.buildImageTag(context, "/images/icons/up.gif", null, "absmiddle");
                            this.renderNodeLink(context, id, Application.getMessage(context, MSG_GO_UP), upImage, buf);
                            buf.append("</td></tr>");
                        }
                        String okButtonId = clientId + OK_BUTTON;
                        boolean okButtonEnabled = false;
                        Collection<NodeRef> childRefs = this.navigationId != null ? this.getChildrenForNode(context) : this.getRootChildren(context);
                        for (NodeRef childRef : childRefs) {
                            String childId = childRef.getId();
                            buf.append("<tr><td><input type='radio' name='").append(clientId).append(OPTION).append("' value='").append(childId).append("'");
                            if (childId.equals(this.initialSelectionId)) {
                                buf.append(" checked");
                                okButtonEnabled = true;
                                this.initialSelectionId = null;
                            }
                            buf.append(" onclick=\"javascript:document.getElementById('").append(okButtonId).append("').disabled=false;\"");
                            buf.append("/></td><td>");
                            String name = Repository.getNameForNode(service, childRef);
                            String prefixHtml = null;
                            String icon = this.getItemIcon(context, childRef);
                            if (icon != null) {
                                prefixHtml = "<span style='padding-right:4px'>" + Utils.buildImageTag(context, icon, null, "absmiddle") + "</span>";
                            }
                            this.renderNodeLink(context, childId, name, prefixHtml, buf);
                            buf.append("</td></tr>");
                        }
                        String fieldValue = this.encodeFieldValues(3, null);
                        buf.append("<tr style='padding-top:4px'><td></td><td align=center>").append("<input type='button' ").append(!okButtonEnabled ? "disabled" : "").append(" onclick=\"").append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), fieldValue)).append("\" value='").append(Application.getMessage(context, MSG_OK)).append("' id='").append(okButtonId).append("'>&nbsp;");
                        fieldValue = this.encodeFieldValues(4, null);
                        buf.append("<input type='button' onclick=\"").append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), fieldValue)).append("\" value='").append(Application.getMessage(context, MSG_CANCEL)).append("'></td></tr>");
                        buf.append("</table>");
                        break;
                    }
                }
                buf.append("<input type='hidden' name='");
                buf.append(clientId);
                buf.append("_selected' id='");
                buf.append(clientId);
                buf.append("_selected' value='");
                if (showValueInHiddenField) {
                    buf.append(value);
                }
                buf.append("'/>");
                context.getResponseWriter().write(buf.toString());
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public String getLabel() {
        ValueBinding vb = this.getValueBinding("label");
        if (vb != null) {
            this.label = (String)vb.getValue(this.getFacesContext());
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getSpacing() {
        ValueBinding vb = this.getValueBinding("spacing");
        if (vb != null) {
            this.spacing = (Integer)vb.getValue(this.getFacesContext());
        }
        if (this.spacing != null) {
            return (int)this.spacing;
        }
        return 2;
    }

    public void setSpacing(Integer spacing) {
        this.spacing = spacing;
    }

    public String getInitialSelection() {
        ValueBinding vb = this.getValueBinding("initialSelection");
        if (vb != null) {
            this.initialSelectionId = (String)vb.getValue(this.getFacesContext());
        }
        return this.initialSelectionId;
    }

    public void setInitialSelection(String initialSelection) {
        this.initialSelectionId = initialSelection;
    }

    public boolean isDisabled() {
        ValueBinding vb;
        if (this.disabled == null && (vb = this.getValueBinding("disabled")) != null) {
            this.disabled = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.disabled == null) {
            this.disabled = Boolean.FALSE;
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    protected String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    protected String encodeFieldValues(int mode, String id) {
        if (id != null) {
            return Integer.toString(mode) + ':' + id;
        }
        return Integer.toString(mode);
    }

    protected String renderNodeLink(FacesContext context, String id, String name, String prefix, StringBuilder buf) {
        buf.append("<a href='#' onclick=\"");
        String fieldValue = this.encodeFieldValues(2, id);
        buf.append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), fieldValue));
        buf.append('\"');
        Map attrs = this.getAttributes();
        if (attrs.get("nodeStyle") != null) {
            buf.append(" style=\"").append(attrs.get("nodeStyle")).append('\"');
        }
        if (attrs.get("nodeStyleClass") != null) {
            buf.append(" class=").append(attrs.get("nodeStyleClass"));
        }
        buf.append('>');
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append(Utils.encode((String)name));
        buf.append("</a>");
        return buf.toString();
    }

    protected static NodeService getNodeService(FacesContext context) {
        NodeService service = Repository.getServiceRegistry(context).getNodeService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain NodeService bean reference.");
        }
        return service;
    }

    protected static NodeService getFastNodeService(FacesContext context) {
        NodeService service = (NodeService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("nodeService");
        if (service == null) {
            throw new IllegalStateException("Unable to obtain NodeService bean reference.");
        }
        return service;
    }

    protected static DictionaryService getDictionaryService(FacesContext context) {
        DictionaryService service = Repository.getServiceRegistry(context).getDictionaryService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain DictionaryService bean reference.");
        }
        return service;
    }

    public static class ItemSelectorEvent
    extends ActionEvent {
        public int Mode;
        private String Id;

        public ItemSelectorEvent(UIComponent component, int mode, String id) {
            super(component);
            this.Mode = mode;
            this.Id = id;
        }
    }
}

