/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UINodeWorkflowInfo
extends SelfRenderingComponent {
    protected Node value = null;

    public String getFamily() {
        return "org.alfresco.faces.NodeWorkflowInfo";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (Node)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[8];
        values[0] = super.saveState(context);
        values[1] = this.value;
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        Node node = this.getValue();
        if (node != null) {
            NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
            DictionaryService ddService = Repository.getServiceRegistry(context).getDictionaryService();
            WorkflowService workflowService = Repository.getServiceRegistry(context).getWorkflowService();
            ResponseWriter out = context.getResponseWriter();
            ResourceBundle bundle = Application.getBundle(context);
            this.renderSimpleWorkflowInfo(context, node, nodeService, ddService, out, bundle);
            this.renderAdvancedWorkflowInfo(context, node, nodeService, ddService, workflowService, out, bundle);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
    }

    public Node getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = (Node)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(Node value) {
        this.value = value;
    }

    protected void renderSimpleWorkflowInfo(FacesContext context, Node node, NodeService nodeService, DictionaryService ddService, ResponseWriter out, ResourceBundle bundle) throws IOException {
        boolean isContent = true;
        QName type = nodeService.getType(node.getNodeRef());
        if (ddService.isSubClass(type, ContentModel.TYPE_FOLDER)) {
            isContent = false;
        }
        if (isContent) {
            out.write("<div class=\"nodeWorkflowInfoTitle\">");
            out.write(bundle.getString("simple_workflow"));
            out.write("</div>");
        }
        out.write("<div class=\"nodeWorkflowInfoText\">");
        if (node.hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            Map<String, Object> props = node.getProperties();
            String approveStepName = (String)props.get(ApplicationModel.PROP_APPROVE_STEP.toString());
            String rejectStepName = (String)props.get(ApplicationModel.PROP_REJECT_STEP.toString());
            Boolean approveMove = (Boolean)props.get(ApplicationModel.PROP_APPROVE_MOVE.toString());
            Boolean rejectMove = (Boolean)props.get(ApplicationModel.PROP_REJECT_MOVE.toString());
            NodeRef approveFolder = (NodeRef)props.get(ApplicationModel.PROP_APPROVE_FOLDER.toString());
            NodeRef rejectFolder = (NodeRef)props.get(ApplicationModel.PROP_REJECT_FOLDER.toString());
            String approveFolderName = null;
            String rejectFolderName = null;
            if (approveFolder != null) {
                Node approveNode = new Node(approveFolder);
                approveFolderName = approveNode.getName();
            }
            if (rejectFolder != null) {
                Node rejectNode = new Node(rejectFolder);
                rejectFolderName = rejectNode.getName();
            }
            String action = null;
            action = approveMove != false ? Application.getMessage(FacesContext.getCurrentInstance(), "moved") : Application.getMessage(FacesContext.getCurrentInstance(), "copied");
            String actionPattern = null;
            actionPattern = isContent ? Application.getMessage(FacesContext.getCurrentInstance(), "document_action") : Application.getMessage(FacesContext.getCurrentInstance(), "space_action");
            Object[] params = new Object[]{action, approveFolderName, Utils.encode((String)approveStepName)};
            out.write(Utils.encode((String)MessageFormat.format(actionPattern, params)));
            if (rejectStepName != null && rejectMove != null && rejectFolderName != null) {
                action = rejectMove != false ? Application.getMessage(FacesContext.getCurrentInstance(), "moved") : Application.getMessage(FacesContext.getCurrentInstance(), "copied");
                out.write("&nbsp;");
                params = new Object[]{action, rejectFolderName, Utils.encode((String)rejectStepName)};
                out.write(Utils.encode((String)MessageFormat.format(actionPattern, params)));
            }
        } else if (isContent) {
            out.write(bundle.getString("doc_not_in_simple_workflow"));
        } else {
            out.write(bundle.getString("space_not_in_simple_workflow"));
        }
        out.write("</div>");
    }

    protected void renderAdvancedWorkflowInfo(FacesContext context, Node node, NodeService nodeService, DictionaryService ddService, WorkflowService workflowService, ResponseWriter out, ResourceBundle bundle) throws IOException {
        boolean isContent = true;
        QName type = nodeService.getType(node.getNodeRef());
        if (ddService.isSubClass(type, ContentModel.TYPE_FOLDER)) {
            isContent = false;
        }
        if (isContent) {
            out.write("<div class=\"nodeWorkflowInfoTitle\">");
            out.write(bundle.getString("advanced_workflows"));
            out.write("</div><div class=\"nodeWorkflowInfoText\">");
            List workflows = workflowService.getWorkflowsForContent(node.getNodeRef(), true);
            if (workflows != null && workflows.size() > 0) {
                if (isContent) {
                    out.write(bundle.getString("doc_part_of_advanced_workflows"));
                } else {
                    out.write(bundle.getString("space_part_of_advanced_workflows"));
                }
                out.write(":<br/><ul>");
                for (WorkflowInstance wi : workflows) {
                    out.write("<li>");
                    out.write(wi.definition.title);
                    if (wi.description != null && wi.description.length() > 0) {
                        out.write("&nbsp;(");
                        out.write(Utils.encode((String)wi.description));
                        out.write(")");
                    }
                    out.write(" ");
                    if (wi.startDate != null) {
                        out.write(bundle.getString("started_on").toLowerCase());
                        out.write("&nbsp;");
                        out.write(Utils.getDateFormat(context).format(wi.startDate));
                        out.write(" ");
                    }
                    if (wi.initiator != null) {
                        out.write(bundle.getString("by"));
                        out.write("&nbsp;");
                        out.write(Utils.encode((String)User.getFullName(nodeService, wi.initiator)));
                        out.write(".");
                    }
                    out.write("</li>");
                }
                out.write("</ul>");
            } else if (isContent) {
                out.write(bundle.getString("doc_not_in_advanced_workflow"));
            } else {
                out.write(bundle.getString("space_not_in_advanced_workflow"));
            }
            out.write("</div>");
        }
    }
}

