/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.DataDictionary;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.jsf.FacesContextUtils;

public class UIProperty
extends PropertySheetItem {
    private static Log logger = LogFactory.getLog(UIProperty.class);
    private static Log missingPropsLogger = LogFactory.getLog((String)"alfresco.missingProperties");

    public UIProperty() {
        this.setRendererType("org.alfresco.faces.PropertyRenderer");
    }

    public String getFamily() {
        return "org.alfresco.faces.Property";
    }

    protected String getIncorrectParentMsg() {
        return "The property component must be nested within a property sheet component";
    }

    protected void generateItem(FacesContext context, UIPropertySheet propSheet) throws IOException {
        Node node = propSheet.getNode();
        String propertyName = this.getName();
        DataDictionary dd = (DataDictionary)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("dataDictionary");
        PropertyDefinition propDef = dd.getPropertyDefinition(node, propertyName);
        if (propDef == null) {
            if (node.hasProperty(propertyName) || !this.getIgnoreIfMissing()) {
                String displayLabel = this.getDisplayLabel();
                if (displayLabel == null) {
                    displayLabel = propertyName;
                }
                this.generateLabel(context, propSheet, displayLabel);
                this.generateControl(context, propSheet, propertyName);
            } else if (missingPropsLogger.isWarnEnabled()) {
                missingPropsLogger.warn((Object)("Failed to find property '" + propertyName + "' for node: " + node.getNodeRef().toString()));
            }
        } else {
            String displayLabel = this.getDisplayLabel();
            if (displayLabel == null && (displayLabel = propDef.getTitle()) == null) {
                displayLabel = propDef.getName().getLocalName();
            }
            this.generateLabel(context, propSheet, displayLabel);
            this.generateControl(context, propSheet, propDef);
        }
    }

    private void generateControl(FacesContext context, UIPropertySheet propSheet, PropertyDefinition propDef) {
        UIComponent control = null;
        DataTypeDefinition dataTypeDef = propDef.getDataType();
        QName typeName = dataTypeDef.getName();
        String componentGeneratorName = this.getComponentGenerator();
        if (componentGeneratorName == null) {
            componentGeneratorName = typeName.equals((Object)DataTypeDefinition.TEXT) ? "TextFieldGenerator" : (typeName.equals((Object)DataTypeDefinition.MLTEXT) ? "MultilingualTextFieldGenerator" : (typeName.equals((Object)DataTypeDefinition.BOOLEAN) ? "CheckboxGenerator" : (typeName.equals((Object)DataTypeDefinition.CATEGORY) ? "CategorySelectorGenerator" : (typeName.equals((Object)DataTypeDefinition.DATETIME) ? "DateTimePickerGenerator" : (typeName.equals((Object)DataTypeDefinition.DATE) ? "DatePickerGenerator" : "TextFieldGenerator")))));
        }
        control = FacesHelper.getComponentGenerator(context, componentGeneratorName).generateAndAdd(context, propSheet, this);
        if (propSheet.inEditMode() && (typeName.equals((Object)DataTypeDefinition.NODE_REF) || typeName.equals((Object)DataTypeDefinition.PATH) || typeName.equals((Object)DataTypeDefinition.CONTENT) || typeName.equals((Object)DataTypeDefinition.QNAME) || typeName.equals((Object)DataTypeDefinition.CHILD_ASSOC_REF) || typeName.equals((Object)DataTypeDefinition.ASSOC_REF))) {
            logger.warn((Object)("Setting property " + propDef.getName().toString() + " to read-only as it can not be edited"));
            control.getAttributes().put("disabled", Boolean.TRUE);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created control " + control + "(" + control.getClientId(context) + ") for '" + propDef.getName().toString() + "' and added it to component " + (Object)((Object)this)));
        }
    }

    private void generateControl(FacesContext context, UIPropertySheet propSheet, String propName) {
        String componentGeneratorName = this.getComponentGenerator();
        if (componentGeneratorName == null) {
            componentGeneratorName = "TextFieldGenerator";
        }
        UIComponent control = FacesHelper.getComponentGenerator(context, componentGeneratorName).generateAndAdd(context, propSheet, this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created control " + control + "(" + control.getClientId(context) + ") for '" + propName + "' and added it to component " + (Object)((Object)this)));
        }
    }
}

