/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.config.PropertySheetConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIAssociation;
import org.alfresco.web.ui.repo.component.property.UIChildAssociation;
import org.alfresco.web.ui.repo.component.property.UIProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPropertySheet
extends UIPanel
implements NamingContainer {
    public static final String VIEW_MODE = "view";
    public static final String EDIT_MODE = "edit";
    private static Log logger = LogFactory.getLog(UIPropertySheet.class);
    private static String DEFAULT_VAR_NAME = "node";
    private static String PROP_ID_PREFIX = "prop_";
    private static String ASSOC_ID_PREFIX = "assoc_";
    private static String SEP_ID_PREFIX = "sep_";
    protected List<ClientValidation> validations = new ArrayList<ClientValidation>();
    private String variable;
    private NodeRef nodeRef;
    private Node node;
    private Boolean readOnly;
    private Boolean validationEnabled;
    private String mode;
    private String configArea;
    private String nextButtonId;
    private String finishButtonId;

    public UIPropertySheet() {
        this.setRendererType("javax.faces.Grid");
    }

    public String getFamily() {
        return "javax.faces.Panel";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        int howManyChildren = this.getChildren().size();
        Boolean externalConfig = (Boolean)this.getAttributes().get("externalConfig");
        if (this.variable == null) {
            this.variable = DEFAULT_VAR_NAME;
        }
        Node node = this.getNode();
        if (howManyChildren == 0) {
            if (externalConfig != null && externalConfig.booleanValue()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Configuring property sheet using ConfigService");
                }
                ConfigService configSvc = Application.getConfigService(FacesContext.getCurrentInstance());
                Config configProps = null;
                configProps = this.getConfigArea() == null ? configSvc.getConfig((Object)node) : configSvc.getConfig((Object)node, new ConfigLookupContext(this.getConfigArea()));
                PropertySheetConfigElement itemsToDisplay = (PropertySheetConfigElement)configProps.getConfigElement("property-sheet");
                if (itemsToDisplay != null) {
                    Collection<PropertySheetConfigElement.ItemConfig> itemsToRender = null;
                    if (this.getMode().equalsIgnoreCase(EDIT_MODE)) {
                        itemsToRender = itemsToDisplay.getEditableItemsToShow().values();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Items to render: " + itemsToDisplay.getEditableItemNamesToShow()));
                        }
                    } else {
                        itemsToRender = itemsToDisplay.getItemsToShow().values();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Items to render: " + itemsToDisplay.getItemNamesToShow()));
                        }
                    }
                    this.createComponentsFromConfig(context, itemsToRender);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"There are no items to render!");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Configuring property sheet using node's current state");
                }
                this.createComponentsFromNode(context, node);
            }
        }
        Map sessionMap = this.getFacesContext().getExternalContext().getSessionMap();
        sessionMap.put(this.variable, node);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Put node into session with key '" + this.variable + "': " + node));
        }
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        if (this.isValidationEnabled() && this.validations.size() > 0) {
            this.renderValidationScript(context);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.nodeRef = (NodeRef)values[1];
        this.node = (Node)values[2];
        this.variable = (String)values[3];
        this.readOnly = (Boolean)values[4];
        this.mode = (String)values[5];
        this.configArea = (String)values[6];
        this.validationEnabled = (Boolean)values[7];
        this.validations = (List)values[8];
        this.finishButtonId = (String)values[9];
        this.nextButtonId = (String)values[10];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.nodeRef, this.node, this.variable, this.readOnly, this.mode, this.configArea, this.validationEnabled, this.validations, this.finishButtonId, this.nextButtonId};
        return values;
    }

    public Node getNode() {
        Node node = null;
        if (this.node == null) {
            ValueBinding vb;
            Object value = this.getAttributes().get("value");
            if (value == null && (vb = this.getValueBinding("value")) != null) {
                value = vb.getValue(this.getFacesContext());
            }
            if (value instanceof Node) {
                node = (Node)value;
            }
        } else {
            node = this.node;
        }
        return node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getVar() {
        return this.variable;
    }

    public void setVar(String variable) {
        this.variable = variable;
    }

    public boolean isReadOnly() {
        ValueBinding vb;
        if (this.readOnly == null && (vb = this.getValueBinding("readOnly")) != null) {
            this.readOnly = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.readOnly == null) {
            this.readOnly = Boolean.FALSE;
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isValidationEnabled() {
        ValueBinding vb;
        if (!this.inEditMode()) {
            return false;
        }
        if (this.validationEnabled == null && (vb = this.getValueBinding("validationEnabled")) != null) {
            this.validationEnabled = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.validationEnabled == null) {
            this.validationEnabled = Boolean.TRUE;
        }
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public String getFinishButtonId() {
        if (this.finishButtonId == null) {
            this.finishButtonId = "finish-button";
        }
        return this.finishButtonId;
    }

    public void setFinishButtonId(String finishButtonId) {
        this.finishButtonId = finishButtonId;
    }

    public String getNextButtonId() {
        return this.nextButtonId;
    }

    public void setNextButtonId(String nextButtonId) {
        this.nextButtonId = nextButtonId;
    }

    public String getMode() {
        ValueBinding vb;
        if (this.mode == null && (vb = this.getValueBinding("mode")) != null) {
            this.mode = (String)vb.getValue(this.getFacesContext());
        }
        if (this.mode == null) {
            this.mode = EDIT_MODE;
        }
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean inEditMode() {
        return this.getMode().equalsIgnoreCase(EDIT_MODE);
    }

    public String getConfigArea() {
        ValueBinding vb;
        if (this.configArea == null && (vb = this.getValueBinding("configArea")) != null) {
            this.configArea = (String)vb.getValue(this.getFacesContext());
        }
        return this.configArea;
    }

    public void setConfigArea(String configArea) {
        this.configArea = configArea;
    }

    public void addClientValidation(ClientValidation validation) {
        this.validations.add(validation);
    }

    public List<ClientValidation> getClientValidations() {
        return this.validations;
    }

    protected void renderValidationScript(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        UIForm form = Utils.getParentForm(context, (UIComponent)this);
        out.write("\n<script type='text/javascript' src='");
        out.write(context.getExternalContext().getRequestContextPath());
        out.write("/scripts/validation.js");
        out.write("'></script>\n<script type='text/javascript'>\n");
        out.write("var finishButtonPressed = false;\n");
        out.write("var nextButtonPressed = false;\n");
        out.write("function validate()\n{\n   var result = true;\n   ");
        out.write("if ((finishButtonPressed || nextButtonPressed) && (");
        int numberValidations = this.validations.size();
        ArrayList<ClientValidation> realTimeValidations = new ArrayList<ClientValidation>(numberValidations);
        for (int x = 0; x < numberValidations; ++x) {
            ClientValidation validation = this.validations.get(x);
            if (validation.RealTimeChecking) {
                realTimeValidations.add(validation);
            }
            this.renderValidationMethod(out, validation, x == numberValidations - 1, true);
        }
        out.write(")\n   { result = false; }\n\n");
        out.write("   finishButtonPressed = false;\n   nextButtonPressed = false;\n");
        out.write("   return result;\n}\n\n");
        int numberRealTimeValidations = realTimeValidations.size();
        if (numberRealTimeValidations > 0) {
            out.write("function processButtonState()\n{\n   if (");
            for (int x = 0; x < numberRealTimeValidations; ++x) {
                this.renderValidationMethod(out, (ClientValidation)realTimeValidations.get(x), x == numberRealTimeValidations - 1, false);
            }
            out.write("\n   {\n      document.getElementById('");
            out.write(form.getClientId(context));
            out.write(58);
            out.write(this.getFinishButtonId());
            out.write("').disabled = true; \n");
            if (this.nextButtonId != null && this.nextButtonId.length() > 0) {
                out.write("      document.getElementById('");
                out.write(form.getClientId(context));
                out.write(58);
                out.write(this.nextButtonId);
                out.write("').disabled = true; \n");
            }
            out.write("   }\n");
            out.write("   else\n   {\n      document.getElementById('");
            out.write(form.getClientId(context));
            out.write(58);
            out.write(this.getFinishButtonId());
            out.write("').disabled = false;");
            if (this.nextButtonId != null && this.nextButtonId.length() > 0) {
                out.write("\n      document.getElementById('");
                out.write(form.getClientId(context));
                out.write(58);
                out.write(this.nextButtonId);
                out.write("').disabled = false;");
            }
            out.write("\n   }\n}\n\n");
        }
        out.write("function initValidation()\n{\n");
        out.write("   document.getElementById('");
        out.write(form.getClientId(context));
        out.write("').onsubmit = validate;\n");
        out.write("   document.getElementById('");
        out.write(form.getClientId(context));
        out.write(58);
        out.write(this.getFinishButtonId());
        out.write("').onclick = function() { finishButtonPressed = true; }\n");
        if (this.nextButtonId != null && this.nextButtonId.length() > 0) {
            out.write("   document.getElementById('");
            out.write(form.getClientId(context));
            out.write(58);
            out.write(this.nextButtonId);
            out.write("').onclick = function() { nextButtonPressed = true; }\n");
        }
        if (numberRealTimeValidations > 0) {
            out.write("   processButtonState();\n");
        }
        out.write("}\n\n");
        out.write("window.onload=initValidation;\n");
        out.write("</script>\n");
    }

    protected void renderValidationMethod(ResponseWriter out, ClientValidation validation, boolean lastMethod, boolean showMessage) throws IOException {
        out.write("!");
        out.write(validation.Type);
        out.write("(");
        int numberParams = validation.Params.size();
        for (int p = 0; p < numberParams; ++p) {
            out.write(validation.Params.get(p));
            if (p == numberParams - 1) continue;
            out.write(", ");
        }
        out.write(", ");
        out.write(Boolean.toString(showMessage));
        out.write(")");
        if (lastMethod) {
            out.write(")");
        } else {
            out.write(" || ");
        }
    }

    private void createComponentsFromNode(FacesContext context, Node node) throws IOException {
        Map<String, Object> props = node.getProperties();
        for (String propertyName : props.keySet()) {
            UIProperty propComp = (UIProperty)context.getApplication().createComponent("org.alfresco.faces.Property");
            QName qname = QName.createQName((String)propertyName);
            String prefixPropName = qname.toPrefixString();
            FacesHelper.setupComponentId(context, (UIComponent)propComp, PROP_ID_PREFIX + prefixPropName);
            propComp.setName(prefixPropName);
            if (this.isReadOnly()) {
                propComp.setReadOnly(true);
            }
            this.getChildren().add(propComp);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Created property component " + (Object)((Object)propComp) + "(" + propComp.getClientId(context) + ") for '" + prefixPropName + "' and added it to property sheet " + (Object)((Object)this)));
        }
        Map associations = node.getAssociations();
        for (String assocName : associations.keySet()) {
            UIAssociation assocComp = (UIAssociation)context.getApplication().createComponent("org.alfresco.faces.Association");
            QName qname = QName.createQName((String)assocName);
            String prefixAssocName = qname.toPrefixString();
            FacesHelper.setupComponentId(context, (UIComponent)assocComp, ASSOC_ID_PREFIX + prefixAssocName);
            assocComp.setName(prefixAssocName);
            if (this.isReadOnly()) {
                assocComp.setReadOnly(true);
            }
            this.getChildren().add(assocComp);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Created association component " + (Object)((Object)assocComp) + "(" + assocComp.getClientId(context) + ") for '" + prefixAssocName + "' and added it to property sheet " + (Object)((Object)this)));
        }
        Map childAssociations = node.getChildAssociations();
        for (String assocName : childAssociations.keySet()) {
            UIChildAssociation childAssocComp = (UIChildAssociation)context.getApplication().createComponent("org.alfresco.faces.ChildAssociation");
            FacesHelper.setupComponentId(context, (UIComponent)childAssocComp, ASSOC_ID_PREFIX + assocName);
            childAssocComp.setName(assocName);
            if (this.isReadOnly()) {
                childAssocComp.setReadOnly(true);
            }
            this.getChildren().add(childAssocComp);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Created child association component " + (Object)((Object)childAssocComp) + "(" + childAssocComp.getClientId(context) + ") for '" + assocName + "' and added it to property sheet " + (Object)((Object)this)));
        }
    }

    private void createComponentsFromConfig(FacesContext context, Collection<PropertySheetConfigElement.ItemConfig> items) throws IOException {
        for (PropertySheetConfigElement.ItemConfig item : items) {
            String label;
            String id = null;
            PropertySheetItem propSheetItem = null;
            if (item instanceof PropertySheetConfigElement.PropertyConfig) {
                id = PROP_ID_PREFIX + item.getName();
                propSheetItem = (PropertySheetItem)context.getApplication().createComponent("org.alfresco.faces.Property");
            } else if (item instanceof PropertySheetConfigElement.AssociationConfig) {
                id = ASSOC_ID_PREFIX + item.getName();
                propSheetItem = (PropertySheetItem)context.getApplication().createComponent("org.alfresco.faces.Association");
            } else if (item instanceof PropertySheetConfigElement.ChildAssociationConfig) {
                id = ASSOC_ID_PREFIX + item.getName();
                propSheetItem = (PropertySheetItem)context.getApplication().createComponent("org.alfresco.faces.ChildAssociation");
            } else if (item instanceof PropertySheetConfigElement.SeparatorConfig) {
                id = SEP_ID_PREFIX + item.getName();
                propSheetItem = (PropertySheetItem)context.getApplication().createComponent("org.alfresco.faces.Separator");
            }
            if (propSheetItem == null) continue;
            FacesHelper.setupComponentId(context, propSheetItem, id);
            propSheetItem.setName(item.getName());
            propSheetItem.setConverter(item.getConverter());
            propSheetItem.setComponentGenerator(item.getComponentGenerator());
            propSheetItem.setIgnoreIfMissing(item.getIgnoreIfMissing());
            String displayLabel = item.getDisplayLabel();
            if (item.getDisplayLabelId() != null && (label = Application.getMessage(context, item.getDisplayLabelId())) != null) {
                displayLabel = label;
            }
            propSheetItem.setDisplayLabel(displayLabel);
            if (this.isReadOnly() || item.isReadOnly()) {
                propSheetItem.setReadOnly(true);
            }
            this.getChildren().add(propSheetItem);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Created property sheet item component " + (Object)((Object)propSheetItem) + "(" + propSheetItem.getClientId(context) + ") for '" + item.getName() + "' and added it to property sheet " + (Object)((Object)this)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClientValidation
    implements Serializable {
        public String Type;
        public List<String> Params;
        public boolean RealTimeChecking;

        public ClientValidation(String type, List<String> params, boolean realTimeChecking) {
            this.Type = type;
            this.Params = params;
            this.RealTimeChecking = realTimeChecking;
        }
    }
}

