/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.shelf;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.shelf.UIShelfGroup;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIShelf
extends SelfRenderingComponent {
    private String groupPanel;
    private String groupBgcolor;
    private String selectedGroupPanel;
    private String selectedGroupBgcolor;
    private String innerGroupPanel;
    private String innerGroupBgcolor;
    private MethodBinding groupExpandedActionListener;

    public String getFamily() {
        return "org.alfresco.faces.Shelf";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.groupPanel = (String)values[1];
        this.groupBgcolor = (String)values[2];
        this.selectedGroupPanel = (String)values[3];
        this.selectedGroupBgcolor = (String)values[4];
        this.innerGroupPanel = (String)values[5];
        this.innerGroupBgcolor = (String)values[6];
        this.groupExpandedActionListener = (MethodBinding)UIShelf.restoreAttachedState((FacesContext)context, (Object)values[7]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.groupPanel, this.groupBgcolor, this.selectedGroupPanel, this.selectedGroupBgcolor, this.innerGroupPanel, this.innerGroupBgcolor, UIShelf.saveAttachedState((FacesContext)context, (Object)this.groupExpandedActionListener)};
        return values;
    }

    public void setGroupExpandedActionListener(MethodBinding binding) {
        this.groupExpandedActionListener = binding;
    }

    public MethodBinding getGroupExpandedActionListener() {
        return this.groupExpandedActionListener;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName());
        if (value != null && value.length() != 0) {
            int sepIndex = value.indexOf(58);
            int groupIndex = Integer.parseInt(value.substring(0, sepIndex));
            boolean expanded = Boolean.parseBoolean(value.substring(sepIndex + 1));
            ShelfEvent event = new ShelfEvent((UIComponent)this, groupIndex, expanded);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ShelfEvent) {
            ShelfEvent shelfEvent = (ShelfEvent)event;
            int index = 0;
            for (UIComponent child : this.getChildren()) {
                if (index == shelfEvent.Index && child instanceof UIShelfGroup) {
                    ((UIShelfGroup)child).setExpanded(shelfEvent.Expanded);
                    break;
                }
                ++index;
            }
            if (this.getGroupExpandedActionListener() != null) {
                Utils.processActionMethod(this.getFacesContext(), this.getGroupExpandedActionListener(), shelfEvent);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("<div id=\"shelf\" class=\"shelf\">");
        out.write("<table border=\"0\" cellspacing=\"4\" cellpadding=\"0\" width=\"100%\">");
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        int index = 0;
        for (UIComponent child : this.getChildren()) {
            UIShelfGroup group;
            if (child instanceof UIShelfGroup && (group = (UIShelfGroup)child).isRendered()) {
                String groupBgcolor;
                String groupPanel;
                boolean isExpanded = group.isExpanded();
                out.write("<tr><td>");
                String contextPath = context.getExternalContext().getRequestContextPath();
                if (!isExpanded) {
                    groupPanel = this.getGroupPanel();
                    groupBgcolor = this.getGroupBgcolor();
                } else {
                    groupPanel = this.getSelectedGroupPanel();
                    groupBgcolor = this.getSelectedGroupBgcolor();
                }
                if (groupBgcolor == null) {
                    groupBgcolor = "#FFFFFF";
                }
                if (groupPanel != null) {
                    PanelGenerator.generatePanelStart((Writer)out, contextPath, groupPanel, groupBgcolor);
                }
                out.write("<div style='padding-top:2px;padding-bottom:4px'><nobr>");
                out.write("<a href='#' onclick=\"");
                String value = Integer.toString(index) + ':' + Boolean.toString(!isExpanded);
                out.write(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), value));
                out.write("\">");
                if (isExpanded) {
                    out.write(Utils.buildImageTag(context, "/images/icons/expanded.gif", 11, 11, ""));
                } else {
                    out.write(Utils.buildImageTag(context, "/images/icons/collapsed.gif", 11, 11, ""));
                }
                out.write("</a>&nbsp;");
                String label = group.getLabel();
                out.write("<span");
                UIShelf.outputAttribute((ResponseWriter)out, group.getAttributes().get("style"), (String)"style");
                UIShelf.outputAttribute((ResponseWriter)out, group.getAttributes().get("styleClass"), (String)"class");
                out.write(62);
                out.write(Utils.encode((String)label));
                out.write("</span>");
                out.write("</nobr></div>");
                if (isExpanded) {
                    String innerGroupPanel = this.getInnerGroupPanel();
                    String innerGroupBgcolor = this.getInnerGroupBgcolor();
                    if (innerGroupBgcolor == null) {
                        innerGroupBgcolor = "#FFFFFF";
                    }
                    if (innerGroupPanel != null) {
                        PanelGenerator.generatePanelStart((Writer)out, contextPath, innerGroupPanel, innerGroupBgcolor);
                    }
                    Utils.encodeRecursive(context, (UIComponent)group);
                    if (innerGroupPanel != null) {
                        PanelGenerator.generatePanelEnd((Writer)out, contextPath, innerGroupPanel);
                    }
                }
                PanelGenerator.generatePanelEnd((Writer)out, contextPath, groupPanel);
                out.write("</td></tr>");
            }
            ++index;
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("</table></div>");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getGroupPanel() {
        ValueBinding vb = this.getValueBinding("groupPanel");
        if (vb != null) {
            this.groupPanel = (String)vb.getValue(this.getFacesContext());
        }
        return this.groupPanel;
    }

    public void setGroupPanel(String groupPanel) {
        this.groupPanel = groupPanel;
    }

    public String getGroupBgcolor() {
        ValueBinding vb = this.getValueBinding("groupBgcolor");
        if (vb != null) {
            this.groupBgcolor = (String)vb.getValue(this.getFacesContext());
        }
        return this.groupBgcolor;
    }

    public void setGroupBgcolor(String groupBgcolor) {
        this.groupBgcolor = groupBgcolor;
    }

    public String getSelectedGroupPanel() {
        ValueBinding vb = this.getValueBinding("selectedGroupPanel");
        if (vb != null) {
            this.selectedGroupPanel = (String)vb.getValue(this.getFacesContext());
        }
        return this.selectedGroupPanel;
    }

    public void setSelectedGroupPanel(String selectedGroupPanel) {
        this.selectedGroupPanel = selectedGroupPanel;
    }

    public String getSelectedGroupBgcolor() {
        ValueBinding vb = this.getValueBinding("selectedGroupBgcolor");
        if (vb != null) {
            this.selectedGroupBgcolor = (String)vb.getValue(this.getFacesContext());
        }
        return this.selectedGroupBgcolor;
    }

    public void setSelectedGroupBgcolor(String selectedGroupBgcolor) {
        this.selectedGroupBgcolor = selectedGroupBgcolor;
    }

    public String getInnerGroupPanel() {
        ValueBinding vb = this.getValueBinding("innerGroupPanel");
        if (vb != null) {
            this.innerGroupPanel = (String)vb.getValue(this.getFacesContext());
        }
        return this.innerGroupPanel;
    }

    public void setInnerGroupPanel(String innerGroupPanel) {
        this.innerGroupPanel = innerGroupPanel;
    }

    public String getInnerGroupBgcolor() {
        ValueBinding vb = this.getValueBinding("innerGroupBgcolor");
        if (vb != null) {
            this.innerGroupBgcolor = (String)vb.getValue(this.getFacesContext());
        }
        return this.innerGroupBgcolor;
    }

    public void setInnerGroupBgcolor(String innerGroupBgcolor) {
        this.innerGroupBgcolor = innerGroupBgcolor;
    }

    private String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    public static class ShelfEvent
    extends ActionEvent {
        public boolean Expanded;
        public int Index;

        public ShelfEvent(UIComponent component, int index, boolean expanded) {
            super(component);
            this.Expanded = expanded;
            this.Index = index;
        }
    }
}

